/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.Template;
import dev.dfonline.flint.templates.argument.abstracts.Argument;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Arguments {
    private final Set<Argument> arguments = new HashSet<Argument>();

    public static Arguments fromJson(JsonArray args) {
        Arguments arguments = new Arguments();
        for (JsonElement arg : args) {
            JsonObject argObj = arg.getAsJsonObject();
            arguments.arguments.add(Argument.fromJson(argObj));
        }
        return arguments;
    }

    public List<Argument> getOrderedListWithEmpties() {
        ArrayList<Argument> list = new ArrayList<Argument>();
        List<Argument> temp = this.getOrderedList();
        int tempIndex = 0;
        boolean empties = false;
        for (int i = 0; i < 27; ++i) {
            if (tempIndex < temp.size() && temp.get(tempIndex).getSlot() == i) {
                list.add(temp.get(tempIndex));
                ++tempIndex;
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public List<Argument> getOrderedList() {
        return this.arguments.stream().sorted((arg1, arg2) -> {
            if (arg1.getSlot() == arg2.getSlot()) {
                return 0;
            }
            return arg1.getSlot() - arg2.getSlot();
        }).toList();
    }

    public void printToChat() {
        Template.print(" Arguments: ");
        if (this.arguments.isEmpty()) {
            Template.print("  - null");
            return;
        }
        for (Argument argument : this.arguments) {
            Template.print("  -" + String.valueOf(argument));
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray items = new JsonArray();
        for (Argument argument : this.getOrderedList()) {
            JsonObject argumentJson = argument.toJSON();
            items.add((JsonElement)argumentJson);
        }
        json.add("items", (JsonElement)items);
        return json;
    }

    public String toString() {
        return "Arguments []";
    }

    public void add(Argument argument) {
        this.arguments.add(argument);
    }
}

