/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;

public class GameValueArgument
extends Argument {
    private GameValueTarget target;
    private String type;

    public GameValueArgument(JsonObject json, JsonObject data) {
        super(json);
        this.target = GameValueTarget.fromString(data.get("target").getAsString());
        this.type = data.get("type").getAsString();
    }

    public GameValueArgument(int slot, String type, GameValueTarget target) {
        super(slot);
        this.target = target;
        this.type = type;
    }

    public GameValueTarget getTarget() {
        return this.target;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "GameValue [target=" + String.valueOf((Object)this.target) + ", type=" + this.type + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("target", this.target.name);
        data.addProperty("type", this.type);
        return data;
    }

    @Override
    public String getID() {
        return "g_val";
    }

    public static enum GameValueTarget {
        NO_TARGET("Default"),
        DEFAULT("Default"),
        SELECTION("Selection"),
        KILLER("Killer"),
        DAMAGER("Damage"),
        VICTIM("Victim"),
        SHOOTER("Shooter"),
        PROJECTILE("Projectile"),
        LAST_ENTITY("LastEntity");

        public final String name;

        private GameValueTarget(String name) {
            this.name = name;
        }

        public static GameValueTarget fromString(String name) {
            for (GameValueTarget target : GameValueTarget.values()) {
                if (!target.name.equals(name)) continue;
                return target;
            }
            return DEFAULT;
        }
    }
}

