/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;
import org.jetbrains.annotations.Nullable;

public class ParameterArgument
extends Argument {
    private String name;
    private ParameterType type;
    private boolean optional;
    private boolean plural;
    private Argument defaultValue;

    public ParameterArgument(JsonObject json, JsonObject data) {
        super(json);
        this.name = data.get("name").getAsString();
        this.type = ParameterType.fromName(data.get("type").getAsString());
        this.optional = data.get("optional").getAsBoolean();
        this.plural = data.get("plural").getAsBoolean();
        if (data.has("default_value")) {
            this.defaultValue = Argument.fromJson(data.get("default_value").getAsJsonObject(), -1);
        }
    }

    public ParameterArgument(int slot, String name, ParameterType type, boolean optional, boolean plural, @Nullable Argument defaultValue) {
        super(slot);
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.plural = plural;
        this.defaultValue = defaultValue;
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("name", this.name);
        data.addProperty("type", this.type.name);
        data.addProperty("optional", Boolean.valueOf(this.optional));
        data.addProperty("plural", Boolean.valueOf(this.plural));
        if (this.defaultValue != null) {
            JsonObject defaultData = this.defaultValue.toJSON();
            data.add("default_value", defaultData.get("item"));
        }
        return data;
    }

    @Override
    public String getID() {
        return "pn_el";
    }

    @Override
    public String toString() {
        return "Paramter [name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", optional=" + this.optional + ", plural=" + this.plural + ", default_value=" + String.valueOf(this.defaultValue) + " " + super.toString() + "]";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isPlural() {
        return this.plural;
    }

    public void setPlural(boolean plural) {
        this.plural = plural;
    }

    public Argument getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Argument defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static enum ParameterType {
        ANY_VALUE("any"),
        VARIABLE("var"),
        LIST("list"),
        DICTIONARY("dict"),
        NUMBER("num"),
        TEXT("comp"),
        STRING("txt"),
        SOUND("snd"),
        VECTOR("vec"),
        LOCATION("loc"),
        PARTICLE("part"),
        POTION("pot"),
        ITEM("item");

        public final String name;

        private ParameterType(String name) {
            this.name = name;
        }

        public static ParameterType fromName(String name) {
            for (ParameterType type : ParameterType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

