/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;

public class SoundArgument
extends Argument {
    private String sound;
    private double pitch;
    private double volume;
    private String variant = null;

    public SoundArgument(JsonObject json, JsonObject data) {
        super(json);
        this.pitch = data.get("pitch").getAsDouble();
        this.volume = data.get("vol").getAsDouble();
        this.sound = data.get("sound").getAsString();
        if (data.has("variant")) {
            this.variant = data.get("variant").getAsString();
        }
    }

    public SoundArgument(int slot, String sound, double pitch, double volume, String variant) {
        super(slot);
        this.sound = sound;
        this.pitch = pitch;
        this.volume = volume;
        this.variant = variant;
    }

    @Override
    public String toString() {
        return "Sound [sound=" + this.sound + ", pitch=" + this.pitch + ", volume=" + this.volume + ", variant" + this.variant + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("pitch", (Number)this.pitch);
        data.addProperty("vol", (Number)this.volume);
        data.addProperty("sound", this.sound);
        if (this.variant != null) {
            data.addProperty("variant", this.variant);
        }
        return data;
    }

    @Override
    public String getID() {
        return "snd";
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }
}

