/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument.abstracts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.JSONable;
import dev.dfonline.flint.templates.argument.ExpressionArgument;
import dev.dfonline.flint.templates.argument.GameValueArgument;
import dev.dfonline.flint.templates.argument.HintArgument;
import dev.dfonline.flint.templates.argument.ItemArgument;
import dev.dfonline.flint.templates.argument.LocationArgument;
import dev.dfonline.flint.templates.argument.NumberArgument;
import dev.dfonline.flint.templates.argument.ParameterArgument;
import dev.dfonline.flint.templates.argument.ParticleArgument;
import dev.dfonline.flint.templates.argument.PotionArgument;
import dev.dfonline.flint.templates.argument.SoundArgument;
import dev.dfonline.flint.templates.argument.StringArgument;
import dev.dfonline.flint.templates.argument.TagArgument;
import dev.dfonline.flint.templates.argument.TextArgument;
import dev.dfonline.flint.templates.argument.VariableArgument;
import dev.dfonline.flint.templates.argument.VectorArgument;

public abstract class Argument
implements JSONable {
    protected int slot;

    protected Argument(JsonObject json) {
        this.slot = json.get("slot").getAsInt();
    }

    protected Argument(int slot) {
        this.slot = slot;
    }

    public static Argument fromJson(JsonObject json) {
        JsonObject item = json.get("item").getAsJsonObject();
        JsonObject data = item.get("data").getAsJsonObject();
        return switch (item.get("id").getAsString()) {
            case "txt" -> new StringArgument(json, data);
            case "comp" -> new TextArgument(json, data);
            case "num" -> new NumberArgument(json, data);
            case "loc" -> new LocationArgument(json, data);
            case "vec" -> new VectorArgument(json, data);
            case "snd" -> new SoundArgument(json, data);
            case "part" -> new ParticleArgument(json, data);
            case "g_val" -> new GameValueArgument(json, data);
            case "var" -> new VariableArgument(json, data);
            case "hint" -> new HintArgument(json, data);
            case "item" -> new ItemArgument(json, data);
            case "bl_tag" -> new TagArgument(json, data);
            case "pn_el" -> new ParameterArgument(json, data);
            case "pot" -> new PotionArgument(json, data);
            case "expr" -> new ExpressionArgument(json, data);
            default -> null;
        };
    }

    public static Argument fromJson(JsonObject json, int slot) {
        JsonObject data = new JsonObject();
        data.addProperty("slot", (Number)slot);
        data.add("item", (JsonElement)json);
        return Argument.fromJson(data);
    }

    public String toString() {
        return "slot=" + this.slot;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("slot", (Number)this.slot);
        JsonObject item = new JsonObject();
        JsonObject data = this.getData();
        item.add("data", (JsonElement)data);
        item.addProperty("id", this.getID());
        json.add("item", (JsonElement)item);
        return json;
    }

    protected abstract JsonObject getData();

    public abstract String getID();

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }
}

