/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.codeblock;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.CodeBlock;

public class Bracket
extends CodeBlock {
    private Type type;
    private Direction direction;

    @Override
    public String getID() {
        return "bracket";
    }

    @Override
    public String getBlock() {
        return null;
    }

    public Bracket(Type type, Direction direction) {
        this.type = type;
        this.direction = direction;
    }

    public Bracket(JsonObject json) {
        this.direction = json.get("direct").getAsString().equals("open") ? Direction.OPEN : Direction.CLOSE;
        this.type = json.get("type").getAsString().equals("norm") ? Type.NORMAL : Type.REPEAT;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.name);
        json.addProperty("direct", this.direction.name);
        return super.toJSON(json);
    }

    public String toString() {
        return "Bracket[type=" + String.valueOf((Object)this.type) + ", direction=" + String.valueOf((Object)this.direction) + "]";
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public static enum Type {
        NORMAL("norm"),
        REPEAT("repeat");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }

    public static enum Direction {
        OPEN("open"),
        CLOSE("close");

        public final String name;

        private Direction(String name) {
            this.name = name;
        }
    }
}

