/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.util.Logger;
import dev.dfonline.flint.util.PaletteColor;
import dev.dfonline.flint.util.message.impl.prefix.InfoMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;

public final class FlintUpdate {
    private static final Logger LOGGER = Logger.of(FlintUpdate.class);
    private static final String MOD_REPOSITORY = "DFOnline/Flint";
    private static final String MODRINTH_URL = "https://modrinth.com/mod/flint/versions";
    private static final String MOD_VERSION = FlintUpdate.getCurrentVersion();
    private static String latestVersion;

    private FlintUpdate() {
    }

    public static void fetchLatestRelease() {
        String url = String.format("https://api.github.com/repos/%s/releases/latest", MOD_REPOSITORY);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
            ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(responseBody -> {
                JsonObject jsonResponse = JsonParser.parseString((String)responseBody).getAsJsonObject();
                latestVersion = jsonResponse.get("tag_name").getAsString();
                LOGGER.info("Latest version: {}", latestVersion);
            })).exceptionally(e -> {
                LOGGER.error("Error while fetching version", (Throwable)e);
                return null;
            });
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getCurrentVersion() {
        try (InputStream input = Flint.class.getClassLoader().getResourceAsStream("flint_version.txt");){
            String string;
            if (input == null) {
                String string2 = "unknown";
                return string2;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                string = reader.readLine();
            }
            return string;
        }
        catch (IOException e) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                return "unknown";
            }
            LOGGER.error("Failed to get mod version", e);
            return "error";
        }
    }

    public static void sendUpdateMessage() {
        if (MOD_VERSION.equals(latestVersion)) {
            return;
        }
        try {
            int versionInt = Integer.parseInt(latestVersion.substring(1));
            int modInt = Integer.parseInt(MOD_VERSION.substring(1));
            if (versionInt <= modInt) {
                return;
            }
            if (Flint.getClient().field_1724 != null) {
                Flint.getUser().sendMessage(new InfoMessage("flint.update", new ComponentLike[]{Component.text((String)MOD_VERSION), Component.text((String)latestVersion), ((TranslatableComponent)Component.translatable((String)"flint.update.link", (TextColor)PaletteColor.SKY_LIGHT_2).clickEvent(ClickEvent.openUrl((String)MODRINTH_URL))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)MODRINTH_URL, (TextColor)PaletteColor.GRAY_LIGHT)))}));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

