/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.data;

import dev.dfonline.flint.data.ItemData;
import dev.dfonline.flint.data.value.DataValue;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public final class PublicBukkitValues {
    public static final String PUBLIC_BUKKIT_VALUES_KEY = "PublicBukkitValues";
    private static final String HYPERCUBE_KEY_PREFIX = "hypercube:";
    private final class_2487 publicBukkitValues;

    private PublicBukkitValues(class_2487 publicBukkitValues) {
        this.publicBukkitValues = publicBukkitValues;
    }

    @Nullable
    public static PublicBukkitValues fromItemData(ItemData data) {
        class_2487 customData = data.getNbt();
        if (customData == null) {
            return null;
        }
        class_2487 publicBukkitValues = customData.method_10562(PUBLIC_BUKKIT_VALUES_KEY);
        if (publicBukkitValues == null) {
            return null;
        }
        return new PublicBukkitValues(publicBukkitValues);
    }

    public static PublicBukkitValues getEmpty() {
        class_2487 empty = new class_2487();
        empty.method_10566(PUBLIC_BUKKIT_VALUES_KEY, (class_2520)new class_2487());
        return new PublicBukkitValues(empty);
    }

    public class_2487 getNbt() {
        return this.publicBukkitValues;
    }

    public String getHypercubeStringValue(String key) {
        return this.publicBukkitValues.method_10558(HYPERCUBE_KEY_PREFIX + key);
    }

    public String getStringValue(String key) {
        return this.publicBukkitValues.method_10558(key);
    }

    public DataValue getHypercubeValue(String key) {
        return DataValue.fromNbt(this.publicBukkitValues.method_10580(HYPERCUBE_KEY_PREFIX + key));
    }

    public Set<String> getHypercubeKeys() {
        return this.publicBukkitValues.method_10541().stream().filter(key -> key.startsWith(HYPERCUBE_KEY_PREFIX)).map(key -> key.substring(HYPERCUBE_KEY_PREFIX.length())).collect(Collectors.toSet());
    }

    public Set<String> getKeys() {
        return this.publicBukkitValues.method_10541();
    }

    public boolean hasHypercubeKey(String key) {
        return this.publicBukkitValues.method_10545(HYPERCUBE_KEY_PREFIX + key);
    }

    public boolean hasKey(String key) {
        return this.publicBukkitValues.method_10545(key);
    }

    public void setStringValue(String key, String value) {
        this.publicBukkitValues.method_10582(key, value);
    }

    public void setHypercubeStringValue(String key, String value) {
        this.publicBukkitValues.method_10582(HYPERCUBE_KEY_PREFIX + key, value);
    }
}

