/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.impl;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.trait.ChatListeningFeature;
import dev.dfonline.flint.feature.trait.PacketListeningFeature;
import dev.dfonline.flint.hypercube.Node;
import dev.dfonline.flint.util.ComponentUtil;
import dev.dfonline.flint.util.file.ExternalFile;
import dev.dfonline.flint.util.file.FileUtil;
import dev.dfonline.flint.util.message.impl.prefix.ErrorMessage;
import dev.dfonline.flint.util.message.impl.prefix.SuccessMessage;
import dev.dfonline.flint.util.result.ReplacementEventResult;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_2561;
import net.minecraft.class_634;

public class GetActionDumpFeature
implements ChatListeningFeature,
PacketListeningFeature {
    private static final int MS_IN_SEC = 1000;
    private static StringBuilder capturedData = null;
    private static boolean isGettingActionDump = false;
    private static ComponentUtil.ColorMode colorMode;
    private static int lines;
    private static int length;
    private static long startTime;

    public static void getActionDump(ComponentUtil.ColorMode color, boolean allowNonObtainableActionDumpNodes) {
        if (isGettingActionDump) {
            return;
        }
        Node node = Flint.getUser().getNode();
        if (!(allowNonObtainableActionDumpNodes || node != null && node.isActionDumpObtainable())) {
            Flint.getUser().sendMessage(new ErrorMessage("flint.command.flint.action_dump.fail.node", new ComponentLike[0]));
            return;
        }
        isGettingActionDump = true;
        class_634 networkHandler = Flint.getClient().method_1562();
        if (networkHandler == null) {
            isGettingActionDump = false;
            return;
        }
        capturedData = new StringBuilder();
        colorMode = color;
        lines = 0;
        length = 0;
        startTime = System.currentTimeMillis();
        networkHandler.method_45731("dumpactioninfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplacementEventResult<class_2561> onChatMessage(class_2561 text, boolean actionbar) {
        if (capturedData == null || !isGettingActionDump) {
            return ReplacementEventResult.pass();
        }
        if (text.getString().startsWith("Error: ")) {
            isGettingActionDump = false;
            Flint.getUser().sendMessage(new ErrorMessage("flint.command.flint.action_dump.fail.start", new ComponentLike[0]));
            return ReplacementEventResult.cancel();
        }
        ComponentUtil.textToString(text, capturedData, colorMode);
        String content = text.getString();
        capturedData.append("\n");
        Flint.getUser().sendMessage(new SuccessMessage("flint.command.flint.action_dump.progress", true, new ComponentLike[]{Component.text((float)((float)(System.currentTimeMillis() - startTime) / 1000.0f)), Component.text((int)(++lines)), Component.text((int)(length += content.length()))}));
        if (text.getString().equals("}")) {
            isGettingActionDump = false;
            try {
                FileUtil.writeFile(ExternalFile.ACTION_DUMP.getPath(), capturedData.toString());
                Flint.getUser().sendMessage(new SuccessMessage("flint.command.flint.action_dump.success", new ComponentLike[]{Component.text((float)((float)(System.currentTimeMillis() - startTime) / 1000.0f)), Component.text((int)lines), Component.text((int)length)}));
            }
            catch (IOException e) {
                Flint.getUser().sendMessage(new ErrorMessage("flint.command.flint.action_dump.fail.write", new ComponentLike[0]));
                ReplacementEventResult<class_2561> replacementEventResult = ReplacementEventResult.cancel();
                return replacementEventResult;
            }
            finally {
                capturedData = null;
            }
        }
        return ReplacementEventResult.cancel();
    }
}

