/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.impl;

import dev.dfonline.flint.feature.impl.CommandSenderFeature;
import dev.dfonline.flint.feature.trait.PacketListeningFeature;
import dev.dfonline.flint.hypercube.Mode;
import dev.dfonline.flint.hypercube.Node;
import dev.dfonline.flint.hypercube.Plot;
import dev.dfonline.flint.util.Toaster;
import dev.dfonline.flint.util.result.EventResult;
import it.unimi.dsi.fastutil.Pair;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_7439;
import org.jetbrains.annotations.Nullable;

public class LocateFeature
implements PacketListeningFeature {
    private static final Pattern LOCATE_PATTERN = Pattern.compile("\\s{39}\\n(?:You are|(?<username>[A-Za-z0-9_]+) is) currently (?<mode>playing|coding|building|at spawn|existing)(?:(?: on:\\n)?\\n)?(?:\u2192 (?<plotName>.+) \\[(?<plotID>\\d+)](?: \\[)?(?<plotHandle>[a-z0-9_-]+)?]? ?(?:\\n\u2192 (?<status>.++))?\\n\u2192 Owner: (?<owner>[A-Za-z0-9_]+)(?<whitelisted> \\[Whitelisted])?)? ?\\n?\u2192 Server: (?<node>[\\w ?]+)\\n\\s{39}", 8);
    private static final Queue<Pair<String, CompletableFuture<LocateResult>>> locateRequests = new LinkedList<Pair<String, CompletableFuture<LocateResult>>>();
    private static boolean awaitingResponse = false;
    private static final int LOCATE_TIMEOUT_SECONDS = 3;

    @Override
    public boolean alwaysOn() {
        return true;
    }

    public static CompletableFuture<LocateResult> requestLocate(String playerName) {
        CompletableFuture<LocateResult> locateResult = new CompletableFuture<LocateResult>();
        Pair requestPair = Pair.of((Object)playerName, locateResult);
        locateRequests.add((Pair<String, CompletableFuture<LocateResult>>)requestPair);
        CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(() -> {
            if (!locateResult.isDone()) {
                locateResult.completeExceptionally(new TimeoutException("Locate request timed out after 3 second(s)"));
                Toaster.toast((Component)Component.translatable((String)"flint.locate.timeout.title"), (Component)Component.translatable((String)"flint.locate.timeout.description", (ComponentLike[])new ComponentLike[]{Component.text((int)3)}));
                if (awaitingResponse && !locateRequests.isEmpty() && locateRequests.peek().second() == locateResult) {
                    locateRequests.poll();
                    awaitingResponse = false;
                    LocateFeature.processNextRequestIfReady();
                } else {
                    locateRequests.removeIf(pair -> pair.second() == locateResult);
                }
            }
        });
        LocateFeature.processNextRequestIfReady();
        return locateResult;
    }

    private static void processNextRequestIfReady() {
        if (!awaitingResponse && !locateRequests.isEmpty()) {
            awaitingResponse = true;
            Pair<String, CompletableFuture<LocateResult>> currentRequest = locateRequests.peek();
            CommandSenderFeature.queue("locate " + (String)currentRequest.first());
        }
    }

    @Override
    public EventResult onReceivePacket(class_2596<?> packet) {
        if (!(packet instanceof class_7439)) {
            return EventResult.PASS;
        }
        class_7439 message = (class_7439)packet;
        if (locateRequests.isEmpty() || !awaitingResponse) {
            return EventResult.PASS;
        }
        Pair<String, CompletableFuture<LocateResult>> currentRequest = locateRequests.peek();
        String playerName = (String)currentRequest.first();
        String text = message.comp_763().getString();
        Matcher matcher = LOCATE_PATTERN.matcher(class_124.method_539((String)text));
        if (!matcher.find()) {
            return EventResult.PASS;
        }
        LocateResult result = this.parseLocateResponse(matcher, playerName);
        if (result == null) {
            return EventResult.PASS;
        }
        locateRequests.poll();
        ((CompletableFuture)currentRequest.second()).complete(result);
        awaitingResponse = false;
        LocateFeature.processNextRequestIfReady();
        return EventResult.CANCEL;
    }

    private LocateResult parseLocateResponse(Matcher matcher, String playerName) {
        if (matcher.group("mode") == null || matcher.group("node") == null) {
            return null;
        }
        String username = playerName;
        if (matcher.group("username") != null) {
            username = matcher.group("username");
        }
        Mode mode = switch (matcher.group("mode")) {
            case "at spawn" -> Mode.SPAWN;
            case "playing" -> Mode.PLAY;
            case "coding" -> Mode.DEV;
            case "building" -> Mode.BUILD;
            case "existing" -> Mode.CODE_SPECTATE;
            default -> Mode.NONE;
        };
        Plot plot = LocateFeature.parsePlot(matcher);
        Node node = Node.fromName(matcher.group("node"));
        return new LocateResult(username, mode, plot, node);
    }

    @Nullable
    private static Plot parsePlot(Matcher matcher) {
        if (matcher.group("plotName") == null) {
            return null;
        }
        String plotName = matcher.group("plotName");
        int plotID = Integer.parseInt(matcher.group("plotID"));
        String plotHandle = null;
        if (matcher.group("plotHandle") != null) {
            plotHandle = matcher.group("plotHandle");
        }
        boolean whitelisted = matcher.group("whitelisted") != null;
        return new Plot(plotID, (class_2561)class_2561.method_43470((String)plotName), plotHandle, whitelisted);
    }

    public record LocateResult(String player, Mode mode, @Nullable Plot plot, Node node) {
    }
}

