/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.impl;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.FlintAPI;
import dev.dfonline.flint.feature.impl.LocateFeature;
import dev.dfonline.flint.feature.trait.ConnectionListeningFeature;
import dev.dfonline.flint.feature.trait.PacketListeningFeature;
import dev.dfonline.flint.feature.trait.TickedFeature;
import dev.dfonline.flint.hypercube.Mode;
import dev.dfonline.flint.hypercube.Plot;
import dev.dfonline.flint.hypercube.PlotSize;
import dev.dfonline.flint.util.FlintUpdate;
import dev.dfonline.flint.util.Logger;
import dev.dfonline.flint.util.result.EventResult;
import java.util.regex.Pattern;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2759;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_638;
import net.minecraft.class_7439;

public class ModeTrackerFeature
implements PacketListeningFeature,
TickedFeature,
ConnectionListeningFeature {
    private static final Logger LOGGER = Logger.of(ModeTrackerFeature.class);
    private static final Pattern SPAWN_ACTION_BAR_PATTERN = Pattern.compile("(\u23f5+ - )?\u29c8 -?\\d+ Tokens {2}\u16e5 -?\\d+ Tickets {2}\u26a1 -?\\d+ Sparks");
    private static final String DEV_MODE_MESSAGE = "\u00bb You are now in dev mode.";
    private static final String BUILD_MODE_MESSAGE = "\u00bb You are now in build mode.";
    private static final String JOINED_GAME_PREFIX = "\u00bb Joined game: ";
    private static final int DEV_SPAWN_OFFSET = 10;
    private static final int GROUND_LEVEL = 49;
    private PendingModeSwitchAction pendingAction = PendingModeSwitchAction.CLEAR_TITLE;
    private static boolean hasQueuedLocate = false;
    private static Mode queuedMode = null;
    private static boolean sentUpdateMessageThisSession = false;

    @Override
    public boolean alwaysOn() {
        return true;
    }

    private static void setMode(Mode mode) {
        if (FlintAPI.isDebugging()) {
            LOGGER.info("Setting to mode " + String.valueOf((Object)mode), new Object[0]);
        }
        if (FlintAPI.shouldConfirmLocationWithLocate() && mode != Mode.NONE) {
            hasQueuedLocate = true;
        } else {
            Flint.getUser().setNode(null);
            Flint.getUser().setPlot(null);
            Flint.getUser().setMode(mode);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EventResult onReceivePacket(class_2596<?> packet) {
        boolean overlayMatches;
        block11: {
            boolean bl;
            block10: {
                if (!hasQueuedLocate) {
                    class_5888 clear;
                    if (packet instanceof class_5888 && (clear = (class_5888)packet).method_34116()) {
                        this.pendingAction = PendingModeSwitchAction.POSITION_CHANGE;
                    } else if (packet instanceof class_2759 && this.pendingAction == PendingModeSwitchAction.POSITION_CHANGE) {
                        this.pendingAction = PendingModeSwitchAction.MESSAGE;
                    }
                }
                if (packet instanceof class_5894) {
                    class_5894 class_58942 = (class_5894)packet;
                    try {
                        class_2561 class_25612;
                        class_2561 text = class_25612 = class_58942.comp_2279();
                        if (this.pendingAction != PendingModeSwitchAction.MESSAGE || !SPAWN_ACTION_BAR_PATTERN.matcher(text.getString()).matches()) break block10;
                        bl = true;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
            }
            bl = overlayMatches = false;
        }
        if (overlayMatches) {
            queuedMode = Mode.SPAWN;
            this.pendingAction = PendingModeSwitchAction.CLEAR_TITLE;
        }
        if (hasQueuedLocate) return EventResult.PASS;
        if (!(packet instanceof class_7439)) return EventResult.PASS;
        class_7439 gameMsg = (class_7439)packet;
        if (this.pendingAction != PendingModeSwitchAction.MESSAGE) return EventResult.PASS;
        String content = gameMsg.comp_763().getString();
        if (content.equals(DEV_MODE_MESSAGE)) {
            ModeTrackerFeature.setMode(Mode.DEV);
            return EventResult.PASS;
        }
        if (content.equals(BUILD_MODE_MESSAGE)) {
            ModeTrackerFeature.setMode(Mode.BUILD);
            return EventResult.PASS;
        }
        if (!content.startsWith(JOINED_GAME_PREFIX)) return EventResult.PASS;
        ModeTrackerFeature.setMode(Mode.PLAY);
        return EventResult.PASS;
    }

    @Override
    public void tick() {
        if (Flint.getClient().field_1724 != null) {
            Plot plot;
            if (hasQueuedLocate) {
                hasQueuedLocate = false;
                String name = Flint.getUser().getPlayer().method_5820();
                LocateFeature.requestLocate(name).thenAccept(locate -> {
                    class_2382 newOrigin;
                    Flint.getUser().setNode(locate.node());
                    Flint.getUser().setNodeId(locate.nodeId());
                    if (locate.mode() == Mode.DEV) {
                        class_2338 blockpos = Flint.getUser().getPlayer().method_24515();
                        newOrigin = new class_2382(blockpos.method_10263() + 10, 49, blockpos.method_10260() - 10);
                    } else {
                        newOrigin = null;
                    }
                    Plot currentPlot = Flint.getUser().getPlot();
                    if (locate.plot() != null) {
                        if (currentPlot == null || !currentPlot.equals(locate.plot())) {
                            Flint.getUser().setPlot(locate.plot());
                        }
                        if (Flint.getUser().getPlot().getDevOrigin() == null && newOrigin != null) {
                            Flint.getUser().getPlot().setDevOrigin(newOrigin);
                        }
                    } else {
                        Flint.getUser().setPlot(null);
                    }
                    Flint.getUser().setMode(locate.mode());
                });
            }
            if (queuedMode != null) {
                if (!sentUpdateMessageThisSession) {
                    FlintUpdate.sendUpdateMessage();
                    sentUpdateMessageThisSession = true;
                }
                ModeTrackerFeature.setMode(queuedMode);
                queuedMode = null;
            }
            if ((plot = Flint.getUser().getPlot()) != null && plot.getDevOrigin() != null) {
                if (!plot.isSizeKnown()) {
                    plot.setSize(this.detectPlotSize());
                }
                plot.setHasUnderground(this.detectPlotUnderground());
            }
        }
    }

    @Override
    public void onDisconnect() {
        ModeTrackerFeature.setMode(Mode.NONE);
        sentUpdateMessageThisSession = false;
    }

    private PlotSize detectPlotSize() {
        if (Flint.getUser().getMode() != Mode.DEV || Flint.getUser().getPlot() == null || Flint.getUser().getPlot().getDevOrigin() == null) {
            return null;
        }
        Plot plot = Flint.getUser().getPlot();
        class_2382 devOrigin = plot.getDevOrigin();
        class_2338 pos = new class_2338(devOrigin.method_10263() - 1, 49, devOrigin.method_10260());
        class_638 world = Flint.getClient().field_1687;
        if (world == null) {
            return null;
        }
        class_2680 BASIC = world.method_8320(pos.method_10077(50));
        class_2680 BASIC_PLUS = world.method_8320(pos.method_10077(51));
        class_2680 LARGE = world.method_8320(pos.method_10077(100));
        class_2680 LARGE_PLUS = world.method_8320(pos.method_10077(101));
        class_2680 MASSIVE = world.method_8320(pos.method_10077(300));
        class_2680 MASSIVE_PLUS = world.method_8320(pos.method_10077(301));
        class_2680 MEGA = world.method_8320(pos.method_10069(-18, 0, 10));
        class_2680 MEGA_PLUS = world.method_8320(pos.method_10069(-19, 0, 10));
        if (MEGA_PLUS.method_27852(class_2246.field_10219) && MEGA.method_27852(class_2246.field_10219)) {
            return PlotSize.MEGA;
        }
        if (!(MEGA.method_27852(class_2246.field_10243) || MEGA_PLUS.method_27852(class_2246.field_10243) || MEGA.method_27852(class_2246.field_10219) || MEGA.method_27852(class_2246.field_10340) || MEGA_PLUS.method_27852(class_2246.field_10219))) {
            return PlotSize.MEGA;
        }
        if (!(BASIC.method_27852(class_2246.field_10243) || BASIC_PLUS.method_27852(class_2246.field_10243) || BASIC.method_27852(BASIC_PLUS.method_26204()))) {
            return PlotSize.BASIC;
        }
        if (!(LARGE.method_27852(class_2246.field_10243) || LARGE_PLUS.method_27852(class_2246.field_10243) || LARGE.method_27852(LARGE_PLUS.method_26204()))) {
            return PlotSize.LARGE;
        }
        if (!(MASSIVE.method_27852(class_2246.field_10243) || MASSIVE_PLUS.method_27852(class_2246.field_10243) || MASSIVE.method_27852(MASSIVE_PLUS.method_26204()))) {
            return PlotSize.MASSIVE;
        }
        return null;
    }

    private boolean detectPlotUnderground() {
        Plot plot = Flint.getUser().getPlot();
        if (plot == null) {
            return false;
        }
        if (Flint.getClient().field_1687 == null) {
            return false;
        }
        PlotSize size = plot.getSize();
        class_2680 groundCheck = Flint.getClient().field_1687.method_8320(new class_2338(Math.max(Math.min((int)Flint.getUser().getPlayer().method_23317(), plot.getDevOrigin().method_10263() - 1), plot.getDevOrigin().method_10263() - size.getCodeWidth()), 49, Math.max(Math.min((int)Flint.getUser().getPlayer().method_23321(), plot.getDevOrigin().method_10260() + size.getCodeLength()), plot.getDevOrigin().method_10260())));
        if (!groundCheck.method_27852(class_2246.field_10243)) {
            return !groundCheck.method_27852(class_2246.field_10219) && !groundCheck.method_27852(class_2246.field_10340);
        }
        return false;
    }

    private static enum PendingModeSwitchAction {
        CLEAR_TITLE,
        POSITION_CHANGE,
        MESSAGE;

    }
}

