/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.hypercube;

import dev.dfonline.flint.hypercube.PlotSize;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;

public class Plot {
    private final int id;
    private final class_2561 name;
    private final String handle;
    private final boolean whitelisted;
    private class_2382 devOrigin;
    private PlotSize size;
    private boolean hasUnderground = false;
    private final String owner;

    public Plot(int id, class_2561 name, String handle, boolean whitelisted, String owner) {
        this.id = id;
        this.name = name;
        this.handle = handle;
        this.whitelisted = whitelisted;
        this.owner = owner;
    }

    public int getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public String getHandle() {
        return this.handle;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public class_2382 getDevOrigin() {
        return this.devOrigin;
    }

    public void setDevOrigin(class_2382 origin) {
        this.devOrigin = origin;
    }

    public PlotSize getSize() {
        return Objects.requireNonNullElse(this.size, PlotSize.MASSIVE);
    }

    public boolean isSizeKnown() {
        return this.size != null;
    }

    public void setSize(PlotSize size) {
        this.size = size;
    }

    public boolean hasUnderground() {
        return this.hasUnderground;
    }

    public void setHasUnderground(boolean hasUnderground) {
        this.hasUnderground = hasUnderground;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isPosInCodeSpace(class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        return x < this.devOrigin.method_10263() && x >= this.devOrigin.method_10263() - this.size.getCodeWidth() && z >= this.devOrigin.method_10260() && z <= this.devOrigin.method_10260() + this.size.getCodeLength();
    }

    public String toReadableString() {
        return "ID " + this.id + ", name " + this.name.getString() + ", handle " + this.handle + ", whitelisted " + this.whitelisted + ", origin " + String.valueOf(this.devOrigin) + ", owner " + this.owner;
    }

    public boolean equals(Object o) {
        if (o instanceof Plot) {
            Plot plot = (Plot)o;
            if (this.handle == null && plot.getHandle() != null || plot.getHandle() == null && this.handle != null) {
                return false;
            }
            return this.id == plot.getId() && this.name.equals((Object)plot.getName()) && (this.handle == null && plot.getHandle() == null || this.handle != null && this.handle.equals(plot.getHandle())) && this.whitelisted == plot.isWhitelisted() && this.owner.equals(plot.getOwner());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.handle, this.whitelisted, this.owner);
    }
}

