/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;

public class HintArgument
extends Argument {
    private HintType type;

    public HintArgument(JsonObject json, JsonObject data) {
        super(json);
        this.type = HintType.fromType(data.get("id").getAsString());
    }

    public HintArgument(int slot, HintType type) {
        super(slot);
        this.type = type;
    }

    @Override
    public String toString() {
        return "Hint [type=" + String.valueOf((Object)this.type) + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("id", this.type.id);
        return data;
    }

    @Override
    public String getID() {
        return "hint";
    }

    public HintType getType() {
        return this.type;
    }

    public void setType(HintType type) {
        this.type = type;
    }

    public static enum HintType {
        FUNCTION("function"),
        UNKNOWN("");

        public final String id;

        private HintType(String id) {
            this.id = id;
        }

        public String getID() {
            return this.id;
        }

        public static HintType fromType(String type) {
            for (HintType t : HintType.values()) {
                if (!t.id.equals(type)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

