/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;

public class LocationArgument
extends Argument {
    private boolean isBlock;
    private double x;
    private double y;
    private double z;
    private double pitch;
    private double yaw;

    public LocationArgument(JsonObject json, JsonObject data) {
        super(json);
        JsonObject loc = data.get("loc").getAsJsonObject();
        this.x = loc.get("x").getAsDouble();
        this.y = loc.get("y").getAsDouble();
        this.z = loc.get("z").getAsDouble();
        this.pitch = loc.get("pitch").getAsDouble();
        this.yaw = loc.get("yaw").getAsDouble();
        this.isBlock = data.get("isBlock").getAsBoolean();
    }

    public LocationArgument(int slot, double x, double y, double z, double pitch, double yaw, boolean isBlock) {
        super(slot);
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.isBlock = isBlock;
    }

    @Override
    public String toString() {
        return "Location [x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ", isBlock=" + this.isBlock + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("isBlock", Boolean.valueOf(this.isBlock));
        JsonObject loc = new JsonObject();
        loc.addProperty("x", (Number)this.x);
        loc.addProperty("y", (Number)this.y);
        loc.addProperty("z", (Number)this.z);
        loc.addProperty("pitch", (Number)this.pitch);
        loc.addProperty("yaw", (Number)this.yaw);
        data.add("loc", (JsonElement)loc);
        return data;
    }

    @Override
    public String getID() {
        return "loc";
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public void setBlock(boolean block) {
        this.isBlock = block;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }
}

