/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;

public class TagArgument
extends Argument {
    private String option;
    private String tag;
    private String action;
    private String block;

    public TagArgument(JsonObject json, JsonObject data) {
        super(json);
        this.option = data.get("option").getAsString();
        this.tag = data.get("tag").getAsString();
        this.action = data.get("action").getAsString();
        this.block = data.get("block").getAsString();
    }

    public TagArgument(int slot, String option, String tag, String action, String block) {
        super(slot);
        this.option = option;
        this.tag = tag;
        this.action = action;
        this.block = block;
    }

    @Override
    public String toString() {
        return "Tag [option=" + this.option + ", tag=" + this.tag + ", action=" + this.action + ", block=" + this.block + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("option", this.option);
        data.addProperty("tag", this.tag);
        data.addProperty("action", this.action);
        data.addProperty("block", this.block);
        return data;
    }

    @Override
    public String getID() {
        return "bl_tag";
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getBlock() {
        return this.block;
    }

    public void setBlock(String block) {
        this.block = block;
    }
}

