/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.codeblock;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.codeblock.abstracts.CodeBlockAction;
import dev.dfonline.flint.templates.codeblock.target.EntityTarget;

public class EntityAction
extends CodeBlockAction {
    private EntityTarget target;

    public EntityAction(JsonObject json) {
        super(json);
        this.target = json.has("target") ? EntityTarget.fromString(json.get("target").getAsString()) : EntityTarget.NONE;
    }

    public EntityAction(EntityTarget target, String action) {
        super(action);
        this.target = target;
    }

    @Override
    public String toString() {
        return "EntityAction [target=" + String.valueOf((Object)this.target) + " " + super.toString() + "]";
    }

    @Override
    public String getBlock() {
        return "entity_action";
    }

    @Override
    public JsonObject toJSON() {
        JsonObject json = super.toJSON();
        if (this.target != EntityTarget.NONE) {
            json.addProperty("target", this.target.name);
        }
        return json;
    }

    public EntityTarget getTarget() {
        return this.target;
    }

    public void setTarget(EntityTarget target) {
        this.target = target;
    }
}

