/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.util;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.util.file.FlintFile;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5251;

public final class ComponentUtil {
    private ComponentUtil() {
    }

    public static void textToString(class_2561 content, StringBuilder build, ColorMode colorMode) {
        class_5251 lastColor = null;
        for (class_2561 text : content.method_10855()) {
            if (colorMode != ColorMode.MINI_MESSAGE) {
                class_5251 color = text.method_10866().method_10973();
                if (color != null && lastColor != color && colorMode != ColorMode.NONE) {
                    lastColor = color;
                    if (color.method_27721().contains("#")) {
                        build.append(String.join((CharSequence)colorMode.getPrefix(), color.method_27721().split("")).replace("#", colorMode.getPrefix() + "x").toLowerCase());
                    } else {
                        build.append(class_124.valueOf((String)String.valueOf(color).toUpperCase()).toString().replace("\u00a7", colorMode.getPrefix()));
                    }
                }
                build.append(text.getString());
                continue;
            }
            build.append(ComponentUtil.serializeComponent(Flint.AUDIENCE.asAdventure(text)));
        }
    }

    public static String serializeComponent(Component component) {
        StringBuilder build = new StringBuilder();
        if (component instanceof TextComponent) {
            TextComponent t = (TextComponent)component;
            if (!t.content().equals(",")) {
                ComponentUtil.appendStyle(build, t.style());
            }
            build.append(t.content());
        }
        return build.toString();
    }

    private static void appendStyle(StringBuilder build, Style style) {
        style.decorations().forEach((decoration, state) -> {
            if (state == TextDecoration.State.TRUE) {
                build.append("<").append(decoration.toString().toLowerCase()).append(">");
            } else if (decoration == TextDecoration.ITALIC && state == TextDecoration.State.FALSE) {
                build.append("<!").append(decoration.toString().toLowerCase()).append(">");
            }
        });
        if (style.color() != null) {
            ComponentUtil.appendColor(build, style.color());
        }
    }

    private static void appendColor(StringBuilder build, TextColor color) {
        String colorStr = color.asHexString();
        NamedTextColor namedTextColor = NamedTextColor.namedColor((int)color.value());
        if (namedTextColor != null) {
            colorStr = namedTextColor.toString();
        }
        build.append("<").append(colorStr).append(">");
    }

    public static enum ColorMode {
        SECTION("\u00a7", FlintFile.ACTION_DUMP_SECTION),
        AMPERSAND("&", FlintFile.ACTION_DUMP_AMPERSAND),
        MINI_MESSAGE(null, FlintFile.ACTION_DUMP_MINI_MESSAGE),
        NONE(null, FlintFile.ACTION_DUMP_PLAIN);

        private final FlintFile file;
        private final String prefix;

        private ColorMode(String prefix, FlintFile file) {
            this.prefix = prefix;
            this.file = file;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public FlintFile getFile() {
            return this.file;
        }
    }
}

