/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.network.ServuxLitematicaHandler;
import fi.dy.masa.litematica.network.ServuxLitematicaPacket;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.mixin.network.IMixinDataQueryHandler;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class EntitiesDataStorage
implements IClientTickHandler,
IDataSyncer {
    private static final EntitiesDataStorage INSTANCE = new EntitiesDataStorage();
    private static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> HANDLER = ServuxLitematicaHandler.getInstance();
    private final Minecraft mc;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion;
    private final long chunkTimeoutMs = 5000L;
    private boolean checkOpStatus = true;
    private boolean hasOpStatus = false;
    private long lastOpCheck = 0L;
    private final ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> blockEntityCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> entityCache = new ConcurrentHashMap();
    private final long cacheTimeout = 4L;
    private final long longCacheTimeout = 30L;
    private boolean shouldUseLongTimeout = false;
    private long serverTickTime = 0L;
    private final Set<BlockPos> pendingBlockEntitiesQueue = new LinkedHashSet<BlockPos>();
    private final Set<Integer> pendingEntitiesQueue = new LinkedHashSet<Integer>();
    private final Set<ChunkPos> pendingChunks = new LinkedHashSet<ChunkPos>();
    private final Set<ChunkPos> completedChunks = new LinkedHashSet<ChunkPos>();
    private final Map<ChunkPos, Long> pendingChunkTimeout = new HashMap<ChunkPos, Long>();
    private final Map<Integer, Either<BlockPos, Integer>> transactionToBlockPosOrEntityId = new HashMap<Integer, Either<BlockPos, Integer>>();
    private ClientLevel clientWorld;
    private boolean sentBackupPackets = false;
    private boolean receivedBackupPackets = false;
    private final HashMap<ChunkPos, Set<BlockPos>> pendingBackupChunk_BlockEntities = new HashMap();
    private final HashMap<ChunkPos, Set<Integer>> pendingBackupChunk_Entities = new HashMap();

    public static EntitiesDataStorage getInstance() {
        return INSTANCE;
    }

    @Nullable
    public Level getWorld() {
        return WorldUtils.getBestWorld((Minecraft)this.mc);
    }

    public ClientLevel getClientWorld() {
        if (this.clientWorld == null) {
            this.clientWorld = this.mc.level;
        }
        return this.clientWorld;
    }

    private EntitiesDataStorage() {
        this.mc = Minecraft.getInstance();
    }

    public void onClientTick(Minecraft mc) {
        long now = System.currentTimeMillis();
        if (now - this.serverTickTime > 50L) {
            if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                this.serverTickTime = now;
                if (!DataManager.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
                    this.servuxServer = false;
                    HANDLER.unregisterPlayReceiver();
                }
                if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
                    if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                        this.pendingBlockEntitiesQueue.clear();
                    }
                    if (!this.pendingEntitiesQueue.isEmpty()) {
                        this.pendingEntitiesQueue.clear();
                    }
                    return;
                }
            } else if (!(DataManager.getInstance().hasIntegratedServer() || this.hasServuxServer() || this.hasInValidServux || this.getWorld() == null)) {
                HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, HANDLER::receivePlayPayload);
                this.requestMetadata();
            }
            this.tickCache(now);
            for (int i = 0; i < Configs.Generic.SERVER_NBT_REQUEST_RATE.getIntegerValue(); ++i) {
                Iterator<Object> iter;
                if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                    iter = this.pendingBlockEntitiesQueue.iterator();
                    BlockPos pos = iter.next();
                    iter.remove();
                    if (this.hasServuxServer()) {
                        this.requestServuxBlockEntityData(pos);
                    } else if (this.shouldUseQuery()) {
                        this.requestQueryBlockEntity(pos);
                    }
                }
                if (this.pendingEntitiesQueue.isEmpty()) continue;
                iter = this.pendingEntitiesQueue.iterator();
                int entityId = (Integer)iter.next();
                iter.remove();
                if (this.hasServuxServer()) {
                    this.requestServuxEntityData(entityId);
                    continue;
                }
                if (!this.shouldUseQuery()) continue;
                this.requestQueryEntityData(entityId);
            }
            this.serverTickTime = System.currentTimeMillis();
        }
    }

    public ResourceLocation getNetworkChannel() {
        return ServuxLitematicaHandler.CHANNEL_ID;
    }

    private ClientPacketListener getVanillaHandler() {
        if (this.mc.player != null) {
            return this.mc.player.connection;
        }
        return null;
    }

    public IPluginClientPlayHandler<ServuxLitematicaPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            Litematica.debugLog("EntitiesDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.sentBackupPackets = false;
            this.receivedBackupPackets = false;
            this.checkOpStatus = false;
            this.hasOpStatus = false;
            this.lastOpCheck = 0L;
        } else {
            Litematica.debugLog("EntitiesDataStorage#reset() - dimension change or log-in", new Object[0]);
            long now = System.currentTimeMillis();
            this.serverTickTime = now - (this.getCacheTimeout() + 5000L);
            this.tickCache(now);
            this.serverTickTime = now;
            this.clientWorld = this.mc.level;
            this.checkOpStatus = true;
            this.lastOpCheck = now;
        }
        this.blockEntityCache.clear();
        this.entityCache.clear();
        this.pendingBlockEntitiesQueue.clear();
        this.pendingEntitiesQueue.clear();
        this.completedChunks.clear();
        this.pendingChunks.clear();
        this.pendingChunkTimeout.clear();
        this.pendingBackupChunk_BlockEntities.clear();
        this.pendingBackupChunk_Entities.clear();
    }

    private boolean shouldUseQuery() {
        if (this.hasOpStatus) {
            return true;
        }
        if (this.checkOpStatus) {
            if (System.currentTimeMillis() - this.lastOpCheck < 900000L) {
                return true;
            }
            this.checkOpStatus = false;
        }
        return false;
    }

    public void resetOpCheck() {
        this.hasOpStatus = false;
        this.checkOpStatus = true;
        this.lastOpCheck = System.currentTimeMillis();
    }

    private long getCacheTimeout() {
        int modifier = Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue() ? 5 : 1;
        return (long)(Mth.clamp((float)(Configs.Generic.ENTITY_DATA_SYNC_CACHE_TIMEOUT.getFloatValue() * (float)modifier), (float)0.25f, (float)30.0f) * 1000.0f);
    }

    private long getCacheTimeoutLong() {
        int modifier = Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue() ? 5 : 1;
        float f = Configs.Generic.ENTITY_DATA_SYNC_CACHE_TIMEOUT.getFloatValue() * (float)modifier;
        Objects.requireNonNull(this);
        return (long)(Mth.clamp((float)(f * 30.0f), (float)120.0f, (float)(300.0f * (float)modifier)) * 1000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCache(long nowTime) {
        Pair<Long, Pair<BlockEntity, CompoundTag>> pair;
        int count;
        long blockTimeout = this.getCacheTimeout();
        long entityTimeout = this.getCacheTimeout();
        boolean beEmpty = false;
        boolean entEmpty = false;
        if (this.shouldUseLongTimeout) {
            blockTimeout = this.getCacheTimeoutLong();
            entityTimeout = this.getCacheTimeoutLong();
            if (!this.hasServuxServer() && this.getIfReceivedBackupPackets()) {
                blockTimeout += 3000L;
                entityTimeout += 3000L;
            }
        }
        ConcurrentHashMap<Object, Object> concurrentHashMap = this.blockEntityCache;
        synchronized (concurrentHashMap) {
            count = 0;
            for (BlockPos pos : this.blockEntityCache.keySet()) {
                pair = this.blockEntityCache.get(pos);
                if (nowTime - (Long)pair.getLeft() > blockTimeout || (Long)pair.getLeft() > nowTime) {
                    this.blockEntityCache.remove(pos);
                    continue;
                }
                ++count;
            }
            if (count == 0) {
                beEmpty = true;
            }
        }
        concurrentHashMap = this.entityCache;
        synchronized (concurrentHashMap) {
            count = 0;
            for (Integer entityId : this.entityCache.keySet()) {
                pair = this.entityCache.get(entityId);
                if (nowTime - (Long)pair.getLeft() > entityTimeout || (Long)pair.getLeft() > nowTime) {
                    this.entityCache.remove(entityId);
                    continue;
                }
                ++count;
            }
            if (count == 0) {
                entEmpty = true;
            }
        }
        if (beEmpty && entEmpty && this.shouldUseLongTimeout) {
            this.shouldUseLongTimeout = false;
        }
    }

    @Nullable
    public CompoundTag getFromBlockEntityCacheNbt(BlockPos pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (CompoundTag)((Pair)this.blockEntityCache.get(pos).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public BlockEntity getFromBlockEntityCache(BlockPos pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (BlockEntity)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
        }
        return null;
    }

    @Nullable
    public CompoundTag getFromEntityCacheNbt(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (CompoundTag)((Pair)this.entityCache.get(entityId).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public Entity getFromEntityCache(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (Entity)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
        }
        return null;
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        this.hasInValidServux = false;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public boolean hasBackupStatus() {
        return Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue() && this.hasOpStatus;
    }

    public void setServuxVersion(String ver) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            Litematica.debugLog("LitematicDataChannel: joining Servux version {}", ver);
        } else {
            this.servuxVersion = "unknown";
        }
    }

    public String getServuxVersion() {
        return this.servuxVersion;
    }

    public int getPendingBlockEntitiesCount() {
        return this.pendingBlockEntitiesQueue.size();
    }

    public int getPendingEntitiesCount() {
        return this.pendingEntitiesQueue.size();
    }

    public int getBlockEntityCacheCount() {
        return this.blockEntityCache.size();
    }

    public int getEntityCacheCount() {
        return this.entityCache.size();
    }

    public boolean getIfReceivedBackupPackets() {
        if (Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return this.sentBackupPackets & this.receivedBackupPackets;
        }
        return false;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxLitematicaPacket.Payload.ID, ServuxLitematicaPacket.Payload.CODEC, 6);
    }

    public void onWorldPre() {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        EntityUtils.initEntityUtils();
    }

    public void requestMetadata() {
        if (!DataManager.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxLitematicaPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveServuxMetadata(CompoundTag data) {
        if (!DataManager.getInstance().hasIntegratedServer()) {
            Litematica.debugLog("LitematicDataChannel: received METADATA from Servux", new Object[0]);
            if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                if (data.getIntOr("version", -1) != 1) {
                    Litematica.LOGGER.warn("LitematicDataChannel: Mis-matched protocol version!");
                }
                this.setServuxVersion(data.getStringOr("servux", "?"));
                this.setIsServuxServer();
                return true;
            }
        }
        return false;
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    @Nullable
    public Pair<BlockEntity, CompoundTag> requestBlockEntity(Level world, BlockPos pos) {
        if (world instanceof WorldSchematic) {
            return this.refreshBlockEntityFromWorld(world, pos);
        }
        if (this.blockEntityCache.containsKey(pos)) {
            if (!DataManager.getInstance().hasIntegratedServer() && (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) && System.currentTimeMillis() - (Long)this.blockEntityCache.get(pos).getLeft() > this.getCacheTimeout() / 4L) {
                this.pendingBlockEntitiesQueue.add(pos);
            }
            if (world instanceof ServerLevel) {
                return this.refreshBlockEntityFromWorld(world, pos);
            }
            return (Pair)this.blockEntityCache.get(pos).getRight();
        }
        if (world.getBlockState(pos).getBlock() instanceof EntityBlock) {
            if (!DataManager.getInstance().hasIntegratedServer() && (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue())) {
                this.pendingBlockEntitiesQueue.add(pos);
            }
            return this.refreshBlockEntityFromWorld((Level)this.getClientWorld(), pos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<BlockEntity, CompoundTag> refreshBlockEntityFromWorld(Level world, BlockPos pos) {
        BlockEntity be;
        if (world != null && world.getBlockState(pos).hasBlockEntity() && (be = world.getChunkAt(pos).getBlockEntity(pos)) != null) {
            CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            Pair pair = Pair.of((Object)be, (Object)nbt);
            if (!(world instanceof WorldSchematic)) {
                ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> concurrentHashMap = this.blockEntityCache;
                synchronized (concurrentHashMap) {
                    this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
                }
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<Entity, CompoundTag> requestEntity(Level world, int entityId) {
        if (world instanceof WorldSchematic) {
            return this.refreshEntityFromWorld(world, entityId);
        }
        if (this.entityCache.containsKey(entityId)) {
            if (!DataManager.getInstance().hasIntegratedServer() && (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) && System.currentTimeMillis() - (Long)this.entityCache.get(entityId).getLeft() > this.getCacheTimeout() / 4L) {
                this.pendingEntitiesQueue.add(entityId);
            }
            if (world instanceof ServerLevel) {
                return this.refreshEntityFromWorld(world, entityId);
            }
            return (Pair)this.entityCache.get(entityId).getRight();
        }
        if (!DataManager.getInstance().hasIntegratedServer() && (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue())) {
            this.pendingEntitiesQueue.add(entityId);
        }
        return this.refreshEntityFromWorld((Level)this.getClientWorld(), entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<Entity, CompoundTag> refreshEntityFromWorld(Level world, int entityId) {
        Entity entity;
        if (world != null && (entity = world.getEntity(entityId)) != null) {
            if (world instanceof WorldSchematic) {
                NbtView view = NbtView.getWriter((RegistryAccess)world.registryAccess());
                entity.saveWithoutId(view.getWriter());
                CompoundTag nbt = view.readNbt();
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                if (nbt != null && id != null) {
                    nbt.putString("id", id.toString());
                    Pair pair = Pair.of((Object)entity, (Object)nbt.copy());
                    return pair;
                }
            } else {
                CompoundTag nbt = NbtEntityUtils.invokeEntityNbtDataNoPassengers((Entity)entity, (int)entityId);
                if (!nbt.isEmpty()) {
                    Pair pair = Pair.of((Object)entity, (Object)nbt);
                    ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.entityCache;
                    synchronized (concurrentHashMap) {
                        this.entityCache.put(entityId, (Pair<Long, Pair<Entity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
                    }
                    return pair;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Container getBlockInventory(Level world, BlockPos pos, boolean useNbt) {
        if (world instanceof WorldSchematic) {
            return InventoryUtils.getInventory((Level)world, (BlockPos)pos);
        }
        if (this.blockEntityCache.containsKey(pos)) {
            Container inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((CompoundTag)((CompoundTag)((Pair)this.blockEntityCache.get(pos).getRight()).getRight()), (int)-1, (RegistryAccess)world.registryAccess());
            } else {
                BlockEntity be = (BlockEntity)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
                BlockState state = world.getBlockState(pos);
                if (state.is(BlockTags.AIR) || !state.hasBlockEntity()) {
                    ConcurrentHashMap<BlockPos, Pair<Long, Pair<BlockEntity, CompoundTag>>> concurrentHashMap = this.blockEntityCache;
                    synchronized (concurrentHashMap) {
                        this.blockEntityCache.remove(pos);
                    }
                    return null;
                }
                if (be instanceof Container) {
                    Container inv1 = (Container)be;
                    if (be instanceof ChestBlockEntity && state.hasProperty((Property)ChestBlock.TYPE)) {
                        ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
                        if (type != ChestType.SINGLE) {
                            BlockPos posAdj = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                            if (!world.hasChunkAt(posAdj)) {
                                return null;
                            }
                            BlockState stateAdj = world.getBlockState(posAdj);
                            BlockEntity dataAdj = this.getFromBlockEntityCache(posAdj);
                            if (dataAdj == null) {
                                this.requestBlockEntity(world, posAdj);
                            }
                            if (stateAdj.getBlock() == state.getBlock() && dataAdj instanceof ChestBlockEntity) {
                                ChestBlockEntity inv2 = (ChestBlockEntity)dataAdj;
                                if (stateAdj.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && stateAdj.getValue((Property)ChestBlock.FACING) == state.getValue((Property)ChestBlock.FACING)) {
                                    Container invRight = type == ChestType.RIGHT ? inv1 : inv2;
                                    ChestBlockEntity invLeft = type == ChestType.RIGHT ? inv2 : inv1;
                                    inv = new CompoundContainer(invRight, (Container)invLeft);
                                }
                            }
                        } else {
                            inv = inv1;
                        }
                    } else {
                        inv = inv1;
                    }
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            this.requestBlockEntity(world, pos);
        }
        return null;
    }

    @Nullable
    public Container getEntityInventory(Level world, int entityId, boolean useNbt) {
        if (world instanceof WorldSchematic) {
            return null;
        }
        if (this.entityCache.containsKey(entityId) && this.getWorld() != null) {
            Container inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((CompoundTag)((CompoundTag)((Pair)this.entityCache.get(entityId).getRight()).getRight()), (int)-1, (RegistryAccess)this.getWorld().registryAccess());
            } else {
                Player player;
                Entity entity = (Entity)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
                if (entity instanceof Container) {
                    inv = (Container)entity;
                } else if (entity instanceof Player && (player = (Player)entity) != null) {
                    inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
                } else if (entity instanceof Villager) {
                    inv = ((Villager)entity).getInventory();
                } else if (entity instanceof AbstractHorse) {
                    inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
                } else if (entity instanceof Piglin) {
                    inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() || Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            this.requestEntity(world, entityId);
        }
        return null;
    }

    private void requestQueryBlockEntity(BlockPos pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        ClientPacketListener handler = this.getVanillaHandler();
        if (handler != null) {
            this.sentBackupPackets = true;
            handler.getDebugQueryHandler().queryBlockEntityTag(pos, nbtCompound -> this.handleBlockEntityData(pos, (CompoundTag)nbtCompound, null));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.getDebugQueryHandler()).malilib_currentTransactionId(), (Either<BlockPos, Integer>)Either.left((Object)pos));
        }
    }

    private void requestQueryEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        ClientPacketListener handler = this.getVanillaHandler();
        if (handler != null) {
            this.sentBackupPackets = true;
            handler.getDebugQueryHandler().queryEntityTag(entityId, nbtCompound -> this.handleEntityData(entityId, (CompoundTag)nbtCompound));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.getDebugQueryHandler()).malilib_currentTransactionId(), (Either<BlockPos, Integer>)Either.right((Object)entityId));
        }
    }

    private void requestServuxBlockEntityData(BlockPos pos) {
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxLitematicaPacket.BlockEntityRequest(pos));
        }
    }

    private void requestServuxEntityData(int entityId) {
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxLitematicaPacket.EntityRequest(entityId));
        }
    }

    public void requestServuxBulkEntityData(ChunkPos chunkPos, int minY, int maxY) {
        if (!this.hasServuxServer()) {
            return;
        }
        CompoundTag req = new CompoundTag();
        this.completedChunks.remove(chunkPos);
        this.pendingChunks.add(chunkPos);
        this.pendingChunkTimeout.put(chunkPos, Util.getMillis());
        minY = Mth.clamp((int)minY, (int)-60, (int)319);
        maxY = Mth.clamp((int)maxY, (int)-60, (int)319);
        req.putString("Task", "BulkEntityRequest");
        req.putInt("minY", minY);
        req.putInt("maxY", maxY);
        Litematica.debugLog("EntitiesDataStorage#requestServuxBulkEntityData(): for chunkPos [{}] to Servux (minY [{}], maxY [{}])", chunkPos.toString(), minY, maxY);
        HANDLER.encodeClientData(ServuxLitematicaPacket.BulkNbtRequest(chunkPos, req));
    }

    public void requestBackupBulkEntityData(ChunkPos chunkPos, int minY, int maxY) {
        ChunkAccess chunk;
        if (!this.getIfReceivedBackupPackets() || this.hasServuxServer()) {
            return;
        }
        this.completedChunks.remove(chunkPos);
        minY = Mth.clamp((int)minY, (int)-60, (int)319);
        maxY = Mth.clamp((int)maxY, (int)-60, (int)319);
        ClientLevel world = this.getClientWorld();
        ChunkAccess chunkAccess = chunk = world != null ? world.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false) : null;
        if (chunk == null) {
            return;
        }
        BlockPos pos1 = new BlockPos(chunkPos.getMinBlockX(), minY, chunkPos.getMinBlockZ());
        BlockPos pos2 = new BlockPos(chunkPos.getMaxBlockX(), maxY, chunkPos.getMaxBlockZ());
        AABB bb = PositionUtils.createEnclosingAABB(pos1, pos2);
        Set teSet = chunk.getBlockEntitiesPos();
        List entList = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
        Litematica.debugLog("EntitiesDataStorage#requestBackupBulkEntityData(): for chunkPos {} (minY [{}], maxY [{}]) // Request --> TE: [{}], E: [{}]", chunkPos.toString(), minY, maxY, teSet.size(), entList.size());
        for (BlockPos tePos : teSet) {
            if (tePos.getX() < chunkPos.getMinBlockX() || tePos.getX() > chunkPos.getMaxBlockX() || tePos.getZ() < chunkPos.getMinBlockZ() || tePos.getZ() > chunkPos.getMaxBlockZ() || tePos.getY() < minY || tePos.getY() > maxY) continue;
            this.requestBlockEntity((Level)world, tePos);
        }
        if (teSet.size() > 0) {
            this.pendingBackupChunk_BlockEntities.put(chunkPos, teSet);
        }
        LinkedHashSet<Integer> entSet = new LinkedHashSet<Integer>();
        for (Entity entity : entList) {
            this.requestEntity((Level)world, entity.getId());
            entSet.add(entity.getId());
        }
        if (entSet.size() > 0) {
            this.pendingBackupChunk_Entities.put(chunkPos, entSet);
        }
        if (teSet.size() > 0 || entSet.size() > 0) {
            this.pendingChunks.add(chunkPos);
            this.pendingChunkTimeout.put(chunkPos, Util.getMillis());
        } else {
            this.completedChunks.add(chunkPos);
        }
    }

    private boolean markBackupBlockEntityComplete(ChunkPos chunkPos, BlockPos pos) {
        Set<BlockPos> teSet;
        if (!this.getIfReceivedBackupPackets() || this.hasServuxServer()) {
            return true;
        }
        if (this.pendingChunks.contains(chunkPos) && this.pendingBackupChunk_BlockEntities.containsKey(chunkPos) && (teSet = this.pendingBackupChunk_BlockEntities.get(chunkPos)).contains(pos)) {
            teSet.remove(pos);
            if (teSet.isEmpty()) {
                Litematica.debugLog("EntitiesDataStorage#markBackupBlockEntityComplete(): ChunkPos {} - Block Entity List Complete!", chunkPos.toString());
                this.pendingBackupChunk_BlockEntities.remove(chunkPos);
                this.pendingChunks.remove(chunkPos);
                this.pendingChunkTimeout.remove(chunkPos);
                this.completedChunks.add(chunkPos);
                return true;
            }
            this.pendingBackupChunk_BlockEntities.replace(chunkPos, teSet);
        }
        return false;
    }

    private boolean markBackupEntityComplete(ChunkPos chunkPos, int entityId) {
        Set<Integer> entSet;
        if (!this.getIfReceivedBackupPackets() || this.hasServuxServer()) {
            return true;
        }
        if (this.pendingChunks.contains(chunkPos) && this.pendingBackupChunk_Entities.containsKey(chunkPos) && (entSet = this.pendingBackupChunk_Entities.get(chunkPos)).contains(entityId)) {
            entSet.remove(entityId);
            if (entSet.isEmpty()) {
                Litematica.debugLog("EntitiesDataStorage#markBackupEntityComplete(): ChunkPos {} - EntitiyList Complete!", chunkPos.toString());
                this.pendingBackupChunk_Entities.remove(chunkPos);
                this.pendingChunks.remove(chunkPos);
                this.pendingChunkTimeout.remove(chunkPos);
                this.completedChunks.add(chunkPos);
                return true;
            }
            this.pendingBackupChunk_Entities.replace(chunkPos, entSet);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BlockEntity handleBlockEntityData(BlockPos pos, CompoundTag nbt, @Nullable ResourceLocation type) {
        BlockEntity blockEntity2;
        BlockEntityType beType;
        this.pendingBlockEntitiesQueue.remove(pos);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        BlockEntity blockEntity = this.getClientWorld().getBlockEntity(pos);
        if (blockEntity != null && (type == null || type.equals((Object)BlockEntityType.getKey((BlockEntityType)blockEntity.getType())))) {
            Object id;
            if (!nbt.contains("id") && (id = BlockEntityType.getKey((BlockEntityType)blockEntity.getType())) != null) {
                nbt.putString("id", id.toString());
            }
            id = this.blockEntityCache;
            synchronized (id) {
                this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity, (Object)nbt)));
            }
            NbtView view = NbtView.getReader((CompoundTag)nbt, (RegistryAccess)this.getClientWorld().registryAccess());
            blockEntity.loadWithComponents(view.getReader());
            ChunkPos chunkPos = new ChunkPos(pos);
            if (this.hasPendingChunk(chunkPos) && !this.hasServuxServer()) {
                this.markBackupBlockEntityComplete(chunkPos, pos);
            }
            return blockEntity;
        }
        Optional opt = BuiltInRegistries.BLOCK_ENTITY_TYPE.get(type);
        if (opt.isPresent() && (beType = (BlockEntityType)((Holder.Reference)opt.get()).value()).isValid(this.getClientWorld().getBlockState(pos)) && (blockEntity2 = beType.create(pos, this.getClientWorld().getBlockState(pos))) != null) {
            ChunkPos chunkPos;
            Object id;
            if (!nbt.contains("id") && (id = BlockEntityType.getKey((BlockEntityType)beType)) != null) {
                nbt.putString("id", id.toString());
            }
            id = this.blockEntityCache;
            synchronized (id) {
                this.blockEntityCache.put(pos, (Pair<Long, Pair<BlockEntity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity2, (Object)nbt)));
            }
            if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                NbtView view = NbtView.getReader((CompoundTag)nbt, (RegistryAccess)this.getClientWorld().registryAccess());
                blockEntity2.loadWithComponents(view.getReader());
                this.getClientWorld().setBlockEntity(blockEntity2);
            }
            if (this.hasPendingChunk(chunkPos = new ChunkPos(pos)) && !this.hasServuxServer()) {
                this.markBackupBlockEntityComplete(chunkPos, pos);
            }
            return blockEntity2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity handleEntityData(int entityId, CompoundTag nbt) {
        this.pendingEntitiesQueue.remove(entityId);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        Entity entity = this.getClientWorld().getEntity(entityId);
        if (entity != null) {
            ResourceLocation id;
            if (!nbt.contains("id") && (id = EntityType.getKey((EntityType)entity.getType())) != null) {
                nbt.putString("id", id.toString());
            }
            ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.entityCache;
            synchronized (concurrentHashMap) {
                this.entityCache.put(entityId, (Pair<Long, Pair<Entity, CompoundTag>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)entity, (Object)nbt)));
            }
            if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                EntityUtils.loadNbtIntoEntity(entity, nbt);
            }
            if (this.hasPendingChunk(entity.chunkPosition()) && !this.hasServuxServer()) {
                this.markBackupEntityComplete(entity.chunkPosition(), entityId);
            }
        }
        return entity;
    }

    public void handleBulkEntityData(int transactionId, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        String task = nbt.getStringOr("Task", "BulkEntityReply");
        if (task.equals("BulkEntityReply")) {
            BlockPos pos;
            int i;
            ListTag tileList = nbt.contains("TileEntities") ? nbt.getListOrEmpty("TileEntities") : new ListTag();
            ListTag entityList = nbt.contains("Entities") ? nbt.getListOrEmpty("Entities") : new ListTag();
            ChunkPos chunkPos = new ChunkPos(nbt.getIntOr("chunkX", 0), nbt.getIntOr("chunkZ", 0));
            this.shouldUseLongTimeout = true;
            for (i = 0; i < tileList.size(); ++i) {
                CompoundTag te = tileList.getCompoundOrEmpty(i);
                pos = NbtUtils.readBlockPos((CompoundTag)te);
                ResourceLocation type = ResourceLocation.parse((String)te.getStringOr("id", ""));
                this.handleBlockEntityData(pos, te, type);
            }
            for (i = 0; i < entityList.size(); ++i) {
                CompoundTag ent = entityList.getCompoundOrEmpty(i);
                pos = NbtUtils.readEntityPositionFromTag((CompoundTag)ent);
                int entityId = ent.getIntOr("entityId", 0);
                this.handleEntityData(entityId, ent);
            }
            this.pendingChunks.remove(chunkPos);
            this.pendingChunkTimeout.remove(chunkPos);
            this.completedChunks.add(chunkPos);
            Litematica.debugLog("EntitiesDataStorage#handleBulkEntityData(): [ChunkPos {}] received TE: [{}], and E: [{}] entiries from Servux", chunkPos.toString(), tileList.size(), entityList.size());
        }
    }

    public void handleVanillaQueryNbt(int transactionId, CompoundTag nbt) {
        Either<BlockPos, Integer> either;
        if (this.checkOpStatus) {
            this.hasOpStatus = true;
            this.checkOpStatus = false;
            this.lastOpCheck = System.currentTimeMillis();
        }
        if ((either = this.transactionToBlockPosOrEntityId.remove(transactionId)) != null) {
            this.receivedBackupPackets = true;
            either.ifLeft(pos -> this.handleBlockEntityData((BlockPos)pos, nbt, null)).ifRight(entityId -> this.handleEntityData((int)entityId, nbt));
        }
    }

    public boolean hasPendingChunk(ChunkPos pos) {
        if (this.hasServuxServer() || this.getIfReceivedBackupPackets()) {
            return this.pendingChunks.contains(pos);
        }
        return false;
    }

    private void checkForPendingChunkTimeout(ChunkPos pos) {
        if (this.hasServuxServer() && this.hasPendingChunk(pos) || this.getIfReceivedBackupPackets() && this.hasPendingChunk(pos)) {
            long now = Util.getMillis();
            if (!fi.dy.masa.litematica.util.WorldUtils.isClientChunkLoaded(this.mc.level, pos.x, pos.z)) {
                this.pendingChunkTimeout.replace(pos, now);
                return;
            }
            long duration = now - this.pendingChunkTimeout.get(pos);
            if (duration > this.getChunkTimeoutMs()) {
                Litematica.debugLog("EntitiesDataStorage#checkForPendingChunkTimeout(): [ChunkPos {}] has timed out waiting for data, marking complete without Receiving Entity Data.", pos.toString());
                this.pendingChunkTimeout.remove(pos);
                this.pendingChunks.remove(pos);
                this.completedChunks.add(pos);
            }
        }
    }

    private long getChunkTimeoutMs() {
        if (this.hasServuxServer()) {
            return this.chunkTimeoutMs;
        }
        if (this.getIfReceivedBackupPackets()) {
            return this.chunkTimeoutMs + 3000L;
        }
        return 1000L;
    }

    public boolean hasCompletedChunk(ChunkPos pos) {
        if (this.hasServuxServer() || this.getIfReceivedBackupPackets()) {
            this.checkForPendingChunkTimeout(pos);
            return this.completedChunks.contains(pos);
        }
        return true;
    }

    public void markCompletedChunkDirty(ChunkPos pos) {
        if (this.hasServuxServer() || this.getIfReceivedBackupPackets()) {
            this.completedChunks.remove(pos);
        }
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    public void fromJson(JsonObject obj) {
    }
}

