/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import fi.dy.masa.litematica.data.CachedTagManager;
import fi.dy.masa.malilib.data.CachedTagKey;
import fi.dy.masa.malilib.data.CachedTagUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class MaterialListJsonOverrides {
    public static final MaterialListJsonOverrides INSTANCE = new MaterialListJsonOverrides();
    private final Set<ResultOverride> overrides = new HashSet<ResultOverride>();
    private final Set<ResultOverride> packingOverrides = new HashSet<ResultOverride>();

    protected MaterialListJsonOverrides() {
        this.initOverrides();
        this.initPackingOverrides();
    }

    private Holder<Item> add(Item item) {
        return BuiltInRegistries.ITEM.wrapAsHolder((Object)item);
    }

    private void initOverrides() {
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_COPPER), this.add(Items.COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_COPPER), this.add(Items.COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_COPPER), this.add(Items.COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_COPPER), this.add(Items.WAXED_COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_COPPER), this.add(Items.WAXED_COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_COPPER), this.add(Items.WAXED_COPPER_BLOCK), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_COPPER_GRATE), this.add(Items.COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_COPPER_GRATE), this.add(Items.COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_COPPER_GRATE), this.add(Items.COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_COPPER_GRATE), this.add(Items.WAXED_COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_COPPER_GRATE), this.add(Items.WAXED_COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_COPPER_GRATE), this.add(Items.WAXED_COPPER_GRATE), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_CUT_COPPER), this.add(Items.CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_CUT_COPPER), this.add(Items.CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_CUT_COPPER), this.add(Items.CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_CUT_COPPER), this.add(Items.WAXED_CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_CUT_COPPER), this.add(Items.WAXED_CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_CUT_COPPER), this.add(Items.WAXED_CUT_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_CHISELED_COPPER), this.add(Items.CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_CHISELED_COPPER), this.add(Items.CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_CHISELED_COPPER), this.add(Items.CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_CHISELED_COPPER), this.add(Items.WAXED_CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_CHISELED_COPPER), this.add(Items.WAXED_CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_CHISELED_COPPER), this.add(Items.WAXED_CHISELED_COPPER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_COPPER_BULB), this.add(Items.COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_COPPER_BULB), this.add(Items.COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_COPPER_BULB), this.add(Items.COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_COPPER_BULB), this.add(Items.WAXED_COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_COPPER_BULB), this.add(Items.WAXED_COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_COPPER_BULB), this.add(Items.WAXED_COPPER_BULB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_CUT_COPPER_SLAB), this.add(Items.CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_CUT_COPPER_SLAB), this.add(Items.CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_CUT_COPPER_SLAB), this.add(Items.CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_CUT_COPPER_SLAB), this.add(Items.WAXED_CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_CUT_COPPER_SLAB), this.add(Items.WAXED_CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_CUT_COPPER_SLAB), this.add(Items.WAXED_CUT_COPPER_SLAB), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_CUT_COPPER_STAIRS), this.add(Items.CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_CUT_COPPER_STAIRS), this.add(Items.CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_CUT_COPPER_STAIRS), this.add(Items.CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_CUT_COPPER_STAIRS), this.add(Items.WAXED_CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_CUT_COPPER_STAIRS), this.add(Items.WAXED_CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS), this.add(Items.WAXED_CUT_COPPER_STAIRS), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_COPPER_DOOR), this.add(Items.COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_COPPER_DOOR), this.add(Items.COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_COPPER_DOOR), this.add(Items.COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_COPPER_DOOR), this.add(Items.WAXED_COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_COPPER_DOOR), this.add(Items.WAXED_COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_COPPER_DOOR), this.add(Items.WAXED_COPPER_DOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.EXPOSED_COPPER_TRAPDOOR), this.add(Items.COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WEATHERED_COPPER_TRAPDOOR), this.add(Items.COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.OXIDIZED_COPPER_TRAPDOOR), this.add(Items.COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_EXPOSED_COPPER_TRAPDOOR), this.add(Items.WAXED_COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_WEATHERED_COPPER_TRAPDOOR), this.add(Items.WAXED_COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WAXED_OXIDIZED_COPPER_TRAPDOOR), this.add(Items.WAXED_COPPER_TRAPDOOR), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_ACACIA_LOG), this.add(Items.ACACIA_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_BAMBOO_BLOCK), this.add(Items.BAMBOO), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_BIRCH_LOG), this.add(Items.BIRCH_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_CHERRY_LOG), this.add(Items.CHERRY_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_CRIMSON_STEM), this.add(Items.CRIMSON_STEM), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_DARK_OAK_LOG), this.add(Items.DARK_OAK_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_JUNGLE_LOG), this.add(Items.JUNGLE_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_MANGROVE_LOG), this.add(Items.MANGROVE_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_OAK_LOG), this.add(Items.OAK_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_PALE_OAK_LOG), this.add(Items.PALE_OAK_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_SPRUCE_LOG), this.add(Items.SPRUCE_LOG), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.STRIPPED_WARPED_STEM), this.add(Items.WARPED_STEM), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.BLACK_CONCRETE), this.add(Items.BLACK_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.BLUE_CONCRETE), this.add(Items.BLUE_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.BROWN_CONCRETE), this.add(Items.BROWN_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.CYAN_CONCRETE), this.add(Items.CYAN_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.GRAY_CONCRETE), this.add(Items.GRAY_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.GREEN_CONCRETE), this.add(Items.GREEN_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.LIGHT_BLUE_CONCRETE), this.add(Items.LIGHT_BLUE_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.LIGHT_GRAY_CONCRETE), this.add(Items.LIGHT_GRAY_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.LIME_CONCRETE), this.add(Items.LIME_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.MAGENTA_CONCRETE), this.add(Items.MAGENTA_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.ORANGE_CONCRETE), this.add(Items.ORANGE_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.PINK_CONCRETE), this.add(Items.PINK_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.PURPLE_CONCRETE), this.add(Items.PURPLE_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.RED_CONCRETE), this.add(Items.RED_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.YELLOW_CONCRETE), this.add(Items.YELLOW_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.WHITE_CONCRETE), this.add(Items.WHITE_CONCRETE_POWDER), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.CHIPPED_ANVIL), this.add(Items.ANVIL), Fraction.ONE));
        this.overrides.add(new ResultOverride(this.add(Items.DAMAGED_ANVIL), this.add(Items.ANVIL), Fraction.ONE));
    }

    private void initPackingOverrides() {
        Fraction by9 = Fraction.getFraction((int)1, (int)9);
        this.packingOverrides.add(new ResultOverride(this.add(Items.CLAY_BALL), this.add(Items.CLAY), Fraction.ONE_QUARTER));
        this.packingOverrides.add(new ResultOverride(this.add(Items.HONEY_BOTTLE), this.add(Items.HONEY_BLOCK), Fraction.ONE_QUARTER));
        this.packingOverrides.add(new ResultOverride(this.add(Items.BONE_MEAL), this.add(Items.BONE_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.COAL), this.add(Items.COAL_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.COPPER_INGOT), this.add(Items.COPPER_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.DIAMOND), this.add(Items.DIAMOND_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.EMERALD), this.add(Items.EMERALD_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.GOLD_INGOT), this.add(Items.GOLD_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.GOLD_NUGGET), this.add(Items.GOLD_INGOT), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.IRON_INGOT), this.add(Items.IRON_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.IRON_NUGGET), this.add(Items.IRON_INGOT), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.LAPIS_LAZULI), this.add(Items.LAPIS_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.MELON_SLICE), this.add(Items.MELON), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.NETHERITE_INGOT), this.add(Items.NETHERITE_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.REDSTONE), this.add(Items.REDSTONE_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.RESIN_BRICK), this.add(Items.RESIN_BRICKS), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.RESIN_CLUMP), this.add(Items.RESIN_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.SLIME_BALL), this.add(Items.SLIME_BLOCK), by9));
        this.packingOverrides.add(new ResultOverride(this.add(Items.WHEAT), this.add(Items.HAY_BLOCK), by9));
    }

    protected Pair<Holder<Item>, Integer> matchOverride(Holder<Item> result, Integer total) {
        for (ResultOverride map : this.overrides) {
            if (!map.match(result)) continue;
            return Pair.of(map.result(), (Object)map.mulInt(total));
        }
        return Pair.of(result, (Object)total);
    }

    protected Triple<Holder<Item>, Float, Integer> matchPackingOverride(Holder<Item> result, Integer total) {
        for (ResultOverride map : this.packingOverrides) {
            if (!map.match(result)) continue;
            return Triple.of(map.result(), (Object)map.mulFloat(total), (Object)map.divisor());
        }
        return Triple.of(result, (Object)Float.valueOf(total.floatValue()), (Object)1);
    }

    protected Holder<Item> overridePrimaryMaterial(Holder<Item> firstItem) {
        if (firstItem.is(ItemTags.WOOL)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_WOOL);
        }
        if (firstItem.is(ItemTags.WOOL_CARPETS)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_CARPET);
        }
        if (firstItem.is(ItemTags.BEDS)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_BED);
        }
        if (firstItem.is(ItemTags.CANDLES)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.CANDLE);
        }
        if (firstItem.is(ItemTags.SHULKER_BOXES)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.SHULKER_BOX);
        }
        if (firstItem.is(ItemTags.BANNERS)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_BANNER);
        }
        if (firstItem.is(ItemTags.TERRACOTTA)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.TERRACOTTA);
        }
        if (firstItem.is(ItemTags.BUNDLES)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.BUNDLE);
        }
        if (firstItem.is(ItemTags.HARNESSES)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_HARNESS);
        }
        if (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLASS_ITEMS_KEY, firstItem)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.GLASS);
        }
        if (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLASS_PANE_ITEMS_KEY, firstItem)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.GLASS_PANE);
        }
        if (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.CONCRETE_POWDER_ITEMS_KEY, firstItem)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_CONCRETE_POWDER);
        }
        if (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.CONCRETE_ITEMS_KEY, firstItem)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_CONCRETE);
        }
        if (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLAZED_TERRACOTTA_ITEMS_KEY, firstItem)) {
            return BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.WHITE_GLAZED_TERRACOTTA);
        }
        return (Holder)this.matchOverride(firstItem, 1).getLeft();
    }

    protected boolean overrideShouldSkipRecipe(Holder<Item> input, List<Ingredient> ingredients) {
        for (Ingredient ing : ingredients) {
            if (!(input.is(ItemTags.BEDS) ? ing.test(Items.WHITE_BED.getDefaultInstance()) || ing.test(Items.BLACK_BED.getDefaultInstance()) : (input.is(ItemTags.WOOL) ? ing.test(Items.WHITE_WOOL.getDefaultInstance()) || ing.test(Items.BLACK_WOOL.getDefaultInstance()) : (input.is(ItemTags.WOOL_CARPETS) ? ing.test(Items.WHITE_CARPET.getDefaultInstance()) || ing.test(Items.BLACK_CARPET.getDefaultInstance()) : (input.is(ItemTags.CANDLES) ? ing.test(Items.WHITE_CANDLE.getDefaultInstance()) || ing.test(Items.BLACK_CANDLE.getDefaultInstance()) : (input.is(ItemTags.SHULKER_BOXES) ? ing.test(Items.WHITE_SHULKER_BOX.getDefaultInstance()) || ing.test(Items.BLACK_SHULKER_BOX.getDefaultInstance()) : (input.is(ItemTags.BANNERS) ? ing.test(Items.WHITE_BANNER.getDefaultInstance()) || ing.test(Items.BLACK_BANNER.getDefaultInstance()) : (input.is(ItemTags.TERRACOTTA) ? ing.test(Items.WHITE_TERRACOTTA.getDefaultInstance()) || ing.test(Items.BLACK_TERRACOTTA.getDefaultInstance()) : (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLASS_ITEMS_KEY, input) ? ing.test(Items.WHITE_STAINED_GLASS.getDefaultInstance()) || ing.test(Items.BLACK_STAINED_GLASS.getDefaultInstance()) : (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLASS_PANE_ITEMS_KEY, input) ? ing.test(Items.WHITE_STAINED_GLASS_PANE.getDefaultInstance()) || ing.test(Items.BLACK_STAINED_GLASS_PANE.getDefaultInstance()) : (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.CONCRETE_ITEMS_KEY, input) ? ing.test(Items.WHITE_CONCRETE.getDefaultInstance()) || ing.test(Items.BLACK_CONCRETE.getDefaultInstance()) : (CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.CONCRETE_POWDER_ITEMS_KEY, input) ? ing.test(Items.WHITE_CONCRETE_POWDER.getDefaultInstance()) || ing.test(Items.BLACK_CONCRETE_POWDER.getDefaultInstance()) : CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.GLAZED_TERRACOTTA_ITEMS_KEY, input) && (ing.test(Items.WHITE_GLAZED_TERRACOTTA.getDefaultInstance()) || ing.test(Items.BLACK_GLAZED_TERRACOTTA.getDefaultInstance())))))))))))))) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldKeepItemOrBlock(Holder<Item> input) {
        return CachedTagUtils.matchItemTag((CachedTagKey)CachedTagManager.UNPACKED_BLOCK_ITEMS_KEY, input);
    }

    public record ResultOverride(Holder<Item> input, Holder<Item> result, Fraction multiplier) {
        public boolean match(Holder<Item> otherItem) {
            return this.input().is((ResourceKey)otherItem.unwrapKey().orElseThrow());
        }

        public Integer mulInt(Integer totalIn) {
            return totalIn * this.multiplier().intValue();
        }

        public Float mulFloat(Integer totalIn) {
            return Float.valueOf((float)totalIn.intValue() * this.multiplier().floatValue());
        }

        public Integer divisor() {
            return this.multiplier().getDenominator();
        }
    }
}

