/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LitematicaDebugHud
implements DebugScreenEntry {
    public static final ResourceLocation LITEMATICA_DEBUG = ResourceLocation.fromNamespaceAndPath((String)"litematica", (String)"litematica_renderer");
    public static final ResourceLocation SECTION_ID = ResourceLocation.withDefaultNamespace((String)"litematica");

    public void display(DebugScreenDisplayer lines, @Nullable Level world, @Nullable LevelChunk clientChunk, @Nullable LevelChunk chunk) {
        List<String> list = LitematicaDebugHud.getDebugLines();
        if (!list.isEmpty()) {
            lines.addToGroup(SECTION_ID, list);
        }
    }

    public boolean isAllowed(boolean reducedDebugInfo) {
        return true;
    }

    public static List<String> getDebugLines() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        ArrayList<String> list = new ArrayList<String>();
        if (worldSchematic != null) {
            Pair<String, String> pair = EntityUtils.getEntityDebug();
            String pre = GuiBase.TXT_GOLD;
            String rst = GuiBase.TXT_RST;
            WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            list.add(String.format("%s[Litematica]%s %s", pre, rst, renderer.getDebugInfoRenders()));
            String str = String.format("E: %d TE: %d C: %d, CT: %d, CV: %d", worldSchematic.getRegularEntityCount(), worldSchematic.getChunkProvider().getTileEntityCount(), worldSchematic.getChunkProvider().getLoadedChunksCount(), DataManager.getSchematicPlacementManager().getTouchedChunksCount(), DataManager.getSchematicPlacementManager().getLastVisibleChunksCount());
            list.add(String.format("%s[Litematica]%s %s %s", pre, rst, renderer.getDebugInfoEntities(), str));
            if (!((String)pair.getLeft()).isEmpty()) {
                list.add(String.format("%s[%s]%s %s", pre, pair.getLeft(), rst, pair.getRight()));
            }
        }
        return list;
    }
}

