/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.litematica.render.schematic.BuiltBufferCache;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChunkRenderDataSchematic
implements AutoCloseable {
    public static final ChunkRenderDataSchematic EMPTY = new ChunkRenderDataSchematic(){

        @Override
        protected void setBlockLayerUsed(ChunkSectionLayer layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setBlockLayerStarted(ChunkSectionLayer layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setLayerUsed(RenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setLayerStarted(RenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setOverlayTypeUsed(OverlayRenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void setOverlayTypeStarted(OverlayRenderType layer) {
            throw new UnsupportedOperationException();
        }
    };
    private final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
    private final List<BlockEntity> noCullBlockEntities = new ArrayList<BlockEntity>();
    private final Set<ChunkSectionLayer> blockLayersUsed = new ObjectArraySet();
    private final Set<ChunkSectionLayer> blockLayersStarted = new ObjectArraySet();
    private final Set<RenderType> layersUsed = new ObjectArraySet();
    private final Set<RenderType> layersStarted = new ObjectArraySet();
    private final Set<OverlayRenderType> overlayLayersUsed = new ObjectArraySet();
    private final Set<OverlayRenderType> overlayLayersStarted = new ObjectArraySet();
    private final BuiltBufferCache builtBufferCache = new BuiltBufferCache();
    private final Map<ChunkSectionLayer, MeshData.SortState> blockSortingData = new HashMap<ChunkSectionLayer, MeshData.SortState>();
    private final Map<RenderType, MeshData.SortState> layerSortingData = new HashMap<RenderType, MeshData.SortState>();
    private final Map<OverlayRenderType, MeshData.SortState> overlaySortingData = new HashMap<OverlayRenderType, MeshData.SortState>();
    private boolean blocksEmpty = true;
    private boolean layerEmpty = true;
    private boolean overlayEmpty = true;
    private long timeBuilt;

    public boolean isBlockLayerEmpty() {
        return this.blocksEmpty;
    }

    public boolean isLayerEmpty() {
        return this.layerEmpty;
    }

    public int getStartedSize() {
        return this.blockLayersStarted.size() + this.layersStarted.size() + this.overlayLayersStarted.size();
    }

    public int getUsedSize() {
        return this.blockLayersUsed.size() + this.layersUsed.size() + this.overlayLayersUsed.size();
    }

    public int getSize() {
        return Math.max(this.getStartedSize(), this.getUsedSize());
    }

    public boolean isBlockLayerEmpty(ChunkSectionLayer layer) {
        return !this.blockLayersUsed.contains(layer);
    }

    public boolean isLayerEmpty(RenderType layer) {
        return !this.layersUsed.contains(layer);
    }

    public boolean isOverlayEmpty() {
        return this.overlayEmpty;
    }

    public boolean isOverlayTypeEmpty(OverlayRenderType type) {
        return !this.overlayLayersUsed.contains((Object)type);
    }

    public boolean isBlockLayerStarted(ChunkSectionLayer layer) {
        return this.blockLayersStarted.contains(layer);
    }

    public boolean isLayerStarted(RenderType layer) {
        return this.layersStarted.contains(layer);
    }

    public boolean isOverlayTypeStarted(OverlayRenderType type) {
        return this.overlayLayersStarted.contains((Object)type);
    }

    protected void setBlockLayerStarted(ChunkSectionLayer layer) {
        this.blockLayersStarted.add(layer);
    }

    protected void setBlockLayerUsed(ChunkSectionLayer layer) {
        this.blocksEmpty = false;
        this.blockLayersUsed.add(layer);
    }

    protected void setBlockLayerUnused(ChunkSectionLayer layer) {
        this.blockLayersStarted.remove(layer);
        this.blockLayersUsed.remove(layer);
    }

    protected void setLayerStarted(RenderType layer) {
        this.layersStarted.add(layer);
    }

    protected void setLayerUsed(RenderType layer) {
        this.layerEmpty = false;
        this.layersUsed.add(layer);
    }

    protected void setBlockLayerUnused(RenderType layer) {
        this.layersStarted.remove(layer);
        this.layersUsed.remove(layer);
    }

    protected void setOverlayTypeStarted(OverlayRenderType type) {
        this.overlayLayersStarted.add(type);
    }

    protected void setOverlayTypeUsed(OverlayRenderType type) {
        this.overlayEmpty = false;
        this.overlayLayersUsed.add(type);
    }

    protected void setOverlayTypeUnused(OverlayRenderType type) {
        this.overlayLayersStarted.remove((Object)type);
        this.overlayLayersUsed.remove((Object)type);
    }

    public List<BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public List<BlockEntity> getNoCullBlockEntities() {
        return this.noCullBlockEntities;
    }

    protected void addBlockEntity(BlockEntity be) {
        this.blockEntities.add(be);
    }

    protected void addNoCullBlockEntity(BlockEntity be) {
        this.noCullBlockEntities.add(be);
    }

    protected BuiltBufferCache getBuiltBufferCache() {
        return this.builtBufferCache;
    }

    protected void closeBuiltBufferCache() {
        this.builtBufferCache.closeAll();
    }

    public boolean hasTransparentSortingDataForBlockLayer(ChunkSectionLayer layer) {
        return this.blockSortingData.get(layer) != null;
    }

    public boolean hasTransparentSortingDataForLayer(RenderType layer) {
        return this.layerSortingData.get(layer) != null;
    }

    public boolean hasTransparentSortingDataForOverlay(OverlayRenderType type) {
        return this.overlaySortingData.get((Object)type) != null;
    }

    protected void setTransparentSortingDataForBlockLayer(ChunkSectionLayer layer, @Nonnull MeshData.SortState transparentSortingData) {
        this.blockSortingData.put(layer, transparentSortingData);
    }

    protected void setTransparentSortingDataForLayer(RenderType layer, @Nonnull MeshData.SortState transparentSortingData) {
        this.layerSortingData.put(layer, transparentSortingData);
    }

    protected void setTransparentSortingDataForOverlay(OverlayRenderType type, @Nonnull MeshData.SortState transparentSortingData) {
        this.overlaySortingData.put(type, transparentSortingData);
    }

    protected MeshData.SortState getTransparentSortingDataForBlockLayer(ChunkSectionLayer layer) {
        return this.blockSortingData.get(layer);
    }

    protected MeshData.SortState getTransparentSortingDataForLayer(RenderType layer) {
        return this.layerSortingData.get(layer);
    }

    @Nullable
    protected MeshData.SortState getTransparentSortingDataForOverlay(OverlayRenderType type) {
        return this.overlaySortingData.get((Object)type);
    }

    public long getTimeBuilt() {
        return this.timeBuilt;
    }

    protected void setTimeBuilt(long time) {
        this.timeBuilt = time;
    }

    protected void clearAll() {
        this.closeBuiltBufferCache();
        this.timeBuilt = 0L;
        this.overlaySortingData.clear();
        this.layerSortingData.clear();
        this.blockSortingData.clear();
        this.blockLayersUsed.clear();
        this.layersUsed.clear();
        this.overlayLayersUsed.clear();
        this.blockLayersStarted.clear();
        this.layersStarted.clear();
        this.overlayLayersStarted.clear();
        this.blockEntities.clear();
        this.noCullBlockEntities.clear();
        this.overlayEmpty = true;
        this.layerEmpty = true;
        this.blocksEmpty = true;
    }

    @Override
    public void close() throws Exception {
        this.clearAll();
    }
}

