/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.Iterables;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SchematicEntityLookup<T extends EntityAccess>
implements LevelEntityGetter<T>,
AutoCloseable {
    private final ConcurrentHashMap<Integer, T> entityMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Integer> uuidMap = new ConcurrentHashMap();

    protected SchematicEntityLookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(T entity) {
        T tmp = this.get(entity.getUUID());
        if (tmp != null) {
            this.remove(entity.getUUID());
        }
        ConcurrentHashMap<Comparable<UUID>, Integer> concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.put(entity.getUUID(), entity.getId());
        }
        concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.put(entity.getId(), entity);
        }
    }

    protected int size() {
        return this.entityMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(UUID uuid) {
        Integer key = this.uuidMap.get(uuid);
        if (key != null) {
            ConcurrentHashMap<Comparable<Integer>, Object> concurrentHashMap = this.entityMap;
            synchronized (concurrentHashMap) {
                this.entityMap.remove(key);
            }
            concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
        }
        ConcurrentHashMap<Integer, T> concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            for (Integer id : this.entityMap.keySet()) {
                EntityAccess e = (EntityAccess)this.entityMap.get(id);
                if (!e.getUUID().equals(uuid)) continue;
                this.entityMap.remove(id);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get(int id) {
        if (this.entityMap.containsKey(id)) {
            EntityAccess e = (EntityAccess)this.entityMap.get(id);
            if (!this.uuidMap.containsKey(e.getUUID())) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(e.getUUID(), id);
                }
            }
            return (T)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get(UUID uuid) {
        if (this.uuidMap.containsKey(uuid)) {
            int key = this.uuidMap.get(uuid);
            if (this.entityMap.containsKey(key)) {
                return (T)((EntityAccess)this.entityMap.get(key));
            }
            ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
            synchronized (concurrentHashMap) {
                this.uuidMap.remove(uuid);
            }
            return null;
        }
        for (Integer id : this.entityMap.keySet()) {
            EntityAccess e = (EntityAccess)this.entityMap.get(id);
            if (!e.getUUID().equals(uuid)) continue;
            if (!this.uuidMap.containsKey(uuid)) {
                ConcurrentHashMap<UUID, Integer> concurrentHashMap = this.uuidMap;
                synchronized (concurrentHashMap) {
                    this.uuidMap.put(uuid, id);
                }
            }
            return (T)e;
        }
        return null;
    }

    public Iterable<T> getAll() {
        return Iterables.unmodifiableIterable(this.entityMap.values());
    }

    public void get(AABB box, Consumer<T> action) {
        this.entityMap.forEach((id, e) -> {
            AbortableIterationConsumer consumer;
            if (box.intersects(e.getBoundingBox()) && (consumer = AbortableIterationConsumer.forConsumer((Consumer)action)).accept(e).shouldAbort()) {
                return;
            }
        });
    }

    public <U extends T> void get(EntityTypeTest<T, U> filter, AABB box, AbortableIterationConsumer<U> consumer) {
        this.entityMap.forEach((id, e) -> {
            EntityAccess filtered = (EntityAccess)filter.tryCast(e);
            if (filtered != null && box.intersects(filtered.getBoundingBox()) && consumer.accept((Object)filtered).shouldAbort()) {
                return;
            }
        });
    }

    public <U extends T> void get(EntityTypeTest<T, U> filter, AbortableIterationConsumer<U> consumer) {
        this.entityMap.forEach((id, e) -> {
            EntityAccess filtered = (EntityAccess)filter.tryCast(e);
            if (filtered != null && consumer.accept((Object)filtered).shouldAbort()) {
                return;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ConcurrentHashMap<Comparable<Integer>, Object> concurrentHashMap = this.entityMap;
        synchronized (concurrentHashMap) {
            this.entityMap.clear();
        }
        concurrentHashMap = this.uuidMap;
        synchronized (concurrentHashMap) {
            this.uuidMap.clear();
        }
    }
}

