/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.network;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.network.ServuxLitematicaPacket;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ServuxLitematicaHandler<T extends CustomPacketPayload>
implements IPluginClientPlayHandler<T> {
    private static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> INSTANCE = new ServuxLitematicaHandler<ServuxLitematicaPacket.Payload>(){

        public void receive(ServuxLitematicaPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"servux", (String)"litematics");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public ResourceLocation getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public <P extends IClientPayloadData> void decodeClientData(ResourceLocation channel, P data) {
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_METADATA: {
                if (!EntitiesDataStorage.getInstance().receiveServuxMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_BLOCK_NBT_RESPONSE_SIMPLE: {
                EntitiesDataStorage.getInstance().handleBlockEntityData(packet.getPos(), packet.getCompound(), null);
                break;
            }
            case PACKET_S2C_ENTITY_NBT_RESPONSE_SIMPLE: {
                EntitiesDataStorage.getInstance().handleEntityData(packet.getEntityId(), packet.getCompound());
                break;
            }
            case PACKET_S2C_NBT_RESPONSE_DATA: {
                FriendlyByteBuf fullPacket;
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = RandomSource.create((long)Util.getMillis()).nextLong();
                }
                if ((fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (FriendlyByteBuf)packet.getBuffer())) == null) break;
                try {
                    this.readingSessionKey = -1L;
                    this.handleBulkData(fullPacket.readVarInt(), (CompoundTag)fullPacket.readNbt(NbtAccounter.unlimitedHeap()));
                }
                catch (Exception e) {
                    Litematica.LOGGER.error("ServuxLitematicaHandler#decodeClientData(): Entity Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Litematica.LOGGER.warn("ServuxLitematicaHandler#decodeClientData(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    private void handleBulkData(int type, @Nullable CompoundTag nbt) {
        String task;
        if (nbt == null || nbt.isEmpty()) {
            return;
        }
        switch (task = nbt.getStringOr("Task", "BulkEntityReply")) {
            case "Litematic-TransmitStart": 
            case "Litematic-TransmitCancel": 
            case "Litematic-TransmitData": 
            case "Litematic-TransmitEnd": {
                Pair<LitematicaSchematic, CompoundTag> schemPair = LitematicaSchematic.receiveFileTransmit(nbt);
                if (schemPair == null || ((LitematicaSchematic)schemPair.getLeft()).getFile() == null) break;
                Litematica.LOGGER.info("handleBulkData(): Received litematic '{}' from the server", (Object)((LitematicaSchematic)schemPair.getLeft()).getFile().toAbsolutePath().toString());
                SchematicPlacement placement = SchematicPlacement.createFromNbt((LitematicaSchematic)schemPair.getLeft(), (CompoundTag)schemPair.getRight());
                if (placement == null) break;
                DataManager.getSchematicPlacementManager().addSchematicPlacement(placement, true);
                break;
            }
            default: {
                EntitiesDataStorage.getInstance().handleBulkEntityData(type, nbt);
            }
        }
    }

    public void reset(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.type().id().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeClientData(CHANNEL_ID, ((ServuxLitematicaPacket.Payload)payload).data());
        }
    }

    public void encodeWithSplitter(FriendlyByteBuf buffer, ClientPacketListener handler) {
        INSTANCE.sendPlayPayload(new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.ResponseC2SData(buffer)));
    }

    public <P extends IClientPayloadData> void encodeClientData(P data) {
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (packet.getType().equals((Object)ServuxLitematicaPacket.Type.PACKET_C2S_NBT_RESPONSE_START)) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeVarInt(packet.getTransactionId());
            buffer.writeNbt((Tag)packet.getCompound());
            PacketSplitter.send((IPluginClientPlayHandler)this, (FriendlyByteBuf)buffer, (ClientPacketListener)Minecraft.getInstance().getConnection());
        } else if (!INSTANCE.sendPlayPayload(new ServuxLitematicaPacket.Payload(packet))) {
            if (this.failures > 4) {
                Litematica.LOGGER.warn("encodeClientData(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", (Object)4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                EntitiesDataStorage.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

