/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfo {
    private final String title;
    private final BlockState state;
    private final ItemStack stack;
    private final String blockRegistryname;
    private final String stackName;
    private final List<String> props;
    private final int totalWidth;
    private final int totalHeight;
    private boolean useBackgroundMask = false;

    public BlockInfo(BlockState state, String titleKey) {
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        this.title = pre + StringUtils.translate((String)titleKey, (Object[])new Object[0]) + GuiBase.TXT_RST;
        this.state = state;
        this.stack = ItemUtils.getItemForState(this.state);
        ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock());
        this.blockRegistryname = rl.toString();
        this.stackName = this.stack.getHoverName().getString();
        int w = StringUtils.getStringWidth((String)this.stackName) + 20;
        w = Math.max(w, StringUtils.getStringWidth((String)this.blockRegistryname));
        w = Math.max(w, StringUtils.getStringWidth((String)this.title));
        this.props = BlockUtils.getFormattedBlockStateProperties((BlockState)this.state, (String)" = ");
        this.totalWidth = w + 40;
        this.totalHeight = this.props.size() * (StringUtils.getFontHeight() + 2) + 60;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void toggleUseBackgroundMask(boolean toggle) {
        this.useBackgroundMask = toggle;
    }

    public void render(GuiGraphics drawContext, int x, int y, Minecraft mc) {
        if (this.state != null) {
            if (this.useBackgroundMask) {
                RenderUtils.renderBackgroundMask(drawContext, x + 1, y + 1, this.totalWidth - 1, this.totalHeight - 1);
            }
            fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((GuiGraphics)drawContext, (int)x, (int)y, (int)this.totalWidth, (int)this.totalHeight, (int)-16777216, (int)-6710887);
            Font textRenderer = mc.font;
            int x1 = x + 10;
            drawContext.drawString(textRenderer, this.title, x1, y += 4, -1, false);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiGraphics)drawContext, (int)x1, (int)(y += 12), (int)16, (int)16, (int)0x20FFFFFF);
            drawContext.renderItem(this.stack, x1, y);
            drawContext.renderItemDecorations(textRenderer, this.stack, x1, y);
            drawContext.drawString(textRenderer, this.stackName, x1 + 20, y + 4, -1, false);
            drawContext.drawString(textRenderer, this.blockRegistryname, x1, y += 20, -12558081, false);
            Objects.requireNonNull(textRenderer);
            fi.dy.masa.malilib.render.RenderUtils.renderText((GuiGraphics)drawContext, (int)x1, (int)(y += 9 + 4), (int)-5197648, this.props);
        }
    }
}

