/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.ao.AOProcessor;
import fi.dy.masa.litematica.render.schematic.ao.AOProcessorModern;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class BlockModelRendererSchematic {
    private final SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
    private final BlockColors colorMap;
    private final LiquidBlockRenderer liquidRenderer;
    private ModelManager bakedManager;
    public static final ThreadLocal<AOProcessorModern.BC> CACHE = ThreadLocal.withInitial(AOProcessorModern.BC::new);

    public BlockModelRendererSchematic(BlockColors blockColorsIn) {
        this.colorMap = blockColorsIn;
        this.liquidRenderer = new LiquidBlockRenderer();
    }

    public void setBakedManager(ModelManager manager) {
        this.bakedManager = manager;
    }

    public static void enableCache() {
        if (Configs.Visuals.RENDER_AO_MODERN_ENABLE.getBooleanValue()) {
            CACHE.get().enable();
        }
    }

    public static void disableCache() {
        if (Configs.Visuals.RENDER_AO_MODERN_ENABLE.getBooleanValue()) {
            CACHE.get().disable();
        }
    }

    public boolean renderModel(BlockAndTintGetter worldIn, List<BlockModelPart> modelParts, BlockState stateIn, BlockPos posIn, PoseStack matrixStack, VertexConsumer vertexConsumer, long rand) {
        boolean ao = Minecraft.useAmbientOcclusion() && stateIn.getLightEmission() == 0 && !modelParts.isEmpty() && modelParts.getFirst().useAmbientOcclusion();
        Vec3 offset = stateIn.getOffset(posIn);
        matrixStack.translate((float)offset.x, (float)offset.y, (float)offset.z);
        int overlay = OverlayTexture.NO_OVERLAY;
        try {
            if (ao) {
                return this.renderModelSmooth(worldIn, modelParts, stateIn, posIn, matrixStack, vertexConsumer, (BitRandomSource)this.random, rand, overlay);
            }
            return this.renderModelFlat(worldIn, modelParts, stateIn, posIn, matrixStack, vertexConsumer, (BitRandomSource)this.random, rand, overlay);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)worldIn, (BlockPos)posIn, (BlockState)stateIn);
            crashreportcategory.setDetail("Using AO", (Object)ao);
            throw new ReportedException(crashreport);
        }
    }

    public boolean renderModelSmooth(BlockAndTintGetter worldIn, List<BlockModelPart> modelParts, BlockState stateIn, BlockPos posIn, PoseStack matrixStack, VertexConsumer vertexConsumer, BitRandomSource random, long seedIn, int overlay) {
        boolean renderedSomething = false;
        float[] quadBounds = new float[PositionUtils.ALL_DIRECTIONS.length * 2];
        BitSet bitset = new BitSet(3);
        AOProcessor aoFace = AOProcessor.get();
        BlockPos.MutableBlockPos mutablePos = posIn.mutable();
        for (BlockModelPart part : modelParts) {
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                random.setSeed(seedIn);
                List quads = part.getQuads(side);
                if (quads.isEmpty()) continue;
                mutablePos.setWithOffset((Vec3i)posIn, side);
                if (!this.shouldRenderModelSide(worldIn, stateIn, posIn, side, (BlockPos)mutablePos)) continue;
                this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStack, vertexConsumer, quads, quadBounds, bitset, aoFace, overlay);
                renderedSomething = true;
            }
            random.setSeed(seedIn);
            List quads = part.getQuads(null);
            if (quads.isEmpty()) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStack, vertexConsumer, quads, quadBounds, bitset, aoFace, overlay);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public boolean renderModelFlat(BlockAndTintGetter worldIn, List<BlockModelPart> modelParts, BlockState stateIn, BlockPos posIn, PoseStack matrixStack, VertexConsumer vertexConsumer, BitRandomSource random, long seedIn, int overlay) {
        boolean renderedSomething = false;
        BitSet bitset = new BitSet(3);
        BlockPos.MutableBlockPos mutablePos = posIn.mutable();
        for (BlockModelPart part : modelParts) {
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                random.setSeed(seedIn);
                List quads = part.getQuads(side);
                if (quads.isEmpty()) continue;
                mutablePos.setWithOffset((Vec3i)posIn, side);
                if (!this.shouldRenderModelSide(worldIn, stateIn, posIn, side, (BlockPos)mutablePos)) continue;
                int light = LevelRenderer.getLightColor((BlockAndTintGetter)worldIn, (BlockPos)mutablePos);
                this.renderQuadsFlat(worldIn, stateIn, posIn, light, overlay, false, matrixStack, vertexConsumer, quads, bitset);
                renderedSomething = true;
            }
            random.setSeed(seedIn);
            List quads = part.getQuads(null);
            if (quads.isEmpty()) continue;
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, overlay, true, matrixStack, vertexConsumer, quads, bitset);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public boolean shouldRenderModelSide(BlockAndTintGetter worldIn, BlockState stateIn, BlockPos posIn, Direction side, BlockPos mutable) {
        return DataManager.getRenderLayerRange().isPositionAtRenderEdgeOnSide(posIn, side) || Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && Configs.Visuals.RENDER_TRANSLUCENT_INNER_SIDES.getBooleanValue() || Block.shouldRenderFace((BlockState)stateIn, (BlockState)worldIn.getBlockState(mutable), (Direction)side);
    }

    private void renderQuadsSmooth(BlockAndTintGetter world, BlockState state, BlockPos pos, PoseStack matrixStack, VertexConsumer vertexConsumer, List<BakedQuad> list, float[] box, BitSet flags, AOProcessor aoCalc, int overlay) {
        int size = list.size();
        for (BakedQuad bakedQuad : list) {
            this.getQuadDimensions(world, state, pos, bakedQuad.vertices(), bakedQuad.direction(), box, flags);
            aoCalc.apply(world, state, pos, bakedQuad.direction(), box, flags, bakedQuad.shade());
            this.renderQuad(world, state, pos, vertexConsumer, matrixStack, bakedQuad, aoCalc.brightness, aoCalc.light, overlay);
        }
    }

    private void renderQuadsFlat(BlockAndTintGetter world, BlockState state, BlockPos pos, int light, int overlay, boolean useWorldLight, PoseStack matrixStack, VertexConsumer vertexConsumer, List<BakedQuad> list, BitSet flags) {
        for (BakedQuad bakedQuad : list) {
            if (useWorldLight) {
                this.getQuadDimensions(world, state, pos, bakedQuad.vertices(), bakedQuad.direction(), null, flags);
                BlockPos blockPos = flags.get(0) ? pos.relative(bakedQuad.direction()) : pos;
                light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)blockPos);
            }
            float b = world.getShade(bakedQuad.direction(), bakedQuad.shade());
            int[] lo = new int[]{light, light, light, light};
            float[] bo = new float[]{b, b, b, b};
            this.renderQuad(world, state, pos, vertexConsumer, matrixStack, bakedQuad, bo, lo, overlay);
        }
    }

    private void renderQuad(BlockAndTintGetter world, BlockState state, BlockPos pos, VertexConsumer vertexConsumer, PoseStack matrixStack, BakedQuad quad, float[] brightness, int[] light, int overlay) {
        float b;
        float g;
        float r;
        if (quad.isTinted()) {
            int color = this.colorMap.getColor(state, world, pos, quad.tintIndex());
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        }
        vertexConsumer.putBulkData(matrixStack.last(), quad, brightness, r, g, b, 1.0f, light, overlay, true);
    }

    private void getQuadDimensions(BlockAndTintGetter world, BlockState state, BlockPos pos, int[] vertexData, Direction face, @Nullable float[] box, BitSet flags) {
        float minX = 32.0f;
        float minY = 32.0f;
        float minZ = 32.0f;
        float maxX = -32.0f;
        float maxY = -32.0f;
        float maxZ = -32.0f;
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float x = Float.intBitsToFloat(vertexData[index * vertexSize]);
            float y = Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float z = Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        if (box != null) {
            box[Direction.WEST.get3DDataValue()] = minX;
            box[Direction.EAST.get3DDataValue()] = maxX;
            box[Direction.DOWN.get3DDataValue()] = minY;
            box[Direction.UP.get3DDataValue()] = maxY;
            box[Direction.NORTH.get3DDataValue()] = minZ;
            box[Direction.SOUTH.get3DDataValue()] = maxZ;
            box[Direction.WEST.get3DDataValue() + 6] = 1.0f - minX;
            box[Direction.EAST.get3DDataValue() + 6] = 1.0f - maxX;
            box[Direction.DOWN.get3DDataValue() + 6] = 1.0f - minY;
            box[Direction.UP.get3DDataValue() + 6] = 1.0f - maxY;
            box[Direction.NORTH.get3DDataValue() + 6] = 1.0f - minZ;
            box[Direction.SOUTH.get3DDataValue() + 6] = 1.0f - maxZ;
        }
        float min = 1.0E-4f;
        float max = 0.9999f;
        switch (face) {
            case DOWN: {
                flags.set(1, minX >= min || minZ >= min || maxX <= max || maxZ <= max);
                flags.set(0, minY == maxY && (minY < min || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
                break;
            }
            case UP: {
                flags.set(1, minX >= min || minZ >= min || maxX <= max || maxZ <= max);
                flags.set(0, minY == maxY && (maxY > max || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
                break;
            }
            case NORTH: {
                flags.set(1, minX >= min || minY >= min || maxX <= max || maxY <= max);
                flags.set(0, minZ == maxZ && (minZ < min || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
                break;
            }
            case SOUTH: {
                flags.set(1, minX >= min || minY >= min || maxX <= max || maxY <= max);
                flags.set(0, minZ == maxZ && (maxZ > max || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
                break;
            }
            case WEST: {
                flags.set(1, minY >= min || minZ >= min || maxY <= max || maxZ <= max);
                flags.set(0, minX == maxX && (minX < min || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
                break;
            }
            case EAST: {
                flags.set(1, minY >= min || minZ >= min || maxY <= max || maxZ <= max);
                flags.set(0, minX == maxX && (maxX > max || state.isCollisionShapeFullBlock((BlockGetter)world, pos)));
            }
        }
    }

    @ApiStatus.Experimental
    public void renderBlockEntity(VertexConsumer vertexConsumer, PoseStack matrixStack, BlockStateModel modelIn, float red, float green, float blue, int light, int overlay) {
        List parts = modelIn.collectParts(RandomSource.create((long)42L));
        for (BlockModelPart part : parts) {
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                this.renderBlockEntityQuads(vertexConsumer, matrixStack, red, green, blue, part.getQuads(side), light, overlay);
            }
            this.renderBlockEntityQuads(vertexConsumer, matrixStack, red, green, blue, part.getQuads(null), light, overlay);
        }
    }

    @ApiStatus.Experimental
    private void renderBlockEntityQuads(VertexConsumer vertexConsumer, PoseStack matrixStack, float red, float green, float blue, List<BakedQuad> quads, int light, int overlay) {
        for (BakedQuad quad : quads) {
            float h;
            float g;
            float f;
            if (quad.isTinted()) {
                f = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
                g = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
                h = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
            } else {
                h = 1.0f;
                g = 1.0f;
                f = 1.0f;
            }
            vertexConsumer.putBulkData(matrixStack.last(), quad, f, g, h, 1.0f, light, overlay);
        }
    }

    @ApiStatus.Experimental
    public void renderLiquid(VertexConsumer consumer, BlockAndTintGetter world, BlockPos pos, BlockState stateIn, FluidState fluid) {
        try {
            this.liquidRenderer.tesselate(world, pos, consumer, stateIn, fluid);
        }
        catch (Throwable var9) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var9, (String)"Tesselating liquid in world");
            CrashReportCategory crashReportSection = crashReport.addCategory("Block being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportSection, (LevelHeightAccessor)world, (BlockPos)pos, (BlockState)stateIn);
            throw new ReportedException(crashReport);
        }
    }

    public BlockStateModel getBakedModel(BlockState stateIn) {
        return this.bakedManager.getBlockModelShaper().getBlockModel(stateIn);
    }

    @ApiStatus.Experimental
    public boolean renderBlockEntity(MultiBufferSource consumer, PoseStack matrixStack, BlockState stateIn, int light, int overlay) {
        RenderShape blockRenderType = stateIn.getRenderShape();
        if (blockRenderType == RenderShape.INVISIBLE) {
            return false;
        }
        BlockStateModel bakedModel = this.getBakedModel(stateIn);
        int i = this.colorMap.getColor(stateIn, null, null, 0);
        float red = (float)(i >> 16 & 0xFF) / 255.0f;
        float green = (float)(i >> 8 & 0xFF) / 255.0f;
        float blue = (float)(i & 0xFF) / 255.0f;
        this.renderBlockEntity(consumer.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)stateIn)), matrixStack, bakedModel, red, green, blue, light, overlay);
        return true;
    }
}

