/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import org.apache.commons.lang3.tuple.Pair;

public record ChunkRenderLayers() {
    public static final List<ChunkSectionLayer> BLOCK_RENDER_LAYERS = ChunkRenderLayers.getBlockRenderLayers();
    public static final List<RenderType> RENDER_LAYERS = ChunkRenderLayers.getRenderLayers();
    public static final List<OverlayRenderType> TYPES = ChunkRenderLayers.getTypes();
    public static final HashMap<ChunkSectionLayer, Pair<RenderPipeline, RenderPipeline>> PIPELINE_MAP = ChunkRenderLayers.getBlockRenderPipelineMap();

    private static List<ChunkSectionLayer> getBlockRenderLayers() {
        ArrayList<ChunkSectionLayer> list = new ArrayList<ChunkSectionLayer>();
        list.add(ChunkSectionLayer.SOLID);
        list.add(ChunkSectionLayer.CUTOUT);
        list.add(ChunkSectionLayer.CUTOUT_MIPPED);
        list.add(ChunkSectionLayer.TRANSLUCENT);
        list.add(ChunkSectionLayer.TRIPWIRE);
        return list;
    }

    private static HashMap<ChunkSectionLayer, Pair<RenderPipeline, RenderPipeline>> getBlockRenderPipelineMap() {
        HashMap<ChunkSectionLayer, Pair<RenderPipeline, RenderPipeline>> map = new HashMap<ChunkSectionLayer, Pair<RenderPipeline, RenderPipeline>>();
        map.put(ChunkSectionLayer.SOLID, Pair.of((Object)MaLiLibPipelines.SOLID_MASA, (Object)MaLiLibPipelines.SOLID_MASA_OFFSET));
        map.put(ChunkSectionLayer.CUTOUT, Pair.of((Object)MaLiLibPipelines.CUTOUT_MASA, (Object)MaLiLibPipelines.CUTOUT_MASA_OFFSET));
        map.put(ChunkSectionLayer.CUTOUT_MIPPED, Pair.of((Object)MaLiLibPipelines.CUTOUT_MIPPED_MASA, (Object)MaLiLibPipelines.CUTOUT_MIPPED_MASA_OFFSET));
        map.put(ChunkSectionLayer.TRANSLUCENT, Pair.of((Object)MaLiLibPipelines.TRANSLUCENT_MASA, (Object)MaLiLibPipelines.TRANSLUCENT_MASA_OFFSET));
        map.put(ChunkSectionLayer.TRIPWIRE, Pair.of((Object)MaLiLibPipelines.TRIPWIRE_MASA, (Object)MaLiLibPipelines.TRIPWIRE_MASA_OFFSET));
        return map;
    }

    private static List<RenderType> getRenderLayers() {
        ArrayList<RenderType> list = new ArrayList<RenderType>();
        list.add(RenderType.waterMask());
        return list;
    }

    private static List<OverlayRenderType> getTypes() {
        return Arrays.stream(OverlayRenderType.values()).toList();
    }

    public static String getFriendlyName(RenderType layer) {
        String base = layer.toString();
        if (base.contains(":")) {
            String[] results1 = base.split(":", 2);
            if (results1[0].contains("[")) {
                String[] results2 = results1[0].split("\\[");
                return layer.mode().name() + "/" + results2[1];
            }
            return layer.mode().name() + "/" + results1[0];
        }
        return layer.mode().name() + "/" + base;
    }
}

