/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class CachedItemTags {
    private static final CachedItemTags INSTANCE = new CachedItemTags();
    private final HashMap<String, Entry> entries = new HashMap();

    public static CachedItemTags getInstance() {
        return INSTANCE;
    }

    private CachedItemTags() {
    }

    public void build(String name, @Nonnull List<String> list) {
        if (name.isEmpty()) {
            Litematica.LOGGER.error("CachedItemTags#build: Invalid list name.");
            return;
        }
        if (list.isEmpty()) {
            Litematica.LOGGER.warn("CachedItemTags#build: list '{}' is empty.", (Object)name);
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(name, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
    }

    @Nullable
    public Entry get(String name) {
        if (this.entries.containsKey(name)) {
            return this.entries.get(name);
        }
        return null;
    }

    public void clear() {
        this.entries.forEach((name, entry) -> entry.clear());
    }

    public List<String> matchAny(Item item) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(item)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public List<String> matchAny(Holder<Item> item) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(item)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public boolean match(String name, Item item) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(item);
        }
        Litematica.LOGGER.warn("CachedItemTags#match(Item): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public boolean match(String name, Holder<Item> item) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(item);
        }
        Litematica.LOGGER.warn("CachedItemTags#match(RegistryEntry): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((name, entry) -> obj.add(name, entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            Entry entry;
            if (!obj.isJsonArray() || (entry = Entry.fromJson(obj.get(key))) == null) continue;
            this.entries.put(key, entry);
        }
    }

    public static class Entry {
        private final HashSet<Holder<Item>> items = new HashSet();
        private final HashSet<HolderSet<Item>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertItem(Item item) {
            this.items.add((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
        }

        public void insertItem(Holder<Item> item) {
            this.items.add(item);
        }

        public void insertTag(TagKey<Item> tag) {
            if (Minecraft.getInstance().level != null) {
                Registry wrapper = Minecraft.getInstance().level.registryAccess().lookupOrThrow(BuiltInRegistries.ITEM.key());
                wrapper.get(tag).ifPresent(this.tags::add);
            }
        }

        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.substring(1));
                if (id != null) {
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                    if (tag != null) {
                        this.insertTag((TagKey<Item>)tag);
                    } else {
                        Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                ResourceLocation id = ResourceLocation.tryParse((String)entry);
                if (id != null) {
                    Item item = (Item)BuiltInRegistries.ITEM.getValue(id);
                    if (item != null) {
                        this.insertItem(item);
                    } else {
                        Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(Item item) {
            Holder entry = BuiltInRegistries.ITEM.wrapAsHolder((Object)item);
            for (HolderSet<Item> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return true;
            }
            return this.items.contains(entry);
        }

        public boolean contains(Holder<Item> item) {
            return this.contains((Item)item.value());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.items.forEach(entry -> list.add(entry.getRegisteredName()));
            this.tags.forEach(entry -> list.add("#" + entry.unwrapKey().toString()));
            return list;
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.items.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.getRegisteredName())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.unwrapKey().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.items.clear();
            this.tags.clear();
        }
    }
}

