/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.compat.sodium.SodiumCompat;
import fi.dy.masa.litematica.mixin.IMixinProfilerSystem;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.chunk.ChunkSectionsToRender;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private Frustum cullingFrustum;
    @Unique
    private ProfilerFiller profiler;

    @Inject(method={"allChanged()V"}, at={@At(value="RETURN")})
    private void litematica_onLoadRenderers(CallbackInfo ci) {
        if (this.level != null && this.level == this.minecraft.level) {
            ActiveProfiler ps;
            ProfilerFiller profilerFiller;
            if (this.profiler == null) {
                this.profiler = Profiler.get();
            }
            if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
                this.profiler.startTick();
            }
            LitematicaRenderer.getInstance().loadRenderers(this.profiler);
            SchematicWorldRefresher.INSTANCE.updateAll();
        }
    }

    @Inject(method={"compileSections(Lnet/minecraft/client/Camera;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=1)})
    private void litematica_onPostUpdateChunks(Camera camera, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        LitematicaRenderer.getInstance().piecewisePrepareAndUpdate(this.cullingFrustum, this.profiler);
        if (SodiumCompat.hasSodium()) {
            LitematicaRenderer.getInstance().scheduleTranslucentSorting(camera.getPosition(), this.profiler);
        }
    }

    @Inject(method={"scheduleTranslucentSectionResort(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="TAIL")})
    private void litematica_onScheduleTranslucentSort(Vec3 cameraPos, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        if (!SodiumCompat.hasSodium()) {
            LitematicaRenderer.getInstance().scheduleTranslucentSorting(cameraPos, this.profiler);
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addMainPass(Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;ZZLnet/minecraft/client/DeltaTracker;Lnet/minecraft/util/profiling/ProfilerFiller;)V", shift=At.Shift.BEFORE)})
    private void litematica_onPreRenderMain(GraphicsResourceAllocator allocator, DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, Matrix4f positionMatrix, Matrix4f projectionMatrix, GpuBufferSlice fog, Vector4f fogColor, boolean shouldRenderSky, CallbackInfo ci, @Local ProfilerFiller profiler) {
        this.profiler = profiler;
        LitematicaRenderer.getInstance().capturePreMainValues(fog, profiler);
    }

    @Inject(method={"prepareChunkRenders(Lorg/joml/Matrix4fc;DDD)Lnet/minecraft/client/renderer/chunk/ChunkSectionsToRender;"}, at={@At(value="TAIL")})
    private void litematica_onPrepareBlockLayers(Matrix4fc matrix4fc, double d, double e, double f, CallbackInfoReturnable<ChunkSectionsToRender> cir) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        LitematicaRenderer.getInstance().piecewisePrepareBlockLayers(matrix4fc, d, e, f, this.profiler);
        if (SodiumCompat.hasSodium()) {
            LitematicaRenderer.getInstance().piecewiseDrawBlockLayerGroup(ChunkSectionLayerGroup.OPAQUE);
            SodiumCompat.startBlockOutlineEnabled();
        }
    }

    @Inject(method={"renderEntities(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/Camera;Lnet/minecraft/client/DeltaTracker;Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void litematica_onPostRenderEntities(PoseStack matrices, MultiBufferSource.BufferSource immediate, Camera camera, DeltaTracker tickCounter, List<Entity> entities, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        LitematicaRenderer.getInstance().piecewiseRenderEntities(matrices, immediate, tickCounter.getGameTimeDeltaPartialTick(false), this.profiler);
    }

    @Inject(method={"renderBlockEntities(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/Camera;F)V"}, at={@At(value="RETURN")})
    private void litematica_onPostRenderBlockEntities(PoseStack matrices, MultiBufferSource.BufferSource entityVertexConsumers, MultiBufferSource.BufferSource effectVertexConsumers, Camera camera, float tickProgress, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        LitematicaRenderer.getInstance().piecewiseRenderBlockEntities(matrices, entityVertexConsumers, effectVertexConsumers, tickProgress, this.profiler);
    }

    @Inject(method={"renderBlockOutline(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lcom/mojang/blaze3d/vertex/PoseStack;Z)V"}, at={@At(value="HEAD")})
    private void litematica_onRenderTargetOutline(Camera camera, MultiBufferSource.BufferSource vertexConsumers, PoseStack matrices, boolean translucent, CallbackInfo ci) {
        if (SodiumCompat.hasSodium() && translucent) {
            LitematicaRenderer.getInstance().piecewiseDrawBlockLayerGroup(ChunkSectionLayerGroup.TRANSLUCENT);
            LitematicaRenderer.getInstance().piecewiseDrawBlockLayerGroup(ChunkSectionLayerGroup.TRIPWIRE);
            SodiumCompat.endBlockOutlineEnabled();
        }
    }
}

