/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderObjectBuffers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.GpuBufferCache;
import fi.dy.masa.litematica.render.schematic.IBufferBuilderPatch;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.IgnoreBlockRegistry;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.Logger;

public class ChunkRendererSchematicVbo
implements AutoCloseable {
    private static final Logger LOGGER = Litematica.LOGGER;
    protected static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final ReentrantLock chunkRenderLock;
    protected final ReentrantLock chunkRenderDataLock;
    protected final Set<BlockEntity> setBlockEntities = new HashSet<BlockEntity>();
    protected ProfilerFiller profiler;
    protected final BlockPos.MutableBlockPos position;
    protected final BlockPos.MutableBlockPos chunkRelativePos;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private AABB boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    private boolean ignoreClientWorldFluids;
    private IgnoreBlockRegistry ignoreBlockRegistry;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    private final BufferBuilderCache builderCache;
    private final GpuBufferCache gpuBufferCache;
    protected ChunkRenderTaskSchematic compileTask;
    protected ChunkRenderDataSchematic chunkRenderData;
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    protected ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.chunkRenderLock = new ReentrantLock();
        this.chunkRenderDataLock = new ReentrantLock();
        this.position = new BlockPos.MutableBlockPos();
        this.chunkRelativePos = new BlockPos.MutableBlockPos();
        this.builderCache = new BufferBuilderCache();
        this.gpuBufferCache = new GpuBufferCache();
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    protected ProfilerFiller getProfiler() {
        if (this.profiler == null) {
            this.profiler = this.worldRenderer.getProfiler();
        }
        return this.profiler;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBlockBuffersByBlockLayer(ChunkSectionLayer layer) {
        if (this.gpuBufferCache.hasBuffersByBlockLayer(layer)) {
            return this.gpuBufferCache.getBuffersByBlockLayer(layer);
        }
        return null;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBlockBuffersByLayer(RenderType layer) {
        if (this.gpuBufferCache.hasBuffersByLayer(layer)) {
            return this.gpuBufferCache.getBuffersByLayer(layer);
        }
        return null;
    }

    @Nullable
    protected ChunkRenderObjectBuffers getOverlayBuffersByType(OverlayRenderType type) {
        if (this.gpuBufferCache.hasBuffersByType(type)) {
            return this.gpuBufferCache.getBuffersByType(type);
        }
        return null;
    }

    protected ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    protected BufferBuilderCache getBuilderCache() {
        return this.builderCache;
    }

    protected GpuBufferCache getGpuBufferCache() {
        return this.gpuBufferCache;
    }

    protected void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.chunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public BlockPos getOrigin() {
        return this.position;
    }

    public AABB getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.getX();
            int y = this.position.getY();
            int z = this.position.getZ();
            this.boundingBox = new AABB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + this.world.getHeight()), (double)(z + 16));
        }
        return this.boundingBox;
    }

    protected void setPosition(int x, int y, int z) {
        if (x != this.position.getX() || y != this.position.getY() || z != this.position.getZ()) {
            this.clear();
            this.boundingBox = null;
            this.position.set(x, y, z);
        }
    }

    protected double getDistanceSq() {
        Entity entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return 0.0;
        }
        double x = (double)this.position.getX() + 8.0 - entity.getX();
        double z = (double)this.position.getZ() + 8.0 - entity.getZ();
        return x * x + z * z;
    }

    protected void deleteGlResources() {
        this.clear();
        this.closeAllVertexBuffers();
    }

    private void closeAllVertexBuffers() {
        this.gpuBufferCache.clearAll();
    }

    protected void resortTransparency(ChunkRenderTaskSchematic task, ProfilerFiller profiler) {
        this.profiler = profiler;
        this.getProfiler().push("resort_task");
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        Vec3 cameraPos = task.getCameraPosSupplier().get();
        ChunkSectionLayer layerTranslucent = ChunkSectionLayer.TRANSLUCENT;
        BufferAllocatorCache allocators = task.getAllocatorCache();
        float x = (float)cameraPos.x - (float)this.position.getX();
        float y = (float)cameraPos.y - (float)this.position.getY();
        float z = (float)cameraPos.z - (float)this.position.getZ();
        if (!data.isBlockLayerEmpty(layerTranslucent) && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
            this.getProfiler().popPush("resort_blocks");
            if (data.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layerTranslucent)) {
                try {
                    this.resortRenderBlocks(layerTranslucent, x, y, z, data, allocators);
                }
                catch (Exception e) {
                    LOGGER.error("resortTransparency() [VBO] caught exception for layer [{}] // {}", (Object)layerTranslucent.label(), (Object)e.toString());
                }
            }
        }
        this.getProfiler().pop();
        this.profiler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildChunk(ChunkRenderTaskSchematic task, ProfilerFiller profiler) {
        this.profiler = profiler;
        this.getProfiler().push("rebuild_chunk");
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            task.setChunkRenderData(data);
        }
        finally {
            task.getLock().unlock();
        }
        this.builderCache.clearAll();
        this.gpuBufferCache.clearAll();
        BlockPos.MutableBlockPos posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        BufferAllocatorCache allocators = task.getAllocatorCache();
        if (!allocators.isClear()) {
            allocators.resetAll();
        }
        this.existingOverlays.clear();
        this.hasOverlay = false;
        this.getProfiler().popPush("rebuild_chunk_start");
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            int minX = posChunk.getX();
            int minY = posChunk.getY();
            int minZ = posChunk.getZ();
            int maxX = minX + 15;
            int maxY = minY + this.world.getHeight();
            int maxZ = minZ + 15;
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ))) {
                ++schematicRenderChunksUpdated;
                Vec3 cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.x - (float)this.position.getX();
                float y = (float)cameraPos.y - (float)this.position.getY();
                float z = (float)cameraPos.z - (float)this.position.getZ();
                HashSet<ChunkSectionLayer> usedBlockLayers = new HashSet<ChunkSectionLayer>();
                HashSet<RenderType> usedRenderLayers = new HashSet<RenderType>();
                PoseStack matrixStack = new PoseStack();
                int bottomY = this.position.getY();
                this.getProfiler().popPush("rebuild_chunk_boxes");
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    BlockPos posFrom = new BlockPos(box.minX, box.minY, box.minZ);
                    BlockPos posTo = new BlockPos(box.maxX, box.maxY, box.maxZ);
                    for (BlockPos posMutable : BlockPos.MutableBlockPos.betweenClosed((BlockPos)posFrom, (BlockPos)posTo)) {
                        matrixStack.pushPose();
                        matrixStack.translate((float)(posMutable.getX() & 0xF), (float)(posMutable.getY() - bottomY), (float)(posMutable.getZ() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, allocators, usedBlockLayers, usedRenderLayers, matrixStack);
                        matrixStack.popPose();
                    }
                }
                this.getProfiler().popPush("rebuild_chunk_layers");
                for (ChunkSectionLayer layerTmp : ChunkRenderLayers.BLOCK_RENDER_LAYERS) {
                    if (usedBlockLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    try {
                        data.setBlockLayerUsed(layerTmp);
                        this.postRenderBlocks(layerTmp, x, y, z, data, allocators);
                    }
                    catch (Exception e) {
                        LOGGER.error("rebuildChunk() [VBO] failed to postRenderBlocks() for layer [{}] --> {}", (Object)layerTmp.label(), (Object)e.toString());
                    }
                }
                if (this.hasOverlay) {
                    this.getProfiler().popPush("rebuild_chunk_overlays");
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        try {
                            data.setOverlayTypeUsed(type);
                            this.postRenderOverlay(type, x, y, z, data, allocators);
                        }
                        catch (Exception e) {
                            LOGGER.error("rebuildChunk() [VBO] failed to postRenderOverlay() for overlay type [{}] --> {}", (Object)type.getDrawMode().name(), (Object)e.toString());
                        }
                    }
                }
            }
        }
        this.getProfiler().popPush("rebuild_chunk_lock");
        this.chunkRenderLock.lock();
        try {
            HashSet set2;
            List<BlockEntity> noCull = data.getNoCullBlockEntities();
            HashSet set = Sets.newHashSet(noCull);
            Set<BlockEntity> set3 = this.setBlockEntities;
            synchronized (set3) {
                set2 = Sets.newHashSet(this.setBlockEntities);
                set.removeAll(this.setBlockEntities);
                noCull.forEach(set2::remove);
                this.setBlockEntities.clear();
                this.setBlockEntities.addAll(noCull);
            }
            this.worldRenderer.updateBlockEntities(set2, set);
            this.builderCache.clearAll();
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        this.getProfiler().pop();
        this.profiler = null;
        data.setTimeBuilt(this.world.getGameTime());
    }

    protected void renderBlocksAndOverlay(BlockPos pos, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators, Set<ChunkSectionLayer> usedBlockLayers, Set<RenderType> usedRenderLayers, PoseStack matrixStack) {
        BlockState stateSchematic = this.schematicWorldView.getBlockState(pos);
        BlockState stateClient = this.clientWorldView.getBlockState(pos);
        boolean clientHasAir = stateClient.isAir();
        boolean schematicHasAir = stateSchematic.isAir();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.getProfiler().push("render_build");
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            ChunkSectionLayer layer;
            if (stateSchematic.hasBlockEntity()) {
                this.addBlockEntity(pos, data);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            FluidState fluidState = stateSchematic.getFluidState();
            if (!fluidState.isEmpty() && Configs.Visuals.ENABLE_SCHEMATIC_FLUIDS.getBooleanValue()) {
                this.getProfiler().popPush("render_build_fluids");
                layer = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
                int offsetY = (pos.getY() >> 4 << 4) - this.position.getY();
                BufferBuilder bufferSchematic = this.builderCache.getBufferByBlockLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                ((IBufferBuilderPatch)bufferSchematic).litematica$setOffsetY(offsetY);
                this.worldRenderer.renderFluid(this.schematicWorldView, stateSchematic, fluidState, pos, bufferSchematic);
                usedBlockLayers.add(layer);
                ((IBufferBuilderPatch)bufferSchematic).litematica$setOffsetY(0.0f);
            }
            if (stateSchematic.getRenderShape() != RenderShape.INVISIBLE) {
                this.getProfiler().popPush("render_build_blocks");
                layer = translucent ? ChunkSectionLayer.TRANSLUCENT : ItemBlockRenderTypes.getChunkRenderType((BlockState)stateSchematic);
                BufferBuilder bufferSchematic = this.builderCache.getBufferByBlockLayer(layer, allocators);
                if (!data.isBlockLayerStarted(layer) || bufferSchematic == null) {
                    data.setBlockLayerStarted(layer);
                    bufferSchematic = this.preRenderBlocks(layer, allocators);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrixStack, bufferSchematic)) {
                    usedBlockLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            this.getProfiler().popPush("render_build_overlays");
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = ChunkRendererSchematicVbo.getOverlayColor(type);
            if (this.overlayColor != null) {
                if (!stateSchematic.getFluidState().isEmpty() && !Configs.Visuals.ENABLE_SCHEMATIC_FLUIDS.getBooleanValue()) {
                    this.getProfiler().pop();
                    return;
                }
                this.renderOverlay(type, pos, stateSchematic, missing, data, allocators);
            }
        }
        this.getProfiler().pop();
    }

    protected void renderOverlay(OverlayType type, BlockPos pos, BlockState stateSchematic, boolean missing, @Nonnull ChunkRenderDataSchematic data, @Nonnull BufferAllocatorCache allocators) {
        List<BlockModelPart> modelParts;
        OverlayRenderType overlayType;
        this.getProfiler().push("render_overlay");
        boolean useDefault = false;
        BlockPos.MutableBlockPos relPos = this.getChunkRelativePosition(pos);
        RandomSource rand = RandomSource.create();
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            this.getProfiler().push("overlay_sides");
            overlayType = OverlayRenderType.QUAD;
            BufferBuilder bufferOverlayQuads = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayQuads == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayQuads = this.preRenderOverlay(overlayType, allocators);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                this.getProfiler().popPush("cull_inner_sides");
                BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
                modelParts = this.worldRenderer.getModelParts((BlockPos)relPos, stateSchematic, rand);
                if (!RenderUtils.hasQuads(modelParts)) {
                    useDefault = true;
                } else {
                    VoxelShape shape = stateSchematic.getCollisionShape((BlockGetter)this.schematicWorldView, pos);
                    for (int i = 0; i < 6; ++i) {
                        Direction side = PositionUtils.ALL_DIRECTIONS[i];
                        posMutable.set(pos.getX() + side.getStepX(), pos.getY() + side.getStepY(), pos.getZ() + side.getStepZ());
                        BlockState adjStateSchematic = this.schematicWorldView.getBlockState((BlockPos)posMutable);
                        BlockState adjStateClient = this.clientWorldView.getBlockState((BlockPos)posMutable);
                        OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                        boolean fullSquareSide = Block.isFaceFull((VoxelShape)shape, (Direction)side);
                        if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                            this.getProfiler().popPush("cull_render_model_sides");
                            if (type.getRenderPriority() <= typeAdj.getRenderPriority() && fullSquareSide) continue;
                            this.getProfiler().popPush("cull_render_model");
                            for (BlockModelPart part : modelParts) {
                                RenderUtils.drawBlockModelQuadOverlayBatched(part, stateSchematic, (BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                            }
                            continue;
                        }
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                        this.getProfiler().popPush("cull_render_default");
                        RenderUtils.drawBlockBoxSideBatchedQuads((BlockPos)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                    }
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                this.getProfiler().popPush("render_model_sides");
                List<BlockModelPart> modelParts2 = this.worldRenderer.getModelParts((BlockPos)relPos, stateSchematic, rand);
                if (!RenderUtils.hasQuads(modelParts2)) {
                    useDefault = true;
                } else {
                    RenderUtils.drawBlockModelQuadOverlayBatched(modelParts2, stateSchematic, (BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else {
                this.getProfiler().popPush("render_batched");
                RenderUtils.drawBlockBoxBatchedQuads((BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            }
            if (useDefault) {
                try {
                    this.getProfiler().popPush("render_batched_default");
                    RenderUtils.drawBlockBoxBatchedQuads((BlockPos)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
                }
                catch (Exception modelParts2) {
                    // empty catch block
                }
            }
            this.getProfiler().pop();
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            this.getProfiler().push("overlay_outlines");
            useDefault = false;
            overlayType = OverlayRenderType.OUTLINE;
            BufferBuilder bufferOverlayOutlines = this.builderCache.getBufferByOverlay(overlayType, allocators);
            if (!data.isOverlayTypeStarted(overlayType) || bufferOverlayOutlines == null) {
                data.setOverlayTypeStarted(overlayType);
                bufferOverlayOutlines = this.preRenderOverlay(overlayType, allocators);
            }
            Color4f overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            this.getProfiler().popPush("cull_inner_sides");
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.set(pos.getX() + x - 1, pos.getY() + y - 1, pos.getZ() + z - 1);
                                BlockState adjStateSchematic = this.schematicWorldView.getBlockState((BlockPos)posMutable);
                                BlockState adjStateClient = this.clientWorldView.getBlockState((BlockPos)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    if (stateSchematic.canOcclude()) {
                        useDefault = true;
                    } else {
                        this.getProfiler().popPush("render_model_batched");
                        List<BlockModelPart> modelParts3 = this.worldRenderer.getModelParts((BlockPos)relPos, stateSchematic, rand);
                        if (!RenderUtils.hasQuads(modelParts3)) {
                            useDefault = true;
                        } else {
                            RenderUtils.drawDebugBlockModelOutlinesBatched(modelParts3, stateSchematic, (BlockPos)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                        }
                    }
                } else {
                    this.getProfiler().popPush("render_reduced_edges");
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else {
                this.getProfiler().popPush("render_fallback");
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    this.getProfiler().popPush("render_model_batched");
                    modelParts = this.worldRenderer.getModelParts((BlockPos)relPos, stateSchematic, rand);
                    if (!RenderUtils.hasQuads(modelParts)) {
                        useDefault = true;
                    } else {
                        RenderUtils.drawDebugBlockModelOutlinesBatched(modelParts, stateSchematic, (BlockPos)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    useDefault = true;
                }
            }
            if (useDefault) {
                try {
                    this.getProfiler().popPush("render_batched_box");
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedDebugLines((BlockPos)relPos, overlayColor, 0.0, bufferOverlayOutlines);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getProfiler().pop();
        }
        this.getProfiler().pop();
    }

    protected BlockPos.MutableBlockPos getChunkRelativePosition(BlockPos pos) {
        return this.chunkRelativePos.set(pos.getX() & 0xF, pos.getY() - this.position.getY(), pos.getZ() & 0xF);
    }

    protected void renderOverlayReducedEdges(BlockPos pos, OverlayType[][][] adjTypes, OverlayType typeSelf, BufferBuilder bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        Vec3i[] neighborPositions = new Vec3i[4];
        int lines = 0;
        this.getProfiler().push("overlay_reduced_edges");
        for (Direction.Axis axis : fi.dy.masa.litematica.util.PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                Vec3i[] offsets = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                if (offsets == null) continue;
                for (int i = 0; i < 4; ++i) {
                    Vec3i offset = offsets[i];
                    OverlayType type = adjTypes[offset.getX() + 1][offset.getY() + 1][offset.getZ() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new Vec3i(pos.getX() + offset.getX(), pos.getY() + offset.getY(), pos.getZ() + offset.getZ());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                this.getProfiler().popPush("edges_plop");
                if (index <= 0 || !hasCurrent) continue;
                Vec3i posTmp = new Vec3i(pos.getX(), pos.getY(), pos.getZ());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    Vec3i tmp = neighborPositions[i];
                    if (tmp.getX() > posTmp.getX() || tmp.getY() > posTmp.getY() || tmp.getZ() > posTmp.getZ()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.getX() != pos.getX() || posTmp.getY() != pos.getY() || posTmp.getZ() != pos.getZ()) continue;
                try {
                    this.getProfiler().popPush("render_batched");
                    RenderUtils.drawBlockBoxEdgeBatchedDebugLines((BlockPos)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                }
                catch (IllegalStateException ignored) {
                    this.getProfiler().pop();
                    return;
                }
                ++lines;
            }
        }
        this.getProfiler().pop();
    }

    protected OverlayType getOverlayType(BlockState stateSchematic, BlockState stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.isAir();
        boolean schematicHasAir = stateSchematic.isAir();
        if (schematicHasAir) {
            if (clientHasAir) {
                return OverlayType.NONE;
            }
            if (this.ignoreClientWorldFluids && stateClient.liquid()) {
                return OverlayType.NONE;
            }
            if (this.ignoreBlockRegistry.hasBlock(stateClient.getBlock())) {
                return OverlayType.NONE;
            }
            return OverlayType.EXTRA;
        }
        if (clientHasAir || this.ignoreClientWorldFluids && stateClient.liquid()) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.getBlock() != stateClient.getBlock()) {
            if (Configs.Generic.ENABLE_DIFFERENT_BLOCKS.getBooleanValue() && BlockUtils.isInSameGroup((BlockState)stateSchematic, (BlockState)stateClient)) {
                if (BlockUtils.matchPropertiesOnly((BlockState)stateSchematic, (BlockState)stateClient)) {
                    return OverlayType.DIFF_BLOCK;
                }
                return OverlayType.WRONG_STATE;
            }
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected static Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
            case DIFF_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_DIFF_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_DIFF_BLOCK.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private <T extends BlockEntity> void addBlockEntity(BlockPos pos, ChunkRenderDataSchematic chunkRenderData) {
        BlockEntityRenderer tesr;
        BlockEntity te = this.schematicWorldView.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        if (te != null && (tesr = this.worldRenderer.getBlockEntityRenderer().getRenderer(te)) != null) {
            chunkRenderData.addBlockEntity(te);
            if (tesr.shouldRenderOffScreen()) {
                chunkRenderData.addNoCullBlockEntity(te);
            }
        }
    }

    private BufferBuilder preRenderBlocks(ChunkSectionLayer layer, @Nonnull BufferAllocatorCache allocators) {
        return this.builderCache.getBufferByBlockLayer(layer, allocators);
    }

    private BufferBuilder preRenderOverlay(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        return this.builderCache.getBufferByOverlay(type, allocators);
    }

    protected void uploadBuffersByLayer(ChunkSectionLayer layer, @Nonnull MeshData meshData) {
        ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByBlockLayer(layer);
        boolean useResorting = Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue();
        if (gpuBuffers != null) {
            if (gpuBuffers.vertexBuffer != null) {
                gpuBuffers.vertexBuffer.close();
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.indexBuffer = null;
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (gpuBuffers.vertexBuffer.size() < meshData.vertexBuffer().remaining()) {
                gpuBuffers.vertexBuffer.close();
                gpuBuffers.setVertexBuffer(RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 40, meshData.vertexBuffer()));
            } else if (!gpuBuffers.vertexBuffer.isClosed()) {
                encoder.writeToBuffer(gpuBuffers.vertexBuffer.slice(), meshData.vertexBuffer());
            }
            if (meshData.indexBuffer() != null && useResorting) {
                if (gpuBuffers.indexBuffer != null && gpuBuffers.indexBuffer.size() >= meshData.indexBuffer().remaining()) {
                    if (!gpuBuffers.indexBuffer.isClosed()) {
                        encoder.writeToBuffer(gpuBuffers.indexBuffer.slice(), meshData.indexBuffer());
                    }
                } else {
                    if (gpuBuffers.indexBuffer != null) {
                        gpuBuffers.indexBuffer.close();
                    }
                    gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "SortedBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 72, meshData.indexBuffer()));
                }
            } else if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.setIndexBuffer(null);
            }
            gpuBuffers.setIndexCount(meshData.drawState().indexCount());
            gpuBuffers.setIndexType(meshData.drawState().indexType());
        } else {
            Supplier<String> name = () -> layer.label();
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: " + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 40, meshData.vertexBuffer());
            GpuBuffer indexBuffer = meshData.indexBuffer() != null && useResorting ? RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: " + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 72, meshData.indexBuffer()) : null;
            this.gpuBufferCache.storeBuffersByBlockLayer(layer, new ChunkRenderObjectBuffers(name, vertexBuffer, indexBuffer, meshData.drawState().indexCount(), meshData.drawState().indexType()));
        }
    }

    protected void uploadBuffersByType(OverlayRenderType type, @Nonnull MeshData meshData) {
        ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByType(type);
        if (gpuBuffers != null) {
            if (gpuBuffers.vertexBuffer != null) {
                gpuBuffers.vertexBuffer.close();
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.indexBuffer = null;
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (gpuBuffers.vertexBuffer.size() < meshData.vertexBuffer().remaining()) {
                gpuBuffers.vertexBuffer.close();
                gpuBuffers.setVertexBuffer(RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: Overlay/" + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 40, meshData.vertexBuffer()));
            } else if (!gpuBuffers.vertexBuffer.isClosed()) {
                encoder.writeToBuffer(gpuBuffers.vertexBuffer.slice(), meshData.vertexBuffer());
            }
            if (gpuBuffers.indexBuffer != null) {
                gpuBuffers.indexBuffer.close();
                gpuBuffers.setIndexBuffer(null);
            }
            gpuBuffers.setIndexCount(meshData.drawState().indexCount());
            gpuBuffers.setIndexType(meshData.drawState().indexType());
        } else {
            Supplier<String> name = type::name;
            GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "VertexBuffer: Overlay/" + (String)name.get() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 40, meshData.vertexBuffer());
            GpuBuffer indexBuffer = null;
            this.gpuBufferCache.storeBuffersByType(type, new ChunkRenderObjectBuffers(name, vertexBuffer, indexBuffer, meshData.drawState().indexCount(), meshData.drawState().indexType()));
        }
    }

    protected void uploadIndexByBlockLayer(ChunkSectionLayer layer, @Nonnull ByteBufferBuilder.Result buffer) {
        if (this.gpuBufferCache.hasBuffersByBlockLayer(layer)) {
            ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByBlockLayer(layer);
            assert (gpuBuffers != null);
            if (gpuBuffers.indexBuffer == null) {
                gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: " + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 72, buffer.byteBuffer()));
            } else if (!gpuBuffers.indexBuffer.isClosed()) {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(gpuBuffers.indexBuffer.slice(), buffer.byteBuffer());
            }
        }
    }

    protected void uploadIndexByType(OverlayRenderType type, @Nonnull ByteBufferBuilder.Result buffer) {
        if (this.gpuBufferCache.hasBuffersByType(type)) {
            ChunkRenderObjectBuffers gpuBuffers = this.gpuBufferCache.getBuffersByType(type);
            assert (gpuBuffers != null);
            if (gpuBuffers.indexBuffer == null) {
                gpuBuffers.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "IndexBuffer: Overlay/" + gpuBuffers.getName() + " VBO Section: [" + this.chunkRelativePos.toShortString() + "]", 72, buffer.byteBuffer()));
            } else if (!gpuBuffers.indexBuffer.isClosed()) {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(gpuBuffers.indexBuffer.slice(), buffer.byteBuffer());
            }
        }
    }

    private void postRenderBlocks(ChunkSectionLayer layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            MeshData meshData;
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) {
                Objects.requireNonNull(chunkRenderData.getBuiltBufferCache().getBuiltBufferByBlockLayer(layer)).close();
            }
            if (this.builderCache.hasBufferByBlockLayer(layer)) {
                BufferBuilder builder = this.builderCache.getBufferByBlockLayer(layer, allocators);
                meshData = builder.build();
                if (meshData == null) {
                    chunkRenderData.setBlockLayerUnused(layer);
                    return;
                }
            } else {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            chunkRenderData.getBuiltBufferCache().storeBuiltBufferByBlockLayer(layer, meshData);
            if (layer == ChunkSectionLayer.TRANSLUCENT && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
                try {
                    this.resortRenderBlocks(layer, x, y, z, chunkRenderData, allocators);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws RuntimeException {
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            if (chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                Objects.requireNonNull(chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type)).close();
            }
            if (this.builderCache.hasBufferByOverlay(type)) {
                BufferBuilder builder = this.builderCache.getBufferByOverlay(type, allocators);
                MeshData meshData = builder.build();
                if (meshData == null) {
                    chunkRenderData.setOverlayTypeUnused(type);
                    return;
                }
                chunkRenderData.getBuiltBufferCache().storeBuiltBufferByType(type, meshData);
            } else {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
        }
    }

    protected VertexSorting createVertexSorter(float x, float y, float z) {
        return VertexSorting.byDistance((float)x, (float)y, (float)z);
    }

    protected VertexSorting createVertexSorter(Vec3 pos) {
        return VertexSorting.byDistance((float)((float)pos.x()), (float)((float)pos.y()), (float)((float)pos.z()));
    }

    protected VertexSorting createVertexSorter(Vec3 pos, BlockPos origin) {
        return VertexSorting.byDistance((float)((float)(pos.x - (double)origin.getX())), (float)((float)(pos.y - (double)origin.getY())), (float)((float)(pos.z - (double)origin.getZ())));
    }

    protected VertexSorting createVertexSorter(Camera camera) {
        Vec3 vec3d = camera.getPosition();
        return this.createVertexSorter(vec3d, this.getOrigin());
    }

    private void resortRenderBlocks(ChunkSectionLayer layer, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws InterruptedException {
        if (!chunkRenderData.isBlockLayerEmpty(layer)) {
            ByteBufferBuilder allocator = allocators.getBufferByBlockLayer(layer);
            if (allocator == null) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            MeshData built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByBlockLayer(layer);
            if (built == null) {
                chunkRenderData.setBlockLayerUnused(layer);
                return;
            }
            if (layer == ChunkSectionLayer.TRANSLUCENT && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
                MeshData.SortState sortingData;
                VertexSorting sorter = VertexSorting.byDistance((float)x, (float)y, (float)z);
                if (!chunkRenderData.hasTransparentSortingDataForBlockLayer(layer)) {
                    sortingData = built.sortQuads(allocator, sorter);
                    if (sortingData == null) {
                        throw new InterruptedException("Sort State failure");
                    }
                    chunkRenderData.setTransparentSortingDataForBlockLayer(layer, sortingData);
                } else {
                    sortingData = chunkRenderData.getTransparentSortingDataForBlockLayer(layer);
                }
                if (sortingData == null) {
                    throw new InterruptedException("Sorting Data failure");
                }
            }
        }
    }

    private void resortRenderOverlay(OverlayRenderType type, float x, float y, float z, @Nonnull ChunkRenderDataSchematic chunkRenderData, @Nonnull BufferAllocatorCache allocators) throws InterruptedException {
        if (!chunkRenderData.isOverlayTypeEmpty(type)) {
            ByteBufferBuilder allocator = allocators.getBufferByOverlay(type);
            if (allocator == null) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
            if (!chunkRenderData.getBuiltBufferCache().hasBuiltBufferByType(type)) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
            MeshData built = chunkRenderData.getBuiltBufferCache().getBuiltBufferByType(type);
            if (built == null) {
                chunkRenderData.setOverlayTypeUnused(type);
                return;
            }
        }
    }

    protected ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<Vec3> cameraPosSupplier) {
        ChunkRenderTaskSchematic generator;
        this.chunkRenderLock.lock();
        try {
            this.finishCompileTask();
            this.rebuildWorldView();
            generator = this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return generator;
    }

    @Nullable
    protected ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<Vec3> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
                this.compileTask.setChunkRenderData(this.chunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return null;
    }

    protected void finishCompileTask() {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
    }

    protected ReentrantLock getLockCompileTask() {
        return this.chunkRenderLock;
    }

    protected void clear() {
        try {
            this.finishCompileTask();
        }
        finally {
            if (this.chunkRenderData != null && !this.chunkRenderData.equals(ChunkRenderDataSchematic.EMPTY)) {
                this.chunkRenderData.clearAll();
            }
            this.builderCache.clearAll();
            this.gpuBufferCache.clearAll();
            this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
            this.existingOverlays.clear();
            this.hasOverlay = false;
        }
    }

    protected void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    protected void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.ignoreClientWorldFluids = Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue();
            this.ignoreBlockRegistry = new IgnoreBlockRegistry();
            ClientLevel worldClient = Minecraft.getInstance().level;
            assert (worldClient != null);
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (BlockPos)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic((Level)worldClient, worldClient, (BlockPos)this.position, 2);
            this.boxes.clear();
            int chunkX = this.position.getX() / 16;
            int chunkZ = this.position.getZ() / 16;
            for (SchematicPlacementManager.PlacementPart part : DataManager.getSchematicPlacementManager().getPlacementPartsInChunk(chunkX, chunkZ)) {
                this.boxes.add(part.bb);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.deleteGlResources();
    }
}

