/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.entity.IMixinEntity;
import fi.dy.masa.litematica.mixin.render.IMixinGameRenderer;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderBatchDraw;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderObjectBuffers;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.litematica.util.IEntityInvoker;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class WorldRendererSchematic {
    private final Minecraft mc;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final BlockRenderDispatcher blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<BlockEntity> blockEntities = new HashSet<BlockEntity>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private FogRenderer fogRenderer;
    private ChunkRenderBatchDraw batchDraw;
    private GpuBufferSlice vanillaFogBuffer;
    private ProfilerFiller profiler;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;
    private boolean shouldDraw;

    public WorldRendererSchematic(Minecraft mc) {
        this.mc = mc;
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = Minecraft.getInstance().getBlockRenderer();
        this.entityRenderDispatcher = mc.getEntityRenderDispatcher();
        this.blockEntityRenderDispatcher = mc.getBlockEntityRenderDispatcher();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.getBlockColors());
        this.blockModelRenderer.setBakedManager(mc.getModelManager());
        this.fogRenderer = ((IMixinGameRenderer)mc.gameRenderer).litematica_getFogRenderer();
        this.profiler = null;
        this.vanillaFogBuffer = null;
        this.batchDraw = null;
        this.shouldDraw = false;
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.getRendererCount() : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.smartCull ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected ChunkRenderDispatcherLitematica getRenderDispatcher() {
        return this.renderDispatcher;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isBlockLayerEmpty()) continue;
            ++count;
        }
        return count;
    }

    protected ProfilerFiller getProfiler() {
        if (this.profiler == null) {
            this.profiler = Profiler.get();
            this.profiler.startTick();
        }
        return this.profiler;
    }

    protected EntityRenderDispatcher getEntityRenderer() {
        return this.entityRenderDispatcher;
    }

    protected BlockEntityRenderDispatcher getBlockEntityRenderer() {
        return this.blockEntityRenderDispatcher;
    }

    protected GpuBufferSlice getEmptyFogBuffer() {
        if (this.fogRenderer == null) {
            this.fogRenderer = ((IMixinGameRenderer)this.mc.gameRenderer).litematica_getFogRenderer();
        }
        return this.fogRenderer.getBuffer(FogRenderer.FogMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers(this.profiler);
        } else {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.chunksToUpdate.clear();
            this.renderInfos.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.profiler = null;
            this.clearBlockBatchDraw();
            if (this.vanillaFogBuffer != null) {
                this.vanillaFogBuffer = null;
            }
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers(@Nullable ProfilerFiller profiler) {
        if (this.hasWorld()) {
            if (profiler == null) {
                profiler = Profiler.get();
            }
            this.profiler = profiler;
            profiler.push("load_renderers");
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica(profiler);
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = (Integer)this.mc.options.renderDistance().get() + 2;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates(profiler);
            this.clearBlockBatchDraw();
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            this.renderEntitiesStartupCounter = 2;
            profiler.pop();
        }
    }

    protected void stopChunkUpdates(ProfilerFiller profiler) {
        if (!this.chunksToUpdate.isEmpty()) {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
        }
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates(profiler);
        this.profiler = null;
        this.clearBlockBatchDraw();
        this.vanillaFogBuffer = null;
    }

    public void setupTerrain(Camera camera, Frustum frustum, int frameCount, boolean playerSpectator, ProfilerFiller profiler) {
        this.profiler = profiler;
        profiler.push("setup_terrain");
        if (this.chunkRendererDispatcher == null || (Integer)this.mc.options.renderDistance().get() + 2 != this.renderDistanceChunks) {
            this.loadRenderers(profiler);
        }
        Entity entity = EntityUtils.getCameraEntity();
        if (this.mc.player == null) {
            return;
        }
        if (entity == null) {
            entity = this.mc.player;
        }
        profiler.popPush("camera");
        double entityX = entity.getX();
        double entityY = entity.getY();
        double entityZ = entity.getZ();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 256.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.chunkRendererDispatcher.removeOutOfRangeRenderers();
        }
        profiler.popPush("renderlist_camera");
        Vec3 cameraPos = camera.getPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        this.renderDispatcher.setCameraPosition(cameraPos);
        profiler.popPush("culling");
        BlockPos viewPos = BlockPos.containing((double)cameraX, (double)(cameraY + (double)entity.getEyeHeight()), (double)cameraZ);
        int centerChunkX = viewPos.getX() >> 4;
        int centerChunkZ = viewPos.getZ() >> 4;
        int renderDistance = (Integer)this.mc.options.renderDistance().get() + 2;
        ChunkPos viewChunk = new ChunkPos(viewPos);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.getXRot() != this.lastCameraPitch || entity.getYRot() != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.getXRot();
        this.lastCameraYaw = camera.getYRot();
        profiler.popPush("update");
        if (this.displayListEntitiesDirty) {
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            profiler.push("update_sort");
            List<ChunkPos> positions = DataManager.getSchematicPlacementManager().getAndUpdateVisibleChunks(viewChunk);
            profiler.popPush("update_iteration");
            for (ChunkPos chunkPos : positions) {
                ChunkRendererSchematicVbo chunkRenderer;
                int cx = chunkPos.x;
                int cz = chunkPos.z;
                if (Math.abs(cx - centerChunkX) > renderDistance || Math.abs(cz - centerChunkZ) > renderDistance || !this.world.getChunkProvider().hasChunk(cx, cz) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(cx, cz)) == null || !frustum.isVisible(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && chunkPos.equals((Object)viewChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            profiler.pop();
        }
        profiler.popPush("rebuild_near");
        Set<ChunkRendererSchematicVbo> set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos pos = chunkRendererTmp.getOrigin().offset(8, 8, 8);
            boolean bl = isNear = pos.distSqr((Vec3i)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            profiler.push("update_now");
            this.profiler = profiler;
            this.renderDispatcher.updateChunkNow(chunkRendererTmp, profiler);
            chunkRendererTmp.clearNeedsUpdate();
            profiler.pop();
        }
        this.chunksToUpdate.addAll(set);
        this.clearBlockBatchDraw();
        profiler.pop();
    }

    public void updateChunks(long finishTimeNano, ProfilerFiller profiler) {
        this.profiler = profiler;
        profiler.push("run_chunk_uploads");
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano, profiler);
        if (this.profiler == null) {
            this.profiler = profiler;
        }
        profiler.popPush("check_update");
        if (!this.chunksToUpdate.isEmpty()) {
            ChunkRendererSchematicVbo renderChunk;
            boolean flag;
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            int index = 0;
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).needsImmediateUpdate() ? this.renderDispatcher.updateChunkNow(renderChunk, profiler) : this.renderDispatcher.updateChunkLater(renderChunk, profiler))) {
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i < 0L) break;
                ++index;
            }
        }
        profiler.pop();
    }

    public void capturePreMainValues(GpuBufferSlice fogBuffer, ProfilerFiller profiler) {
        this.vanillaFogBuffer = fogBuffer;
        this.profiler = profiler;
    }

    public int prepareBlockLayers(Matrix4fc matrix4fc, double cameraX, double cameraY, double cameraZ, ProfilerFiller profiler) {
        this.profiler = profiler;
        RenderSystem.assertOnRenderThread();
        profiler.push("layer_multi_phase");
        ArrayList<DynamicUniforms.Transform> uniformValues = new ArrayList<DynamicUniforms.Transform>();
        EnumMap<ChunkSectionLayer, List<RenderPass.Draw<GpuBufferSlice[]>>> renderMap = new EnumMap<ChunkSectionLayer, List<RenderPass.Draw<GpuBufferSlice[]>>>(ChunkSectionLayer.class);
        for (ChunkSectionLayer layer : ChunkSectionLayer.values()) {
            renderMap.put(layer, new ArrayList());
        }
        profiler.popPush("layer_setup");
        int startIndex = 0;
        int stopIndex = this.renderInfos.size();
        int increment = 1;
        int indexCount = 0;
        int count = 0;
        boolean renderAsTranslucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        boolean renderCollidingBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
        Matrix4f matrix4f = new Matrix4f();
        Vector4f colorVector = renderAsTranslucent ? new Vector4f(1.0f, 1.0f, 1.0f, (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue()) : new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        boolean startedDrawing = false;
        profiler.popPush("layer_iteration");
        this.profiler = profiler;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            for (ChunkSectionLayer layer : ChunkSectionLayer.values()) {
                VertexFormat.IndexType indexType;
                GpuBuffer vertexBuffer;
                profiler.popPush("layer_" + layer.label());
                if (renderer.getChunkRenderData().isBlockLayerEmpty(layer)) continue;
                BlockPos chunkOrigin = renderer.getOrigin();
                ChunkRenderObjectBuffers buffers = renderer.getBlockBuffersByBlockLayer(layer);
                if (buffers == null || buffers.isClosed() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByBlockLayer(layer)) continue;
                if (buffers.getIndexBuffer() == null) {
                    if (buffers.getIndexCount() > indexCount) {
                        indexCount = buffers.getIndexCount();
                    }
                    vertexBuffer = null;
                    indexType = null;
                } else {
                    vertexBuffer = buffers.getIndexBuffer();
                    indexType = buffers.getIndexType();
                }
                int pos = uniformValues.size();
                uniformValues.add(new DynamicUniforms.Transform(matrix4fc, (Vector4fc)colorVector, (Vector3fc)new Vector3f((float)((double)chunkOrigin.getX() - cameraX), (float)((double)chunkOrigin.getY() - cameraY), (float)((double)chunkOrigin.getZ() - cameraZ)), (Matrix4fc)matrix4f, 1.0f));
                renderMap.get(layer).add((RenderPass.Draw<GpuBufferSlice[]>)new RenderPass.Draw(0, buffers.getVertexBuffer(), vertexBuffer, indexType, 0, buffers.getIndexCount(), (slices, uploader) -> uploader.upload("DynamicTransforms", slices[pos])));
                startedDrawing = true;
                ++count;
            }
        }
        if (startedDrawing) {
            GpuBufferSlice[] bufferSlices = RenderSystem.getDynamicUniforms().writeTransforms(uniformValues.toArray(new DynamicUniforms.Transform[0]));
            this.batchDraw = new ChunkRenderBatchDraw(renderMap, renderCollidingBlocks, renderAsTranslucent, indexCount, bufferSlices);
            this.shouldDraw = true;
        }
        profiler.pop();
        return count;
    }

    public void drawBlockLayerGroup(ChunkSectionLayerGroup group) {
        if (this.batchDraw != null && this.shouldDraw) {
            this.profiler.push("litematica_batch_draw_" + group.label());
            RenderSystem.setShaderFog((GpuBufferSlice)this.getEmptyFogBuffer());
            this.batchDraw.draw(group, this.profiler);
            RenderSystem.setShaderFog((GpuBufferSlice)this.vanillaFogBuffer);
            this.profiler.pop();
        }
    }

    public void clearBlockBatchDraw() {
        if (this.batchDraw != null) {
            this.batchDraw = null;
        }
        this.shouldDraw = false;
    }

    public void scheduleTranslucentSorting(Vec3 cameraPos, ProfilerFiller profiler) {
        double x = cameraPos.x();
        double y = cameraPos.y();
        double z = cameraPos.z();
        this.profiler = profiler;
        double diffX = x - this.lastTranslucentSortX;
        double diffY = y - this.lastTranslucentSortY;
        double diffZ = z - this.lastTranslucentSortZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
            this.lastTranslucentSortX = x;
            this.lastTranslucentSortY = y;
            this.lastTranslucentSortZ = z;
            int h = 0;
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(ChunkSectionLayer.TRANSLUCENT) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || h++ >= 15) continue;
                this.renderDispatcher.updateTransparencyLater(chunkRenderer, profiler);
            }
        }
    }

    public void renderBlockOverlays(Camera camera, float lineWidth, ProfilerFiller profiler) {
        this.profiler = profiler;
        this.renderBlockOverlay(OverlayRenderType.OUTLINE, camera, lineWidth, profiler);
        this.renderBlockOverlay(OverlayRenderType.QUAD, camera, lineWidth, profiler);
    }

    protected void renderBlockOverlay(OverlayRenderType type, Camera camera, float lineWidth, ProfilerFiller profiler) {
        profiler.push("overlay_" + type.name());
        this.profiler = profiler;
        Vec3 cameraPos = camera.getPosition();
        double x = cameraPos.x;
        double y = cameraPos.y;
        double z = cameraPos.z;
        boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
        RenderPipeline pipeline = renderThrough ? type.getRenderThrough() : type.getPipeline();
        float[] offset = new float[]{0.3f, 0.0f, 0.6f};
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        profiler.popPush("overlay_iterate");
        this.profiler = profiler;
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            ChunkRenderObjectBuffers buffers = renderer.getOverlayBuffersByType(type);
            BlockPos chunkOrigin = renderer.getOrigin();
            if (buffers == null || buffers.isClosed() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByType(type)) continue;
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)((double)chunkOrigin.getX() - x), (float)((double)chunkOrigin.getY() - y), (float)((double)chunkOrigin.getZ() - z));
            this.drawInternal(pipeline, buffers, -1, offset, lineWidth, false, false, type == OverlayRenderType.OUTLINE);
            matrix4fStack.popMatrix();
        }
        profiler.pop();
    }

    public boolean renderBlock(BlockAndTintGetter world, BlockState state, BlockPos pos, PoseStack matrixStack, BufferBuilder bufferBuilderIn) {
        this.getProfiler().push("render_block");
        try {
            RenderShape renderType = state.getRenderShape();
            if (renderType == RenderShape.INVISIBLE) {
                this.getProfiler().pop();
                return false;
            }
            long seed = state.getSeed(pos);
            List<BlockModelPart> parts = this.getModelParts(pos, state, RandomSource.create((long)seed));
            BlockModelRendererSchematic.enableCache();
            boolean result = renderType == RenderShape.MODEL && this.blockModelRenderer.renderModel(world, parts, state, pos, matrixStack, (VertexConsumer)bufferBuilderIn, seed);
            BlockModelRendererSchematic.disableCache();
            this.getProfiler().pop();
            return result;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)world, (BlockPos)pos, (BlockState)state);
            this.getProfiler().pop();
            throw new ReportedException(crashreport);
        }
    }

    public void renderFluid(BlockAndTintGetter world, BlockState blockState, FluidState fluidState, BlockPos pos, BufferBuilder bufferBuilderIn) {
        this.getProfiler().push("render_fluid");
        try {
            this.blockRenderManager.renderLiquid(pos, world, (VertexConsumer)bufferBuilderIn, blockState, fluidState);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getProfiler().pop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawInternal(RenderPipeline pipeline, ChunkRenderObjectBuffers buffers, int color, float[] offset, float lineWidth, boolean useColor, boolean useOffset, boolean setLineWidth) throws RuntimeException {
        if (RenderSystem.isOnRenderThread()) {
            VertexFormat.IndexType indexType;
            GpuBuffer indexBuffer;
            Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            Vector3f modelOffset = new Vector3f();
            Matrix4f texMatrix = new Matrix4f();
            float line = 0.0f;
            if (useOffset) {
                RenderSystem.setModelOffset((float)offset[0], (float)offset[1], (float)offset[2]);
                modelOffset.set(offset);
            }
            if (useColor) {
                float[] rgba = new float[]{ARGB.redFloat((int)color), ARGB.greenFloat((int)color), ARGB.blueFloat((int)color), ARGB.alphaFloat((int)color)};
                colorMod.set(rgba);
            }
            if (setLineWidth) {
                line = lineWidth;
            }
            RenderTarget mainFb = RenderUtils.fb();
            GpuTextureView texture1 = mainFb.getColorTextureView();
            GpuTextureView texture2 = mainFb.useDepth ? mainFb.getDepthTextureView() : null;
            RenderSystem.AutoStorageIndexBuffer shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)pipeline.getVertexFormatMode());
            if (buffers.getIndexBuffer() == null) {
                if (buffers.getIndexCount() <= 0) {
                    Litematica.LOGGER.error("WorldRendererSchematic#drawInternal() [{}] --> setup IndexBuffer --> NO INDEX COUNT!", (Object)buffers.getName());
                    return;
                }
                indexBuffer = shapeIndexBuffer.getBuffer(buffers.getIndexCount());
                indexType = shapeIndexBuffer.type();
            } else {
                indexBuffer = buffers.getIndexBuffer();
                indexType = buffers.getIndexType();
            }
            GpuBufferSlice gpuSlice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix, line);
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "litematica:drawInternal/schematic_overlay", texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(pipeline);
                RenderSystem.bindDefaultUniforms((RenderPass)pass);
                pass.setUniform("DynamicTransforms", gpuSlice);
                pass.setVertexBuffer(0, buffers.getVertexBuffer());
                pass.setIndexBuffer(indexBuffer, indexType);
                pass.drawIndexed(0, 0, buffers.getIndexCount(), 1);
            }
            if (useOffset) {
                RenderSystem.resetModelOffset();
            }
        }
    }

    public boolean hasQuadsForModel(List<BlockModelPart> modelParts, BlockState state, @Nullable Direction side) {
        BlockModelPart part = modelParts.getFirst();
        if (side != null) {
            List list = part.getQuads(side);
            return !list.isEmpty();
        }
        for (Direction entry : Direction.values()) {
            List list = part.getQuads(side);
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQuadsForModelPart(BlockModelPart modelPart, BlockState state, @Nullable Direction side) {
        if (side != null) {
            List list = modelPart.getQuads(side);
            return !list.isEmpty();
        }
        for (Direction entry : Direction.values()) {
            List list = modelPart.getQuads(side);
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BlockStateModel getModelForState(BlockState state) {
        return this.blockRenderManager.getBlockModelShaper().getBlockModel(state);
    }

    public List<BlockModelPart> getModelParts(BlockPos pos, BlockState state, RandomSource rand) {
        rand.setSeed(state.getSeed(pos));
        List parts = this.getModelForState(state).collectParts(rand);
        if (parts.isEmpty()) {
            parts = this.getModelForState(state.getBlock().defaultBlockState()).collectParts(rand);
            Litematica.LOGGER.warn("getModelParts: Invalid Block State for block at [{}] with state [{}]; Resetting to default.", (Object)pos.toShortString(), (Object)state.toString());
        }
        return parts;
    }

    public void renderEntities(Camera camera, Frustum frustum, PoseStack matrices, MultiBufferSource.BufferSource immediate, float partialTicks, ProfilerFiller profiler) {
        this.profiler = profiler;
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            profiler.push("entities_prepare");
            double cameraX = camera.getPosition().x;
            double cameraY = camera.getPosition().y;
            double cameraZ = camera.getPosition().z;
            this.entityRenderDispatcher.prepare((Level)this.world, camera, this.mc.crosshairPickEntity);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            profiler.popPush("regular");
            LayerRange layerRange = DataManager.getRenderLayerRange();
            profiler.popPush("regular_iterate");
            this.profiler = profiler;
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                BlockPos pos = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
                List<Entity> list = chunk.getEntityList();
                for (Entity entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.getX(), (int)entityTmp.getY(), (int)entityTmp.getZ()) || !(shouldRender = this.entityRenderDispatcher.shouldRender(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double lerpX = Mth.lerp((double)partialTicks, (double)entityTmp.xOld, (double)entityTmp.getX());
                    double lerpY = Mth.lerp((double)partialTicks, (double)entityTmp.yOld, (double)entityTmp.getY());
                    double lerpZ = Mth.lerp((double)partialTicks, (double)entityTmp.zOld, (double)entityTmp.getZ());
                    double x = lerpX - cameraX;
                    double y = lerpY - cameraY;
                    double z = lerpZ - cameraZ;
                    matrices.pushPose();
                    if (entityTmp instanceof Salmon || entityTmp instanceof Cod || entityTmp instanceof Tadpole || entityTmp instanceof AbstractHorse || entityTmp instanceof TropicalFish || entityTmp instanceof AgeableWaterCreature) {
                        Fluid fluid;
                        BlockState state = this.world.getBlockState(entityTmp.blockPosition());
                        Fluid fluid2 = fluid = state.getFluidState() != null ? state.getFluidState().getType() : Fluids.EMPTY;
                        if (!(fluid != Fluids.WATER && fluid != Fluids.FLOWING_WATER || ((IMixinEntity)entityTmp).litematica_isTouchingWater())) {
                            ((IEntityInvoker)entityTmp).litematica$toggleTouchingWater(true);
                        }
                    }
                    this.entityRenderDispatcher.render(entityTmp, x, y, z, partialTicks, matrices, (MultiBufferSource)immediate, this.entityRenderDispatcher.getPackedLightCoords(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                    matrices.popPose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderBlockEntities(Camera camera, Frustum frustum, PoseStack matrices, MultiBufferSource.BufferSource immediate, MultiBufferSource.BufferSource immediate2, float partialTicks, ProfilerFiller profiler) {
        this.profiler = profiler;
        profiler.push("block_entities_prepare");
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        this.blockEntityRenderDispatcher.prepare((Level)this.world, camera, this.mc.hitResult);
        LayerRange layerRange = DataManager.getRenderLayerRange();
        profiler.popPush("block_entities");
        this.profiler = profiler;
        profiler.popPush("render_be");
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
            List<BlockEntity> tiles = data.getBlockEntities();
            if (tiles.isEmpty()) continue;
            BlockPos chunkOrigin = chunkRenderer.getOrigin();
            ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.getX() >> 4, chunkOrigin.getZ() >> 4);
            if (chunk == null || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
            for (BlockEntity te : tiles) {
                BlockPos pos = te.getBlockPos();
                if (!layerRange.isPositionWithinRange(pos.getX(), pos.getY(), pos.getZ())) continue;
                try {
                    matrices.pushPose();
                    matrices.translate((double)pos.getX() - cameraX, (double)pos.getY() - cameraY, (double)pos.getZ() - cameraZ);
                    this.blockEntityRenderDispatcher.render(te, partialTicks, matrices, (MultiBufferSource)immediate2);
                    matrices.popPose();
                }
                catch (Exception err) {
                    Litematica.LOGGER.error("[Pass 1] Error rendering blockEntities; Exception: {}", (Object)err.getLocalizedMessage());
                }
            }
        }
        immediate2.endLastBatch();
        profiler.popPush("render_be_no_cull");
        Set<BlockEntity> set = this.blockEntities;
        synchronized (set) {
            for (BlockEntity te : this.blockEntities) {
                BlockPos pos = te.getBlockPos();
                if (!layerRange.isPositionWithinRange(pos.getX(), pos.getY(), pos.getZ())) continue;
                try {
                    matrices.pushPose();
                    matrices.translate((double)pos.getX() - cameraX, (double)pos.getY() - cameraY, (double)pos.getZ() - cameraZ);
                    this.blockEntityRenderDispatcher.render(te, partialTicks, matrices, (MultiBufferSource)immediate);
                    matrices.popPose();
                }
                catch (Exception err) {
                    Litematica.LOGGER.error("[Pass 2] Error rendering blockEntities; Exception: {}", (Object)err.getLocalizedMessage());
                }
            }
        }
        immediate.endLastBatch();
        profiler.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<BlockEntity> toRemove, Collection<BlockEntity> toAdd) {
        Set<BlockEntity> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        this.getProfiler().push("schedule_render");
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkZ);
        }
        this.getProfiler().pop();
    }
}

