/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.mixin.IMixinProfilerSystem;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class MixinWorldRenderer {
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private Matrix4f posMatrix = null;
    @Unique
    private DeltaTracker ticks = null;
    @Unique
    private ProfilerFiller profiler;

    @Inject(method={"allChanged()V"}, at={@At(value="RETURN")})
    private void litematica_onLoadRenderers(CallbackInfo ci) {
        if (this.level != null && this.level == this.minecraft.level) {
            ActiveProfiler ps;
            ProfilerFiller profilerFiller;
            if (this.profiler == null) {
                this.profiler = Profiler.get();
            }
            if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
                this.profiler.startTick();
            }
            LitematicaRenderer.getInstance().loadRenderers(this.profiler);
            SchematicWorldRefresher.INSTANCE.updateAll();
        }
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="TAIL")})
    private void litematica_onPostSetupTerrain(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        LitematicaRenderer.getInstance().piecewisePrepareAndUpdate(frustum, this.profiler);
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/resource/GraphicsResourceAllocator;Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addMainPass(Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/client/renderer/FogParameters;ZZLnet/minecraft/client/DeltaTracker;Lnet/minecraft/util/profiling/ProfilerFiller;)V", shift=At.Shift.BEFORE)})
    private void litematica_onPreRenderMain(GraphicsResourceAllocator objectAllocator, DeltaTracker tickCounter, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f positionMatrix, Matrix4f projectionMatrix, CallbackInfo ci, @Local ProfilerFiller profiler) {
        this.posMatrix = positionMatrix;
        this.ticks = tickCounter;
        this.profiler = profiler;
    }

    @Inject(method={"renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="TAIL")})
    private void litematica_onRenderLayer(RenderType renderLayer, double x, double y, double z, Matrix4f viewMatrix, Matrix4f posMatrix, CallbackInfo ci) {
        ActiveProfiler ps;
        ProfilerFiller profilerFiller;
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
            this.profiler.startTick();
        }
        if (renderLayer == RenderType.solid()) {
            LitematicaRenderer.getInstance().piecewiseRenderSolid(viewMatrix, posMatrix, this.profiler);
        } else if (renderLayer == RenderType.cutoutMipped()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutoutMipped(viewMatrix, posMatrix, this.profiler);
        } else if (renderLayer == RenderType.cutout()) {
            LitematicaRenderer.getInstance().piecewiseRenderCutout(viewMatrix, posMatrix, this.profiler);
        } else if (renderLayer == RenderType.translucent()) {
            LitematicaRenderer.getInstance().piecewiseRenderTranslucent(viewMatrix, posMatrix, this.profiler);
            LitematicaRenderer.getInstance().piecewiseRenderOverlay(viewMatrix, posMatrix, this.profiler);
        }
    }

    @Inject(method={"renderEntities(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/Camera;Lnet/minecraft/client/DeltaTracker;Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void litematica_onPostRenderEntities(PoseStack matrices, MultiBufferSource.BufferSource immediate, Camera camera, DeltaTracker tickCounter, List<Entity> entities, CallbackInfo ci) {
        if (this.posMatrix != null && this.ticks != null) {
            ActiveProfiler ps;
            ProfilerFiller profilerFiller;
            if (this.profiler == null) {
                this.profiler = Profiler.get();
            }
            if ((profilerFiller = this.profiler) instanceof ActiveProfiler && !((IMixinProfilerSystem)(ps = (ActiveProfiler)profilerFiller)).litematica_isStarted()) {
                this.profiler.startTick();
            }
            LitematicaRenderer.getInstance().piecewiseRenderEntities(this.posMatrix, this.ticks.getGameTimeDeltaPartialTick(false), this.profiler);
            this.posMatrix = null;
            this.ticks = null;
        }
    }
}

