/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.compat.iris.IrisCompat;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Matrix4f;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private Minecraft mc;
    private WorldRendererSchematic worldRenderer;
    private Frustum frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.getInstance();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public WorldRendererSchematic resetWorldRenderer() {
        if (this.worldRenderer != null) {
            this.worldRenderer.setWorldAndLoadRenderers(null);
            this.worldRenderer = null;
        }
        return this.getWorldRenderer();
    }

    public void loadRenderers(@Nullable ProfilerFiller profiler) {
        this.getWorldRenderer().loadRenderers(profiler);
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + 1000000000L / fpsTarget / 2L;
    }

    public void renderSchematicOverlay(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            profiler.push("schematic_overlay");
            RenderSystem.disableCull();
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!IrisCompat.isShadowPassActive()) {
                this.getWorldRenderer().renderBlockOverlays(viewMatrix, this.getCamera(), posMatrix, profiler);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
            profiler.pop();
        }
    }

    public void piecewisePrepareAndUpdate(Frustum frustum, ProfilerFiller profiler) {
        boolean render = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.getCameraEntity() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (render && frustum != null && worldRenderer.hasWorld()) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            if (this.renderPiecewiseSchematic) {
                profiler.push("litematica_culling");
                this.calculateFinishTime();
                profiler.popPush("litematica_terrain_setup");
                worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.player.isSpectator(), profiler);
                profiler.popPush("litematica_update_chunks");
                worldRenderer.updateChunks(this.finishTimeNano, profiler);
                profiler.pop();
                this.frustum = frustum;
            }
        }
    }

    public void piecewiseRenderSolid(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            CompiledShaderProgram shader = RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_SOLID);
            this.getWorldRenderer().renderBlockLayer(RenderType.solid(), viewMatrix, this.getCamera(), posMatrix, profiler, shader);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            profiler.pop();
        }
    }

    public void piecewiseRenderCutoutMipped(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            CompiledShaderProgram shader = RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_CUTOUT_MIPPED);
            this.getWorldRenderer().renderBlockLayer(RenderType.cutoutMipped(), viewMatrix, this.getCamera(), posMatrix, profiler, shader);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            profiler.pop();
        }
    }

    public void piecewiseRenderCutout(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            CompiledShaderProgram shader = RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_CUTOUT);
            this.getWorldRenderer().renderBlockLayer(RenderType.cutout(), viewMatrix, this.getCamera(), posMatrix, profiler, shader);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            profiler.pop();
        }
    }

    public void piecewiseRenderTranslucent(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_translucent");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            CompiledShaderProgram shader = RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_TRANSLUCENT);
            this.getWorldRenderer().renderBlockLayer(RenderType.translucent(), viewMatrix, this.getCamera(), posMatrix, profiler, shader);
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            profiler.pop();
        }
    }

    public void piecewiseRenderOverlay(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseSchematic) {
            profiler.push("litematica_schematic_overlay");
            this.renderSchematicOverlay(viewMatrix, posMatrix, profiler);
            profiler.pop();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(Matrix4f posMatrix, float partialTicks, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_entities");
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, posMatrix, partialTicks, profiler);
            profiler.pop();
        }
    }

    private Camera getCamera() {
        return this.mc.gameRenderer.getMainCamera();
    }

    private void cleanup() {
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
    }
}

