/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    static void startDrawingLines() {
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.startDrawingLines();
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, color, expand, buffer, mc);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception e) {
            Litematica.LOGGER.error("renderBlockOutline: Failed to draw Area Selection box (Error: {})", (Object)e.getLocalizedMessage());
        }
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - expand);
        float minY = (float)((double)pos.getY() - dy - expand);
        float minZ = (float)((double)pos.getZ() - dz - expand);
        float maxX = (float)((double)pos.getX() - dx + expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + expand + 1.0);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, BlockPos relPos, Color4f color, double expand, BufferBuilder buffer) {
        Vec3 cameraPos = relPos.getCenter();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - expand);
        float minY = (float)((double)pos.getY() - dy - expand);
        float minZ = (float)((double)pos.getZ() - dz - expand);
        float maxX = (float)((double)pos.getX() - dx + expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + expand + 1.0);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawConnectingLineBatchedLines(BlockPos pos1, BlockPos pos2, boolean center, Color4f color, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float x1 = (float)((double)pos1.getX() - dx);
        float y1 = (float)((double)pos1.getY() - dy);
        float z1 = (float)((double)pos1.getZ() - dz);
        float x2 = (float)((double)pos2.getX() - dx);
        float y2 = (float)((double)pos2.getY() - dy);
        float z2 = (float)((double)pos2.getZ() - dz);
        if (center) {
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
            x2 += 0.5f;
            y2 += 0.5f;
            z2 += 0.5f;
        }
        buffer.addVertex(x1, y1, z1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x2, y2, z2).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - (double)expand);
        float minY = (float)((double)pos.getY() - dy - (double)expand);
        float minZ = (float)((double)pos.getZ() - dz - (double)expand);
        float maxX = (float)((double)pos.getX() - dx + (double)expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + (double)expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + (double)expand + 1.0);
        RenderSystem.lineWidth((float)lineWidth);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.startDrawingLines();
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception e) {
            Litematica.LOGGER.error("renderBlockOutlineOverlapping: Failed to draw Area Selection box (Error: {})", (Object)e.getLocalizedMessage());
        }
    }

    public static void renderAreaOutline(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz;
        double maxX = (double)Math.max(pos1.getX(), pos2.getX()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.getY(), pos2.getY()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.getZ(), pos2.getZ()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.startDrawingLines();
        RenderUtils.drawBoundingBoxLinesX(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawBoundingBoxLinesX(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesY(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesZ(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, Matrix4f matrix4f, Minecraft mc) {
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer, mc);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void renderAreaSidesBatched(BlockPos pos1, BlockPos pos2, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx - expand;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy - expand;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz - expand;
        double maxX = (double)(Math.max(pos1.getX(), pos2.getX()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.getY(), pos2.getY()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.getZ(), pos2.getZ()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (BufferBuilder)buffer);
    }

    public static void renderAreaOutlineNoCorners(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        int end;
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        double expand = 0.001;
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float dxMin = (float)(-dx - 0.001);
        float dyMin = (float)(-dy - 0.001);
        float dzMin = (float)(-dz - 0.001);
        float dxMax = (float)(-dx + 0.001);
        float dyMax = (float)(-dy + 0.001);
        float dzMax = (float)(-dz + 0.001);
        float minX = (float)xMin + dxMin;
        float minY = (float)yMin + dyMin;
        float minZ = (float)zMin + dzMin;
        float maxX = (float)xMax + dxMax;
        float maxY = (float)yMax + dyMax;
        float maxZ = (float)zMax + dzMax;
        RenderSystem.lineWidth((float)lineWidth);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.startDrawingLines();
        int start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawBlockModelOutlinesBatched(BakedModel model, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderModelQuadOutlines(model, state, pos, side, color, expand, buffer);
        }
        RenderUtils.renderModelQuadOutlines(model, state, pos, null, color, expand, buffer);
    }

    public static void renderModelQuadOutlines(BakedModel model, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        try {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.getQuads(state, side, (RandomSource)RAND));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderModelQuadOutlines(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).getVertices());
        }
    }

    public static void renderQuadOutlinesBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        buffer.addVertex(fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBlockModelQuadOverlayBatched(BakedModel model, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockModelQuadOverlayBatched(model, state, pos, side, color, expand, buffer);
        }
        RenderUtils.drawBlockModelQuadOverlayBatched(model, state, pos, null, color, expand, buffer);
    }

    public static void drawBlockModelQuadOverlayBatched(BakedModel model, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        try {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.getQuads(state, side, (RandomSource)RAND));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quad.getVertices());
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.addVertex(fx, fy, fz).setColor(color.r, color.g, color.b, color.a);
        }
    }

    public static void drawBlockBoxSideBatchedQuads(BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand);
        float minY = (float)((double)pos.getY() - expand);
        float minZ = (float)((double)pos.getZ() - expand);
        float maxX = (float)((double)pos.getX() + expand + 1.0);
        float maxY = (float)((double)pos.getY() + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand + 1.0);
        switch (side) {
            case DOWN: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case WEST: {
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(BlockPos pos, Direction.Axis axis, int cornerIndex, Color4f color, BufferBuilder buffer) {
        Vec3i offset = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.getX() + offset.getX();
        double minY = pos.getY() + offset.getY();
        double minZ = pos.getZ() + offset.getZ();
        double maxX = pos.getX() + offset.getX() + (axis == Direction.Axis.X ? 1 : 0);
        double maxY = pos.getY() + offset.getY() + (axis == Direction.Axis.Y ? 1 : 0);
        double maxZ = pos.getZ() + offset.getZ() + (axis == Direction.Axis.Z ? 1 : 0);
        buffer.addVertex((float)minX, (float)minY, (float)minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex((float)maxX, (float)maxY, (float)maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static int renderInventoryOverlays(BlockInfoAlignment align, int offY, Level worldSchematic, Level worldClient, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        int heightSch = RenderUtils.renderInventoryOverlay(align, LeftRight.LEFT, offY, worldSchematic, pos, mc, drawContext);
        int heightCli = RenderUtils.renderInventoryOverlay(align, LeftRight.RIGHT, offY, worldClient, pos, mc, drawContext);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Level world, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.Context ctx = InventoryUtils.getTargetInventory(world, pos);
        if (ctx != null && ctx.inv() != null) {
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)ctx.type(), (int)ctx.inv().getContainerSize());
            if (ctx.type() == InventoryOverlay.InventoryRenderType.CRAFTER) {
                HashSet<Integer> disabledSlots = new HashSet();
                if (ctx.nbt() != null && !ctx.nbt().isEmpty()) {
                    disabledSlots = NbtBlockUtils.getDisabledSlotsFromNbt((CompoundTag)ctx.nbt());
                } else {
                    BlockEntity blockEntity = ctx.be();
                    if (blockEntity instanceof CrafterBlockEntity) {
                        CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                        disabledSlots = BlockUtils.getDisabledSlots((CrafterBlockEntity)cbe);
                    }
                }
                return RenderUtils.renderInventoryOverlay(align, side, offY, ctx.inv(), ctx.type(), props, disabledSlots, mc, drawContext);
            }
            return RenderUtils.renderInventoryOverlay(align, side, offY, ctx.inv(), ctx.type(), props, mc, drawContext);
        }
        return 0;
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Container inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Minecraft mc, GuiGraphics drawContext) {
        return RenderUtils.renderInventoryOverlay(align, side, offY, inv, type, props, Set.of(), mc, drawContext);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Container inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Set<Integer> disabledSlots, Minecraft mc, GuiGraphics drawContext) {
        int xInv = 0;
        int yInv = 0;
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY;
            }
        }
        if (side == LeftRight.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == LeftRight.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (Minecraft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)inv.getContainerSize(), disabledSlots, (Minecraft)mc, (GuiGraphics)drawContext);
        return props.height;
    }

    public static void renderBackgroundMask(int startX, int startY, int width, int height, GuiGraphics drawContext) {
        fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((ResourceLocation)GuiBase.BG_TEXTURE, (int)startX, (int)startY, (int)0, (int)0, (int)width, (int)height, (GuiGraphics)drawContext);
    }
}

