/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorkerLitematica
implements Runnable {
    private static final Logger LOGGER = Litematica.LOGGER;
    private final ChunkRenderDispatcherLitematica chunkRenderDispatcher;
    private final BufferAllocatorCache allocatorCache;
    private boolean shouldRun = true;
    private ProfilerFiller profiler;

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, ProfilerFiller profiler) {
        this(chunkRenderDispatcherIn, null, profiler);
    }

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, @Nullable BufferAllocatorCache allocatorCache, ProfilerFiller profiler) {
        this.chunkRenderDispatcher = chunkRenderDispatcherIn;
        this.allocatorCache = allocatorCache;
        this.profiler = profiler;
    }

    @Override
    public void run() {
        if (this.profiler == null) {
            this.profiler = Profiler.get();
        }
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate(), this.profiler);
            }
            catch (InterruptedException e) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Batching chunks");
                Minecraft.getInstance().delayCrashRaw(Minecraft.getInstance().fillReport(crashreport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkRenderTaskSchematic task, ProfilerFiller profiler) throws InterruptedException {
        profiler.push("process_task");
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (!task.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)task.getStatus());
                }
                profiler.pop();
                return;
            }
            task.setStatus(ChunkRenderTaskSchematic.Status.COMPILING);
        }
        finally {
            task.getLock().unlock();
        }
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity == null) {
            task.finish();
        } else {
            if (!task.setRegionRenderCacheBuilder(this.getRegionRenderAllocatorCache())) {
                profiler.pop();
                throw new InterruptedException("No free Allocator Cache found");
            }
            ChunkRenderTaskSchematic.Type taskType = task.getType();
            profiler.popPush("run_task_now_" + taskType.name());
            if (taskType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                task.getRenderChunk().rebuildChunk(task, profiler);
            } else if (taskType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                task.getRenderChunk().resortTransparency(task, profiler);
            }
            task.getLock().lock();
            try {
                if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                    if (!task.isFinished()) {
                        LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)task.getStatus());
                    }
                    this.resetRenderAllocators(task);
                    profiler.pop();
                    return;
                }
                task.setStatus(ChunkRenderTaskSchematic.Status.UPLOADING);
            }
            finally {
                task.getLock().unlock();
            }
            profiler.popPush("run_task_schedule_" + taskType.name());
            final ChunkRenderDataSchematic chunkRenderData = task.getChunkRenderData();
            ArrayList futuresList = Lists.newArrayList();
            ChunkRendererSchematicVbo renderChunk = task.getRenderChunk();
            BufferAllocatorCache allocators = task.getAllocatorCache();
            if (taskType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                for (RenderType layer : ChunkRenderLayers.LAYERS) {
                    if (chunkRenderData.isBlockLayerEmpty(layer)) continue;
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(layer, allocators, renderChunk, chunkRenderData, task.getDistanceSq(), false, profiler));
                }
                for (OverlayRenderType type : ChunkRenderLayers.TYPES) {
                    if (chunkRenderData.isOverlayTypeEmpty(type)) continue;
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(type, allocators, renderChunk, chunkRenderData, task.getDistanceSq(), false, profiler));
                }
            } else if (taskType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                RenderType layer = RenderType.translucent();
                if (!chunkRenderData.isBlockLayerEmpty(layer)) {
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(RenderType.translucent(), allocators, renderChunk, chunkRenderData, task.getDistanceSq(), true, profiler));
                }
                if (!chunkRenderData.isOverlayTypeEmpty(OverlayRenderType.QUAD)) {
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(OverlayRenderType.QUAD, allocators, renderChunk, chunkRenderData, task.getDistanceSq(), true, profiler));
                }
            }
            profiler.popPush("run_task_later_" + taskType.name());
            final ListenableFuture listenablefuture = Futures.allAsList((Iterable)futuresList);
            task.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    listenablefuture.cancel(false);
                }
            });
            Futures.addCallback((ListenableFuture)listenablefuture, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> list) {
                    block6: {
                        ChunkRenderWorkerLitematica.this.clearRenderAllocators(task);
                        task.getLock().lock();
                        try {
                            if (task.getStatus() == ChunkRenderTaskSchematic.Status.UPLOADING) {
                                task.setStatus(ChunkRenderTaskSchematic.Status.DONE);
                                break block6;
                            }
                            if (!task.isFinished()) {
                                LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)task.getStatus());
                            }
                        }
                        finally {
                            task.getLock().unlock();
                        }
                        return;
                    }
                    task.getRenderChunk().setChunkRenderData(chunkRenderData);
                }

                public void onFailure(Throwable throwable) {
                    ChunkRenderWorkerLitematica.this.resetRenderAllocators(task);
                    if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrashRaw(CrashReport.forThrowable((Throwable)throwable, (String)"Rendering Litematica chunk"));
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        profiler.pop();
    }

    @Nullable
    private BufferAllocatorCache getRegionRenderAllocatorCache() throws InterruptedException {
        return this.allocatorCache != null ? this.allocatorCache : this.chunkRenderDispatcher.allocateRenderAllocators();
    }

    private void clearRenderAllocators(ChunkRenderTaskSchematic generator) {
        BufferAllocatorCache bufferAllocatorCache = generator.getAllocatorCache();
        bufferAllocatorCache.clearAll();
        if (this.allocatorCache == null) {
            this.chunkRenderDispatcher.freeRenderAllocators(bufferAllocatorCache);
        }
    }

    private void resetRenderAllocators(ChunkRenderTaskSchematic generator) {
        BufferAllocatorCache bufferAllocatorCache = generator.getAllocatorCache();
        bufferAllocatorCache.resetAll();
        if (this.allocatorCache == null) {
            this.chunkRenderDispatcher.freeRenderAllocators(bufferAllocatorCache);
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

