/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui.widgets;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.gui.GuiSchematicVerifier;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.gui.widgets.WidgetListSchematicVerificationResults;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntrySortable;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WidgetSchematicVerificationResult
extends WidgetListEntrySortable<GuiSchematicVerifier.BlockMismatchEntry> {
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);
    public static final String HEADER_EXPECTED = "litematica.gui.label.schematic_verifier.expected";
    public static final String HEADER_FOUND = "litematica.gui.label.schematic_verifier.found";
    public static final String HEADER_COUNT = "litematica.gui.label.schematic_verifier.count";
    private static int maxNameLengthExpected;
    private static int maxNameLengthFound;
    private static int maxCountLength;
    private final BlockRenderDispatcher blockModelShapes;
    private final GuiSchematicVerifier guiSchematicVerifier;
    private final WidgetListSchematicVerificationResults listWidget;
    private final SchematicVerifier verifier;
    private final GuiSchematicVerifier.BlockMismatchEntry mismatchEntry;
    @Nullable
    private final String header1;
    @Nullable
    private final String header2;
    @Nullable
    private final String header3;
    @Nullable
    private final BlockMismatchInfo mismatchInfo;
    private final int count;
    private final boolean isOdd;
    @Nullable
    private final ButtonGeneric buttonIgnore;

    public WidgetSchematicVerificationResult(int x, int y, int width, int height, boolean isOdd, WidgetListSchematicVerificationResults listWidget, GuiSchematicVerifier guiSchematicVerifier, GuiSchematicVerifier.BlockMismatchEntry entry, int listIndex) {
        super(x, y, width, height, (Object)entry, listIndex);
        this.columnCount = 3;
        this.blockModelShapes = this.mc.getBlockRenderer();
        this.mismatchEntry = entry;
        this.guiSchematicVerifier = guiSchematicVerifier;
        this.listWidget = listWidget;
        this.verifier = guiSchematicVerifier.getPlacement().getSchematicVerifier();
        this.isOdd = isOdd;
        if (entry.header1 != null && entry.header2 != null) {
            this.header1 = entry.header1;
            this.header2 = entry.header2;
            this.header3 = GuiBase.TXT_BOLD + StringUtils.translate((String)HEADER_COUNT, (Object[])new Object[0]) + GuiBase.TXT_RST;
            this.mismatchInfo = null;
            this.count = 0;
            this.buttonIgnore = null;
        } else if (entry.header1 != null) {
            this.header1 = entry.header1;
            this.header2 = null;
            this.header3 = null;
            this.mismatchInfo = null;
            this.count = 0;
            this.buttonIgnore = null;
        } else {
            this.header1 = null;
            this.header2 = null;
            this.header3 = null;
            this.mismatchInfo = new BlockMismatchInfo(entry.blockMismatch.stateExpected, entry.blockMismatch.stateFound);
            this.count = entry.blockMismatch.count;
            this.buttonIgnore = entry.mismatchType != SchematicVerifier.MismatchType.CORRECT_STATE ? this.createButton(this.x + this.width, y + 1, ButtonListener.ButtonType.IGNORE_MISMATCH) : null;
        }
    }

    public static void setMaxNameLengths(List<SchematicVerifier.BlockMismatch> mismatches) {
        maxNameLengthExpected = StringUtils.getStringWidth((String)(GuiBase.TXT_BOLD + StringUtils.translate((String)HEADER_EXPECTED, (Object[])new Object[0]) + GuiBase.TXT_RST));
        maxNameLengthFound = StringUtils.getStringWidth((String)(GuiBase.TXT_BOLD + StringUtils.translate((String)HEADER_FOUND, (Object[])new Object[0]) + GuiBase.TXT_RST));
        maxCountLength = 7 * StringUtils.getStringWidth((String)"8");
        for (SchematicVerifier.BlockMismatch entry : mismatches) {
            ItemStack stack = ItemUtils.getItemForState(entry.stateExpected);
            String name = BlockMismatchInfo.getDisplayName(entry.stateExpected, stack);
            maxNameLengthExpected = Math.max(maxNameLengthExpected, StringUtils.getStringWidth((String)name));
            stack = ItemUtils.getItemForState(entry.stateFound);
            name = BlockMismatchInfo.getDisplayName(entry.stateFound, stack);
            maxNameLengthFound = Math.max(maxNameLengthFound, StringUtils.getStringWidth((String)name));
        }
        maxCountLength = Math.max(maxCountLength, StringUtils.getStringWidth((String)(GuiBase.TXT_BOLD + StringUtils.translate((String)HEADER_COUNT, (Object[])new Object[0]) + GuiBase.TXT_RST)));
    }

    private ButtonGeneric createButton(int x, int y, ButtonListener.ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(), new Object[0]);
        return (ButtonGeneric)this.addButton((ButtonBase)button, new ButtonListener(type, this.mismatchEntry, this.guiSchematicVerifier));
    }

    protected int getCurrentSortColumn() {
        return this.verifier.getSortCriteria().ordinal();
    }

    protected boolean getSortInReverse() {
        return this.verifier.getSortInReverse();
    }

    protected int getColumnPosX(int column) {
        int x1 = this.x + 4;
        int x2 = x1 + maxNameLengthExpected + 40;
        int x3 = x2 + maxNameLengthFound + 40;
        switch (column) {
            case 0: {
                return x1;
            }
            case 1: {
                return x2;
            }
            case 2: {
                return x3;
            }
            case 3: {
                return x3 + maxCountLength + 20;
            }
        }
        return x1;
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClickedImpl(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.mismatchEntry.type != GuiSchematicVerifier.BlockMismatchEntry.Type.HEADER) {
            return false;
        }
        int column = this.getMouseOverColumn(mouseX, mouseY);
        switch (column) {
            case 0: {
                this.verifier.setSortCriteria(SchematicVerifier.SortCriteria.NAME_EXPECTED);
                break;
            }
            case 1: {
                this.verifier.setSortCriteria(SchematicVerifier.SortCriteria.NAME_FOUND);
                break;
            }
            case 2: {
                this.verifier.setSortCriteria(SchematicVerifier.SortCriteria.COUNT);
                break;
            }
            default: {
                return false;
            }
        }
        this.listWidget.refreshEntries();
        return true;
    }

    public boolean canSelectAt(int mouseX, int mouseY, int mouseButton) {
        return (this.buttonIgnore == null || mouseX < this.buttonIgnore.getX()) && super.canSelectAt(mouseX, mouseY, mouseButton);
    }

    protected boolean shouldRenderAsSelected() {
        if (this.mismatchEntry.type == GuiSchematicVerifier.BlockMismatchEntry.Type.CATEGORY_TITLE) {
            return this.verifier.isMismatchCategorySelected(this.mismatchEntry.mismatchType);
        }
        if (this.mismatchEntry.type == GuiSchematicVerifier.BlockMismatchEntry.Type.DATA) {
            return this.verifier.isMismatchEntrySelected(this.mismatchEntry.blockMismatch);
        }
        return false;
    }

    public void render(int mouseX, int mouseY, boolean selected, GuiGraphics drawContext) {
        selected = this.shouldRenderAsSelected();
        int color = -1607454672;
        if (selected) {
            color = -1603243920;
        } else if (this.isMouseOver(mouseX, mouseY)) {
            color = -1605349296;
        } else if (this.isOdd) {
            color = -1609560048;
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)color);
        if (selected) {
            fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-2039584);
        }
        int x1 = this.getColumnPosX(0);
        int x2 = this.getColumnPosX(1);
        int x3 = this.getColumnPosX(2);
        int y = this.y + 7;
        color = -1;
        if (this.header1 != null && this.header2 != null) {
            this.drawString(x1, y, color, this.header1, drawContext);
            this.drawString(x2, y, color, this.header2, drawContext);
            this.drawString(x3, y, color, this.header3, drawContext);
            this.renderColumnHeader(mouseX, mouseY, Icons.ARROW_DOWN, Icons.ARROW_UP, drawContext);
        } else if (this.header1 != null) {
            this.drawString(this.x + 4, this.y + 7, color, this.header1, drawContext);
        } else if (!(this.mismatchInfo == null || this.mismatchEntry.mismatchType == SchematicVerifier.MismatchType.CORRECT_STATE && this.mismatchEntry.blockMismatch.stateExpected.isAir())) {
            BlockStateModel model;
            boolean useBlockModelFound;
            this.drawString(x1 + 20, y, color, this.mismatchInfo.nameExpected, drawContext);
            if (this.mismatchEntry.mismatchType != SchematicVerifier.MismatchType.CORRECT_STATE) {
                this.drawString(x2 + 20, y, color, this.mismatchInfo.nameFound, drawContext);
            }
            this.drawString(x3, y, color, String.valueOf(this.count), drawContext);
            y = this.y + 3;
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x1, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
            boolean useBlockModelConfig = Configs.Visuals.SCHEMATIC_VERIFIER_BLOCK_MODELS.getBooleanValue();
            boolean hasModelExpected = this.mismatchInfo.stateExpected.getRenderShape() == RenderShape.MODEL;
            boolean hasModelFound = this.mismatchInfo.stateFound.getRenderShape() == RenderShape.MODEL;
            boolean isAirItemExpected = this.mismatchInfo.stackExpected.isEmpty();
            boolean isAirItemFound = this.mismatchInfo.stackFound.isEmpty();
            boolean useBlockModelExpected = hasModelExpected && (isAirItemExpected || useBlockModelConfig || this.mismatchInfo.stateExpected.getBlock() == Blocks.FLOWER_POT);
            boolean bl = useBlockModelFound = hasModelFound && (isAirItemFound || useBlockModelConfig || this.mismatchInfo.stateFound.getBlock() == Blocks.FLOWER_POT);
            if (useBlockModelExpected) {
                model = this.blockModelShapes.getBlockModel(this.mismatchInfo.stateExpected);
                WidgetSchematicVerificationResult.renderModelInGui(x1, y, 1.0f, model, this.mismatchInfo.stateExpected, drawContext, this.mc);
            } else {
                drawContext.renderItem(this.mismatchInfo.stackExpected, x1, y);
                drawContext.renderItemDecorations(this.textRenderer, this.mismatchInfo.stackExpected, x1, y);
            }
            if (this.mismatchEntry.mismatchType != SchematicVerifier.MismatchType.CORRECT_STATE) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x2, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
                if (useBlockModelFound) {
                    model = this.blockModelShapes.getBlockModel(this.mismatchInfo.stateFound);
                    WidgetSchematicVerificationResult.renderModelInGui(x2, y, 1.0f, model, this.mismatchInfo.stateFound, drawContext, this.mc);
                } else {
                    drawContext.renderItem(this.mismatchInfo.stackFound, x2, y);
                    drawContext.renderItemDecorations(this.textRenderer, this.mismatchInfo.stackFound, x2, y);
                }
            }
        }
        super.render(mouseX, mouseY, selected, drawContext);
    }

    public void postRenderHovered(int mouseX, int mouseY, boolean selected, GuiGraphics drawContext) {
        if (this.mismatchInfo != null && this.buttonIgnore != null && mouseX < this.buttonIgnore.getX()) {
            PoseStack matrixStack = drawContext.pose();
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 200.0f);
            int x = mouseX + 10;
            int y = mouseY;
            int width = this.mismatchInfo.getTotalWidth();
            int height = this.mismatchInfo.getTotalHeight();
            if (x + width > GuiUtils.getCurrentScreenWidth()) {
                x = mouseX - width - 10;
            }
            if (y + height > GuiUtils.getCurrentScreenHeight()) {
                y = mouseY - height - 2;
            }
            this.mismatchInfo.toggleUseBackgroundMask(true);
            this.mismatchInfo.render(x, y, this.mc, drawContext);
            matrixStack.popPose();
        }
    }

    public static void renderModelInGui(int x, int y, float z, BlockStateModel model, BlockState state, GuiGraphics drawContext, Minecraft mc) {
        PoseStack matrixStack = drawContext.pose();
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
        fi.dy.masa.malilib.render.RenderUtils.bindGuiOverlayTexture((ResourceLocation)TextureAtlas.LOCATION_BLOCKS, (GuiGraphics)drawContext);
        mc.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate((double)x + 8.0, (double)y + 8.0, (double)z + 100.0);
        matrixStack.scale(16.0f, -16.0f, 16.0f);
        Quaternionf rot = new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f);
        matrixStack.mulPose((Quaternionfc)rot);
        matrixStack.scale(0.625f, 0.625f, 0.625f);
        matrixStack.translate(-0.5, -0.5, -0.5);
        WidgetSchematicVerificationResult.renderModel(model, state, matrixStack);
        matrixStack.popPose();
    }

    private static void renderModel(BlockStateModel model, BlockState state, PoseStack matrixStack) {
        ByteBufferBuilder allocator = new ByteBufferBuilder(1536);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)allocator);
        VertexConsumer vertexConsumer = immediate.getBuffer(RenderType.translucent());
        PoseStack.Pose matrixEntry = matrixStack.last();
        int l = LightTexture.pack((int)15, (int)15);
        int[] light = new int[]{l, l, l, l};
        float[] brightness = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
        Lighting.setupFor3DItems();
        List parts = model.collectParts((RandomSource)RAND);
        for (BlockModelPart part : parts) {
            for (Direction face : PositionUtils.ALL_DIRECTIONS) {
                RAND.setSeed(0L);
                WidgetSchematicVerificationResult.renderQuads(part.getQuads(face), brightness, light, matrixEntry, vertexConsumer);
            }
            RAND.setSeed(0L);
            WidgetSchematicVerificationResult.renderQuads(part.getQuads(null), brightness, light, matrixEntry, vertexConsumer);
        }
        immediate.endBatch();
        allocator.close();
    }

    private static void renderQuads(List<BakedQuad> quads, float[] brightness, int[] light, PoseStack.Pose matrixEntry, VertexConsumer vertexConsumer) {
        for (BakedQuad quad : quads) {
            WidgetSchematicVerificationResult.renderQuad(quad, brightness, light, matrixEntry, vertexConsumer);
        }
    }

    private static void renderQuad(BakedQuad quad, float[] brightness, int[] light, PoseStack.Pose matrixEntry, VertexConsumer vertexConsumer) {
        vertexConsumer.putBulkData(matrixEntry, quad, brightness, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY, true);
    }

    public static class BlockMismatchInfo {
        private final BlockState stateExpected;
        private final BlockState stateFound;
        private final ItemStack stackExpected;
        private final ItemStack stackFound;
        private final String blockRegistrynameExpected;
        private final String blockRegistrynameFound;
        private final String nameExpected;
        private final String nameFound;
        private final int totalWidth;
        private final int totalHeight;
        private final int columnWidthExpected;
        private boolean useBackgroundMask = false;

        public BlockMismatchInfo(BlockState stateExpected, BlockState stateFound) {
            this.stateExpected = stateExpected;
            this.stateFound = stateFound;
            this.stackExpected = ItemUtils.getItemForState(this.stateExpected);
            this.stackFound = ItemUtils.getItemForState(this.stateFound);
            Block blockExpected = this.stateExpected.getBlock();
            Block blockFound = this.stateFound.getBlock();
            ResourceLocation rl1 = BuiltInRegistries.BLOCK.getKey((Object)blockExpected);
            ResourceLocation rl2 = BuiltInRegistries.BLOCK.getKey((Object)blockFound);
            this.blockRegistrynameExpected = rl1 != null ? rl1.toString() : "<null>";
            this.blockRegistrynameFound = rl2 != null ? rl2.toString() : "<null>";
            this.nameExpected = BlockMismatchInfo.getDisplayName(stateExpected, this.stackExpected);
            this.nameFound = BlockMismatchInfo.getDisplayName(stateFound, this.stackFound);
            List propsExpected = BlockUtils.getFormattedBlockStateProperties((BlockState)this.stateExpected, (String)" = ");
            List propsFound = BlockUtils.getFormattedBlockStateProperties((BlockState)this.stateFound, (String)" = ");
            int w1 = Math.max(StringUtils.getStringWidth((String)this.nameExpected) + 20, StringUtils.getStringWidth((String)this.blockRegistrynameExpected));
            int w2 = Math.max(StringUtils.getStringWidth((String)this.nameFound) + 20, StringUtils.getStringWidth((String)this.blockRegistrynameFound));
            w1 = Math.max(w1, RenderUtils.getMaxStringRenderLength(propsExpected));
            w2 = Math.max(w2, RenderUtils.getMaxStringRenderLength(propsFound));
            this.columnWidthExpected = w1;
            this.totalWidth = this.columnWidthExpected + w2 + 40;
            this.totalHeight = Math.max(propsExpected.size(), propsFound.size()) * (StringUtils.getFontHeight() + 2) + 60;
        }

        public static String getDisplayName(BlockState state, ItemStack stack) {
            String name;
            Block block = state.getBlock();
            String key = block.getDescriptionId() + ".name";
            name = !key.equals(name = StringUtils.translate((String)key, (Object[])new Object[0])) ? name : stack.getHoverName().getString();
            return name;
        }

        public int getTotalWidth() {
            return this.totalWidth;
        }

        public int getTotalHeight() {
            return this.totalHeight;
        }

        public void toggleUseBackgroundMask(boolean toggle) {
            this.useBackgroundMask = toggle;
        }

        public void render(int x, int y, Minecraft mc, GuiGraphics drawContext) {
            if (this.stateExpected != null && this.stateFound != null) {
                BlockStateModel model;
                if (this.useBackgroundMask) {
                    RenderUtils.renderBackgroundMask(x + 1, y + 1, this.totalWidth - 1, this.totalHeight - 1, drawContext);
                }
                PoseStack matrixStack = drawContext.pose();
                matrixStack.pushPose();
                fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.totalWidth, (int)this.totalHeight, (int)-16777216, (int)-6710887);
                int x1 = x + 10;
                int x2 = x + this.columnWidthExpected + 30;
                Font textRenderer = mc.font;
                String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
                String strExpected = pre + StringUtils.translate((String)WidgetSchematicVerificationResult.HEADER_EXPECTED, (Object[])new Object[0]) + GuiBase.TXT_RST;
                String strFound = pre + StringUtils.translate((String)WidgetSchematicVerificationResult.HEADER_FOUND, (Object[])new Object[0]) + GuiBase.TXT_RST;
                drawContext.drawString(textRenderer, strExpected, x1, y += 4, -1, false);
                drawContext.drawString(textRenderer, strFound, x2, y, -1, false);
                y += 12;
                boolean useBlockModelConfig = Configs.Visuals.SCHEMATIC_VERIFIER_BLOCK_MODELS.getBooleanValue();
                boolean hasModelExpected = this.stateExpected.getRenderShape() == RenderShape.MODEL;
                boolean hasModelFound = this.stateFound.getRenderShape() == RenderShape.MODEL;
                boolean isAirItemExpected = this.stackExpected.isEmpty();
                boolean isAirItemFound = this.stackFound.isEmpty();
                boolean useBlockModelExpected = hasModelExpected && (isAirItemExpected || useBlockModelConfig || this.stateExpected.getBlock() == Blocks.FLOWER_POT);
                boolean useBlockModelFound = hasModelFound && (isAirItemFound || useBlockModelConfig || this.stateFound.getBlock() == Blocks.FLOWER_POT);
                BlockRenderDispatcher blockModelShapes = mc.getBlockRenderer();
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x1, (int)y, (int)16, (int)16, (int)0x50C0C0C0);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x2, (int)y, (int)16, (int)16, (int)0x50C0C0C0);
                int iconY = y;
                drawContext.drawString(textRenderer, this.nameExpected, x1 + 20, y + 4, -1, false);
                drawContext.drawString(textRenderer, this.nameFound, x2 + 20, y + 4, -1, false);
                drawContext.drawString(textRenderer, this.blockRegistrynameExpected, x1, y += 20, -12558081, false);
                drawContext.drawString(textRenderer, this.blockRegistrynameFound, x2, y, -12558081, false);
                List propsExpected = BlockUtils.getFormattedBlockStateProperties((BlockState)this.stateExpected, (String)" = ");
                List propsFound = BlockUtils.getFormattedBlockStateProperties((BlockState)this.stateFound, (String)" = ");
                fi.dy.masa.malilib.render.RenderUtils.renderText((int)x1, (int)(y += StringUtils.getFontHeight() + 4), (int)-5197648, (List)propsExpected, (GuiGraphics)drawContext);
                fi.dy.masa.malilib.render.RenderUtils.renderText((int)x2, (int)y, (int)-5197648, (List)propsFound, (GuiGraphics)drawContext);
                if (useBlockModelExpected) {
                    model = blockModelShapes.getBlockModel(this.stateExpected);
                    WidgetSchematicVerificationResult.renderModelInGui(x1, iconY, 1.0f, model, this.stateExpected, drawContext, mc);
                } else {
                    drawContext.renderItem(this.stackExpected, x1, iconY);
                    drawContext.renderItemDecorations(textRenderer, this.stackExpected, x1, iconY);
                }
                if (useBlockModelFound) {
                    model = blockModelShapes.getBlockModel(this.stateFound);
                    WidgetSchematicVerificationResult.renderModelInGui(x2, iconY, 1.0f, model, this.stateFound, drawContext, mc);
                } else {
                    drawContext.renderItem(this.stackFound, x2, iconY);
                    drawContext.renderItemDecorations(textRenderer, this.stackFound, x2, iconY);
                }
                matrixStack.popPose();
            }
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final ButtonType type;
        private final GuiSchematicVerifier guiSchematicVerifier;
        private final GuiSchematicVerifier.BlockMismatchEntry mismatchEntry;

        public ButtonListener(ButtonType type, GuiSchematicVerifier.BlockMismatchEntry mismatchEntry, GuiSchematicVerifier guiSchematicVerifier) {
            this.type = type;
            this.mismatchEntry = mismatchEntry;
            this.guiSchematicVerifier = guiSchematicVerifier;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.IGNORE_MISMATCH) {
                this.guiSchematicVerifier.getPlacement().getSchematicVerifier().ignoreStateMismatch(this.mismatchEntry.blockMismatch);
                this.guiSchematicVerifier.initGui();
            }
        }

        public static enum ButtonType {
            IGNORE_MISMATCH("litematica.gui.button.schematic_verifier.ignore");

            private final String translationKey;

            private ButtonType(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getDisplayName() {
                return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
            }
        }
    }
}

