/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.compat.iris.IrisCompat;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Matrix4f;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private Minecraft mc;
    private WorldRendererSchematic worldRenderer;
    private Frustum frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewiseEntities;
    private boolean renderPiecewiseTileEntities;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.getInstance();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public WorldRendererSchematic resetWorldRenderer() {
        if (this.worldRenderer != null) {
            this.worldRenderer.setWorldAndLoadRenderers(null);
            this.worldRenderer = null;
        }
        return this.getWorldRenderer();
    }

    public void loadRenderers(@Nullable ProfilerFiller profiler) {
        this.getWorldRenderer().loadRenderers(profiler);
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + 1000000000L / fpsTarget / 2L;
    }

    public void renderSchematicOverlays(Camera camera, ProfilerFiller profiler) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            profiler.push("schematic_overlay");
            if (!IrisCompat.isShadowPassActive()) {
                this.getWorldRenderer().renderBlockOverlays(camera, lineWidth, profiler);
            }
            profiler.pop();
        }
    }

    public void piecewisePrepareAndUpdate(Frustum frustum, ProfilerFiller profiler) {
        boolean render = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.getCameraEntity() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        this.renderPiecewiseEntities = false;
        this.renderPiecewiseTileEntities = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (render && frustum != null && worldRenderer.hasWorld() && this.mc.player != null) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderPiecewiseEntities = this.renderPiecewiseSchematic && Configs.Visuals.RENDER_SCHEMATIC_ENTITIES.getBooleanValue();
            boolean bl = this.renderPiecewiseTileEntities = this.renderPiecewiseSchematic && Configs.Visuals.RENDER_SCHEMATIC_TILE_ENTITIES.getBooleanValue();
            if (this.renderPiecewiseSchematic) {
                profiler.push("litematica_culling");
                this.calculateFinishTime();
                profiler.popPush("litematica_terrain_setup");
                worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.player.isSpectator(), profiler);
                profiler.popPush("litematica_update_chunks");
                worldRenderer.updateChunks(this.finishTimeNano, profiler);
                profiler.pop();
                this.frustum = frustum;
            }
        }
    }

    public void piecewiseRenderSolid(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_solid");
            this.getWorldRenderer().renderBlockLayer(RenderType.solid(), this.getCamera(), profiler, this.renderCollidingSchematicBlocks ? MaLiLibPipelines.SOLID_MASA_OFFSET : MaLiLibPipelines.SOLID_MASA);
            profiler.pop();
        }
    }

    public void piecewiseRenderCutoutMipped(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_cutout_mipped");
            this.getWorldRenderer().renderBlockLayer(RenderType.cutoutMipped(), this.getCamera(), profiler, this.renderCollidingSchematicBlocks ? MaLiLibPipelines.CUTOUT_MIPPED_MASA_OFFSET : MaLiLibPipelines.CUTOUT_MIPPED_MASA);
            profiler.pop();
        }
    }

    public void piecewiseRenderCutout(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_cutout");
            this.getWorldRenderer().renderBlockLayer(RenderType.cutout(), this.getCamera(), profiler, this.renderCollidingSchematicBlocks ? MaLiLibPipelines.CUTOUT_MASA_OFFSET : MaLiLibPipelines.CUTOUT_MASA);
            profiler.pop();
        }
    }

    public void piecewiseRenderTranslucent(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_translucent");
            this.getWorldRenderer().renderBlockLayer(RenderType.translucent(), this.getCamera(), profiler, this.renderCollidingSchematicBlocks ? MaLiLibPipelines.TRANSLUCENT_MASA_OFFSET : MaLiLibPipelines.TRANSLUCENT_MASA);
            profiler.pop();
        }
    }

    public void piecewiseRenderTripwire(Matrix4f viewMatrix, Matrix4f posMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseBlocks) {
            profiler.push("litematica_tripwire");
            this.getWorldRenderer().renderBlockLayer(RenderType.tripwire(), this.getCamera(), profiler, this.renderCollidingSchematicBlocks ? MaLiLibPipelines.TRIPWIRE_MASA_OFFSET : MaLiLibPipelines.TRIPWIRE_MASA);
            profiler.pop();
        }
    }

    public void piecewiseRenderOverlay(Matrix4f posMatrix, Matrix4f projMatrix, ProfilerFiller profiler) {
        if (this.renderPiecewiseSchematic) {
            profiler.push("litematica_schematic_overlay");
            this.renderSchematicOverlays(this.getCamera(), profiler);
            profiler.pop();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(PoseStack matrices, MultiBufferSource.BufferSource immediate, float partialTicks, ProfilerFiller profiler) {
        if (this.renderPiecewiseEntities) {
            profiler.push("litematica_entities");
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, immediate, partialTicks, profiler);
            profiler.pop();
        }
    }

    public void piecewiseRenderBlockEntities(PoseStack matrices, MultiBufferSource.BufferSource immediate, MultiBufferSource.BufferSource immediate2, float partialTicks, ProfilerFiller profiler) {
        if (this.renderPiecewiseTileEntities) {
            profiler.push("litematica_block_entities");
            this.getWorldRenderer().renderBlockEntities(this.getCamera(), this.frustum, matrices, immediate, immediate2, partialTicks, profiler);
            profiler.pop();
        }
    }

    private Camera getCamera() {
        return this.mc.gameRenderer.getMainCamera();
    }

    private void cleanup() {
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        this.renderPiecewiseEntities = false;
        this.renderPiecewiseTileEntities = false;
    }
}

