/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    private static final SingleThreadedRandomSource RAND = new SingleThreadedRandomSource(0L);

    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    public static void drawDebugBlockModelOutlinesBatched(List<BlockModelPart> modelParts, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (BlockModelPart part : modelParts) {
            RenderUtils.drawDebugBlockModelOutlinesBatched(part, state, pos, color, expand, buffer);
        }
    }

    public static void drawDebugBlockModelOutlinesBatched(BlockModelPart modelPart, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderDebugModelQuadOutlines(modelPart, state, pos, side, color, expand, buffer);
        }
        RenderUtils.renderDebugModelQuadOutlines(modelPart, state, pos, null, color, expand, buffer);
    }

    public static void renderDebugModelQuadOutlines(BlockModelPart modelPart, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        try {
            RenderUtils.renderDebugModelQuadOutlines(pos, buffer, color, modelPart.getQuads(side));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderDebugModelQuadOutlines(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderDebugQuadOutlinesBatched(pos, buffer, color, quads.get(i).vertices());
        }
    }

    public static void renderDebugQuadOutlinesBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        buffer.addVertex(fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBlockModelOutlinesBatched(List<BlockModelPart> modelParts, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer, PoseStack matricies) {
        for (BlockModelPart part : modelParts) {
            RenderUtils.drawlockModelOutlinesBatched(part, state, pos, color, expand, buffer, matricies);
        }
    }

    public static void drawlockModelOutlinesBatched(BlockModelPart modelPart, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer, PoseStack matricies) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderModelQuadOutlines(modelPart, state, pos, side, color, expand, buffer, matricies);
        }
        RenderUtils.renderModelQuadOutlines(modelPart, state, pos, null, color, expand, buffer, matricies);
    }

    public static void renderModelQuadOutlines(BlockModelPart modelPart, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer, PoseStack matricies) {
        try {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, modelPart.getQuads(side), matricies);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderModelQuadOutlines(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads, PoseStack matricies) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).vertices(), matricies);
        }
    }

    public static void renderQuadOutlinesBatched(BlockPos pos, BufferBuilder buffer, Color4f color, int[] vertexData, PoseStack matricies) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        PoseStack.Pose e = matricies.last();
        buffer.addVertex(e, fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[1], fy[1], fz[1]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[2], fy[2], fz[2]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[3], fy[3], fz[3]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
        buffer.addVertex(e, fx[0], fy[0], fz[0]).setColor(color.r, color.g, color.b, color.a).setNormal(e, 0.0f, 0.0f, 0.0f);
    }

    public static boolean stateModelHasQuads(BlockState state) {
        return RenderUtils.modelHasQuads(Objects.requireNonNull(Minecraft.getInstance().getBlockRenderer().getBlockModel(state)));
    }

    public static boolean modelHasQuads(@Nonnull BlockStateModel model) {
        return RenderUtils.hasQuads(model.collectParts((RandomSource)new SingleThreadedRandomSource(0L)));
    }

    public static boolean hasQuads(List<BlockModelPart> modelParts) {
        if (modelParts.isEmpty()) {
            return false;
        }
        int totalSize = 0;
        for (BlockModelPart part : modelParts) {
            for (Direction face : PositionUtils.ALL_DIRECTIONS) {
                totalSize += part.getQuads(face).size();
            }
            totalSize += part.getQuads(null).size();
        }
        return totalSize > 0;
    }

    public static void drawBlockModelQuadOverlayBatched(List<BlockModelPart> modelParts, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (BlockModelPart part : modelParts) {
            RenderUtils.drawBlockModelQuadOverlayBatched(part, state, pos, color, expand, buffer);
        }
    }

    public static void drawBlockModelQuadOverlayBatched(BlockModelPart modelPart, BlockState state, BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockModelQuadOverlayBatched(modelPart, state, pos, side, color, expand, buffer);
        }
        RenderUtils.drawBlockModelQuadOverlayBatched(modelPart, state, pos, null, color, expand, buffer);
    }

    public static void drawBlockModelQuadOverlayBatched(BlockModelPart modelPart, BlockState state, BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, modelPart.getQuads(side));
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quad);
        }
    }

    private static void renderModelQuadOverlayBatched(BlockPos pos, BufferBuilder buffer, Color4f color, BakedQuad quad) {
        int[] vertexData = quad.vertices();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.addVertex(fx, fy, fz).setColor(color.r, color.g, color.b, color.a);
        }
    }

    public static void drawBlockBoxBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockBoxSideBatchedQuads(pos, side, color, expand, buffer);
        }
    }

    public static void drawBlockBoxSideBatchedQuads(BlockPos pos, Direction side, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand);
        float minY = (float)((double)pos.getY() - expand);
        float minZ = (float)((double)pos.getZ() - expand);
        float maxX = (float)((double)pos.getX() + expand + 1.0);
        float maxY = (float)((double)pos.getY() + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand + 1.0);
        switch (side) {
            case DOWN: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case WEST: {
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(BlockPos pos, Direction.Axis axis, int cornerIndex, Color4f color, BufferBuilder buffer) {
        Vec3i offset = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.getX() + offset.getX();
        double minY = pos.getY() + offset.getY();
        double minZ = pos.getZ() + offset.getZ();
        double maxX = pos.getX() + offset.getX() + (axis == Direction.Axis.X ? 1 : 0);
        double maxY = pos.getY() + offset.getY() + (axis == Direction.Axis.Y ? 1 : 0);
        double maxZ = pos.getZ() + offset.getZ() + (axis == Direction.Axis.Z ? 1 : 0);
        buffer.addVertex((float)minX, (float)minY, (float)minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex((float)maxX, (float)maxY, (float)maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void drawBlockBoxEdgeBatchedDebugLines(BlockPos pos, Direction.Axis axis, int cornerIndex, Color4f color, BufferBuilder buffer) {
        Vec3i offset = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.getX() + offset.getX();
        double minY = pos.getY() + offset.getY();
        double minZ = pos.getZ() + offset.getZ();
        double maxX = pos.getX() + offset.getX() + (axis == Direction.Axis.X ? 1 : 0);
        double maxY = pos.getY() + offset.getY() + (axis == Direction.Axis.Y ? 1 : 0);
        double maxZ = pos.getZ() + offset.getZ() + (axis == Direction.Axis.Z ? 1 : 0);
        buffer.addVertex((float)minX, (float)minY, (float)minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex((float)maxX, (float)maxY, (float)maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static int renderInventoryOverlays(BlockInfoAlignment align, int offY, Level worldSchematic, Level worldClient, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        int heightSch = RenderUtils.renderInventoryOverlay(align, LeftRight.LEFT, offY, worldSchematic, pos, mc, drawContext);
        int heightCli = RenderUtils.renderInventoryOverlay(align, LeftRight.RIGHT, offY, worldClient, pos, mc, drawContext);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Level world, BlockPos pos, Minecraft mc, GuiGraphics drawContext) {
        InventoryOverlay.Context ctx = InventoryUtils.getTargetInventory(world, pos);
        if (ctx != null && ctx.inv() != null) {
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)ctx.type(), (int)ctx.inv().getContainerSize());
            if (ctx.type() == InventoryOverlay.InventoryRenderType.CRAFTER) {
                HashSet<Integer> disabledSlots = new HashSet();
                if (ctx.nbt() != null && !ctx.nbt().isEmpty()) {
                    disabledSlots = NbtBlockUtils.getDisabledSlotsFromNbt((CompoundTag)ctx.nbt());
                } else {
                    BlockEntity blockEntity = ctx.be();
                    if (blockEntity instanceof CrafterBlockEntity) {
                        CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                        disabledSlots = BlockUtils.getDisabledSlots((CrafterBlockEntity)cbe);
                    }
                }
                return RenderUtils.renderInventoryOverlay(align, side, offY, ctx.inv(), ctx.type(), props, disabledSlots, mc, drawContext);
            }
            return RenderUtils.renderInventoryOverlay(align, side, offY, ctx.inv(), ctx.type(), props, mc, drawContext);
        }
        return 0;
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Container inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Minecraft mc, GuiGraphics drawContext) {
        return RenderUtils.renderInventoryOverlay(align, side, offY, inv, type, props, Set.of(), mc, drawContext);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, Container inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Set<Integer> disabledSlots, Minecraft mc, GuiGraphics drawContext) {
        int xInv = 0;
        int yInv = 0;
        int compatShift = OverlayRenderer.calculateCompatYShift();
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY + compatShift;
            }
        }
        if (side == LeftRight.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == LeftRight.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)inv.getContainerSize(), disabledSlots, (Minecraft)mc, (GuiGraphics)drawContext);
        return props.height + compatShift;
    }

    public static void renderBackgroundMask(int startX, int startY, int width, int height, GuiGraphics drawContext) {
        fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((ResourceLocation)GuiBase.BG_TEXTURE, (int)startX, (int)startY, (int)0, (int)0, (int)width, (int)height, (GuiGraphics)drawContext);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedDebugLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.drawBoxAllEdgesBatchedDebugLines(pos, Vec3.ZERO, color, expand, buffer);
    }

    public static void drawBoxAllEdgesBatchedDebugLines(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        float minX = (float)((double)pos.getX() - expand - cameraPos.x);
        float minY = (float)((double)pos.getY() - expand - cameraPos.y);
        float minZ = (float)((double)pos.getZ() - expand - cameraPos.z);
        float maxX = (float)((double)pos.getX() + expand - cameraPos.x + 1.0);
        float maxY = (float)((double)pos.getY() + expand - cameraPos.y + 1.0);
        float maxZ = (float)((double)pos.getZ() + expand - cameraPos.z + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedDebugLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllEdgesBatchedDebugLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, BufferBuilder buffer) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }
}

