/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Queues;
import com.google.common.primitives.Doubles;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexSorting;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderWorkerLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcherLitematica {
    private static final Logger LOGGER = Litematica.LOGGER;
    private final List<Thread> listWorkerThreads = new ArrayList<Thread>();
    private final List<ChunkRenderWorkerLitematica> listThreadedWorkers = new ArrayList<ChunkRenderWorkerLitematica>();
    private final PriorityBlockingQueue<ChunkRenderTaskSchematic> queueChunkUpdates = Queues.newPriorityBlockingQueue();
    private final BlockingQueue<BufferAllocatorCache> queueFreeRenderAllocators;
    private final Queue<PendingUpload> queueChunkUploads = Queues.newPriorityQueue();
    private final ChunkRenderWorkerLitematica renderWorker;
    private final int countRenderAllocators;
    private Vec3 cameraPos = Vec3.ZERO;

    public ChunkRenderDispatcherLitematica(ProfilerFiller profiler) {
        this.countRenderAllocators = 2;
        LOGGER.info("Using {} total BufferAllocator caches", (Object)(this.countRenderAllocators + 1));
        this.queueFreeRenderAllocators = Queues.newArrayBlockingQueue((int)this.countRenderAllocators);
        for (int i = 0; i < this.countRenderAllocators; ++i) {
            this.queueFreeRenderAllocators.add(new BufferAllocatorCache());
        }
        this.renderWorker = new ChunkRenderWorkerLitematica(this, new BufferAllocatorCache(), profiler);
    }

    protected void setCameraPosition(Vec3 cameraPos) {
        this.cameraPos = cameraPos;
    }

    public Vec3 getCameraPos() {
        return this.cameraPos;
    }

    protected String getDebugInfo() {
        return this.listWorkerThreads.isEmpty() ? String.format("pC: %03d, single-threaded", this.queueChunkUpdates.size()) : String.format("pC: %03d, pU: %1d, aB: %1d", this.queueChunkUpdates.size(), this.queueChunkUploads.size(), this.queueFreeRenderAllocators.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runChunkUploads(long finishTimeNano, ProfilerFiller profiler) {
        boolean processedTask;
        boolean ranTasks = false;
        profiler.push("run_chunk_uploads");
        do {
            ChunkRenderTaskSchematic generator;
            processedTask = false;
            if (this.listWorkerThreads.isEmpty() && (generator = this.queueChunkUpdates.poll()) != null) {
                try {
                    this.renderWorker.processTask(generator, profiler);
                    processedTask = true;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("runChunkUploads(): Process Interrupted; error message: [{}]", (Object)e.getLocalizedMessage());
                }
            }
            Queue<PendingUpload> queue = this.queueChunkUploads;
            synchronized (queue) {
                if (!this.queueChunkUploads.isEmpty()) {
                    this.queueChunkUploads.poll().uploadTask.run();
                    processedTask = true;
                    ranTasks = true;
                }
            }
        } while (finishTimeNano != 0L && processedTask && finishTimeNano >= System.nanoTime());
        profiler.pop();
        return ranTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateChunkLater(ChunkRendererSchematicVbo renderChunk, ProfilerFiller profiler) {
        boolean flag1;
        profiler.push("update_chunk_later");
        renderChunk.getLockCompileTask().lock();
        try {
            final ChunkRenderTaskSchematic generator = renderChunk.makeCompileTaskChunkSchematic(this::getCameraPos);
            generator.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    ChunkRenderDispatcherLitematica.this.queueChunkUpdates.remove(generator);
                }
            });
            boolean flag = this.queueChunkUpdates.offer(generator);
            if (!flag) {
                generator.finish();
            }
            flag1 = flag;
        }
        finally {
            renderChunk.getLockCompileTask().unlock();
        }
        profiler.pop();
        return flag1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateChunkNow(ChunkRendererSchematicVbo chunkRenderer, ProfilerFiller profiler) {
        boolean flag;
        profiler.push("update_chunk_now");
        chunkRenderer.getLockCompileTask().lock();
        try {
            ChunkRenderTaskSchematic generator = chunkRenderer.makeCompileTaskChunkSchematic(this::getCameraPos);
            try {
                this.renderWorker.processTask(generator, profiler);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            flag = true;
        }
        finally {
            chunkRenderer.getLockCompileTask().unlock();
        }
        profiler.pop();
        return flag;
    }

    protected void stopChunkUpdates(ProfilerFiller profiler) {
        profiler.push("stop_chunk_updates");
        this.clearChunkUpdates();
        ArrayList<BufferAllocatorCache> list = new ArrayList<BufferAllocatorCache>();
        while (list.size() != this.countRenderAllocators) {
            this.runChunkUploads(Long.MAX_VALUE, profiler);
            try {
                list.add(this.allocateRenderAllocators());
            }
            catch (InterruptedException e) {
                LOGGER.warn("stopChunkUpdates(): Process Interrupted; error message: [{}]", (Object)e.getLocalizedMessage());
            }
        }
        this.queueFreeRenderAllocators.addAll(list);
        profiler.pop();
    }

    public void freeRenderAllocators(BufferAllocatorCache allocatorCache) {
        if (allocatorCache != null) {
            try {
                allocatorCache.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        allocatorCache = new BufferAllocatorCache();
        this.queueFreeRenderAllocators.add(allocatorCache);
    }

    public BufferAllocatorCache allocateRenderAllocators() throws InterruptedException {
        return this.queueFreeRenderAllocators.take();
    }

    protected ChunkRenderTaskSchematic getNextChunkUpdate() throws InterruptedException {
        return this.queueChunkUpdates.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateTransparencyLater(ChunkRendererSchematicVbo renderChunk, ProfilerFiller profiler) {
        boolean flag;
        profiler.push("update_transparency_later");
        renderChunk.getLockCompileTask().lock();
        try {
            final ChunkRenderTaskSchematic generator = renderChunk.makeCompileTaskTransparencySchematic(this::getCameraPos);
            if (generator == null) {
                boolean flag2 = true;
                profiler.pop();
                boolean bl = flag2;
                return bl;
            }
            generator.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    ChunkRenderDispatcherLitematica.this.queueChunkUpdates.remove(generator);
                }
            });
            flag = this.queueChunkUpdates.offer(generator);
        }
        finally {
            renderChunk.getLockCompileTask().unlock();
        }
        profiler.pop();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Object> uploadChunkBlocks(final RenderType layer, final BufferAllocatorCache allocators, final ChunkRendererSchematicVbo renderChunk, final ChunkRenderDataSchematic chunkRenderData, final double distanceSq, final boolean resortOnly, final ProfilerFiller profiler) {
        profiler.push("upload_chunk_blocks");
        if (Minecraft.getInstance().isSameThread()) {
            try {
                this.uploadVertexBufferByLayer(layer, allocators, renderChunk, chunkRenderData, renderChunk.createVertexSorter(this.getCameraPos(), renderChunk.getOrigin()), resortOnly, profiler);
            }
            catch (Exception e) {
                LOGGER.warn("uploadChunkBlocks(): [Dispatch] Error uploading Vertex Buffer for layer [{}], Caught error: [{}]", (Object)ChunkRenderLayers.getFriendlyName(layer), (Object)e.toString());
            }
            profiler.pop();
            return Futures.immediateFuture(null);
        }
        profiler.popPush("upload_chunk_blocks_later");
        ListenableFutureTask futureTask = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                ChunkRenderDispatcherLitematica.this.uploadChunkBlocks(layer, allocators, renderChunk, chunkRenderData, distanceSq, resortOnly, profiler);
            }
        }, null);
        Queue<PendingUpload> queue = this.queueChunkUploads;
        synchronized (queue) {
            this.queueChunkUploads.add(new PendingUpload((ListenableFutureTask<Object>)futureTask, distanceSq));
            profiler.pop();
            return futureTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Object> uploadChunkOverlay(final OverlayRenderType type, final BufferAllocatorCache allocators, final ChunkRendererSchematicVbo renderChunk, final ChunkRenderDataSchematic compiledChunk, final double distanceSq, final boolean resortOnly, final ProfilerFiller profiler) {
        profiler.push("upload_chunk_overlay");
        if (Minecraft.getInstance().isSameThread()) {
            try {
                this.uploadVertexBufferByType(type, allocators, renderChunk, compiledChunk, renderChunk.createVertexSorter(this.getCameraPos(), renderChunk.getOrigin()), resortOnly, profiler);
            }
            catch (Exception e) {
                LOGGER.error("uploadChunkOverlay(): [Dispatch] Error uploading Vertex Buffer for overlay type [{}], Caught error: [{}]", (Object)type.getDrawMode().name(), (Object)e.toString());
            }
            profiler.pop();
            return Futures.immediateFuture(null);
        }
        profiler.popPush("upload_chunk_overlay_later");
        ListenableFutureTask futureTask = ListenableFutureTask.create((Runnable)new Runnable(){

            @Override
            public void run() {
                ChunkRenderDispatcherLitematica.this.uploadChunkOverlay(type, allocators, renderChunk, compiledChunk, distanceSq, resortOnly, profiler);
            }
        }, null);
        Queue<PendingUpload> queue = this.queueChunkUploads;
        synchronized (queue) {
            this.queueChunkUploads.add(new PendingUpload((ListenableFutureTask<Object>)futureTask, distanceSq));
            profiler.pop();
            return futureTask;
        }
    }

    private void uploadVertexBufferByLayer(RenderType layer, @Nonnull BufferAllocatorCache allocators, @Nonnull ChunkRendererSchematicVbo renderChunk, @Nonnull ChunkRenderDataSchematic compiledChunk, @Nonnull VertexSorting sorter, boolean resortOnly, ProfilerFiller profiler) throws InterruptedException {
        profiler.push("upload_vbo_layer_" + layer.toString());
        ByteBufferBuilder allocator = allocators.getBufferByLayer(layer);
        MeshData builtBuffer = compiledChunk.getBuiltBufferCache().getBuiltBufferByLayer(layer);
        if (allocator == null) {
            allocators.closeByLayer(layer);
            compiledChunk.setBlockLayerUnused(layer);
            profiler.pop();
            throw new InterruptedException("BufferAllocators are invalid");
        }
        if (builtBuffer == null) {
            compiledChunk.setBlockLayerUnused(layer);
            profiler.pop();
            return;
        }
        if (!resortOnly) {
            renderChunk.uploadBuffersByLayer(layer, builtBuffer);
        }
        if (layer == RenderType.translucent() && Configs.Visuals.RENDER_ENABLE_TRANSLUCENT_RESORTING.getBooleanValue()) {
            ByteBufferBuilder.Result result;
            MeshData.SortState sorting = compiledChunk.getTransparentSortingDataForLayer(layer);
            if (sorting == null) {
                sorting = builtBuffer.sortQuads(allocator, sorter);
                if (sorting == null) {
                    profiler.pop();
                    throw new InterruptedException("Sort State failed to sortQuads()");
                }
                compiledChunk.setTransparentSortingDataForLayer(layer, sorting);
            }
            if ((result = sorting.buildSortedIndexBuffer(allocator, sorter)) != null) {
                renderChunk.uploadIndexByLayer(layer, result);
                result.close();
            }
        }
        profiler.pop();
    }

    private void uploadVertexBufferByType(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators, @Nonnull ChunkRendererSchematicVbo renderChunk, @Nonnull ChunkRenderDataSchematic compiledChunk, @Nonnull VertexSorting sorter, boolean resortOnly, ProfilerFiller profiler) throws InterruptedException {
        profiler.push("upload_vbo_overlay_" + type.name());
        ByteBufferBuilder allocator = allocators.getBufferByOverlay(type);
        MeshData builtBuffer = compiledChunk.getBuiltBufferCache().getBuiltBufferByType(type);
        if (allocator == null) {
            allocators.closeByType(type);
            compiledChunk.setOverlayTypeUnused(type);
            profiler.pop();
            throw new InterruptedException("BufferAllocators are invalid");
        }
        if (builtBuffer == null) {
            compiledChunk.setOverlayTypeUnused(type);
            profiler.pop();
            return;
        }
        if (!resortOnly) {
            renderChunk.uploadBuffersByType(type, builtBuffer);
        }
        profiler.pop();
    }

    protected void clearChunkUpdates() {
        while (!this.queueChunkUpdates.isEmpty()) {
            ChunkRenderTaskSchematic generator = this.queueChunkUpdates.poll();
            if (generator == null) continue;
            generator.finish();
        }
    }

    public boolean hasChunkUpdates() {
        return this.queueChunkUpdates.isEmpty() && this.queueChunkUploads.isEmpty();
    }

    protected void stopWorkerThreads() {
        this.clearChunkUpdates();
        for (ChunkRenderWorkerLitematica worker : this.listThreadedWorkers) {
            worker.notifyToStop();
        }
        for (Thread thread : this.listWorkerThreads) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedexception) {
                LOGGER.warn("Interrupted whilst waiting for worker to die", (Throwable)interruptedexception);
            }
        }
        this.queueFreeRenderAllocators.forEach(BufferAllocatorCache::close);
        this.queueFreeRenderAllocators.clear();
    }

    public boolean hasNoFreeRenderAllocators() {
        return this.queueFreeRenderAllocators.isEmpty();
    }

    protected static class PendingUpload
    implements Comparable<PendingUpload> {
        private final ListenableFutureTask<Object> uploadTask;
        private final double distanceSq;

        public PendingUpload(ListenableFutureTask<Object> uploadTaskIn, double distanceSqIn) {
            this.uploadTask = uploadTaskIn;
            this.distanceSq = distanceSqIn;
        }

        @Override
        public int compareTo(PendingUpload other) {
            return Doubles.compare((double)this.distanceSq, (double)other.distanceSq);
        }
    }
}

