/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.selection;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.util.StringRepresentable;

public enum SelectionMode implements StringRepresentable
{
    NORMAL("normal", "litematica.gui.label.area_selection.mode.normal"),
    SIMPLE("simple", "litematica.gui.label.area_selection.mode.simple");

    public static final StringRepresentable.EnumCodec<SelectionMode> CODEC;
    public static final ImmutableList<SelectionMode> VALUES;
    private final String configString;
    private final String translationKey;

    private SelectionMode(String configName, String translationKey) {
        this.configString = configName;
        this.translationKey = translationKey;
    }

    public Codec<SelectionMode> codec() {
        return CODEC;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getDisplayName() {
        return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
    }

    public SelectionMode cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= SelectionMode.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = SelectionMode.values().length - 1;
        }
        return SelectionMode.values()[id % SelectionMode.values().length];
    }

    public static SelectionMode fromString(String name) {
        for (SelectionMode mode : SelectionMode.values()) {
            if (!mode.name().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return NORMAL;
    }

    public String getSerializedName() {
        return this.configString;
    }

    static {
        CODEC = StringRepresentable.fromEnum(SelectionMode::values);
        VALUES = ImmutableList.copyOf((Object[])SelectionMode.values());
    }
}

