/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SchematicEntityLookup<T extends EntityAccess>
implements LevelEntityGetter<T>,
AutoCloseable {
    private final List<T> list = new ArrayList<T>();

    protected SchematicEntityLookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(T entity) {
        T tmp = this.get(entity.getUUID());
        if (tmp != null) {
            this.remove(entity.getUUID());
        }
        List<T> list = this.list;
        synchronized (list) {
            this.list.add(entity);
        }
    }

    protected int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(UUID uuid) {
        List<T> list = this.list;
        synchronized (list) {
            this.list.removeIf(e -> e.getUUID().equals(uuid));
        }
    }

    @Nullable
    public T get(int id) {
        for (EntityAccess e : this.list) {
            if (e.getId() != id) continue;
            return (T)e;
        }
        return null;
    }

    @Nullable
    public T get(UUID uuid) {
        for (EntityAccess e : this.list) {
            if (!e.getUUID().equals(uuid)) continue;
            return (T)e;
        }
        return null;
    }

    public Iterable<T> getAll() {
        return Iterables.concat((Iterable[])new Iterable[]{this.list});
    }

    public void get(AABB box, Consumer action) {
    }

    public void get(EntityTypeTest filter, AABB box, AbortableIterationConsumer consumer) {
    }

    public void get(EntityTypeTest filter, AbortableIterationConsumer consumer) {
    }

    @Override
    public void close() throws Exception {
        this.list.clear();
    }
}

