/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.event;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicManager;
import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.render.infohud.ToolHud;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.GuiUtils;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    public void onRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, FogParameters fog, ProfilerFiller profiler) {
        Minecraft mc = Minecraft.getInstance();
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && mc.player != null) {
            profiler.push("overlay_boxes");
            OverlayRenderer.getInstance().renderBoxes(posMatrix, profiler);
            if (Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED.getBooleanValue()) {
                profiler.popPush("overlay_mismatches");
                OverlayRenderer.getInstance().renderSchematicVerifierMismatches(posMatrix, profiler);
            }
            if (DataManager.getToolMode() == ToolMode.REBUILD) {
                profiler.popPush("overlay_targeting");
                OverlayRenderer.getInstance().renderSchematicRebuildTargetingOverlay(posMatrix, profiler);
            }
            profiler.pop();
        }
    }

    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "litematica_render_handler";
    }

    public void onRenderGameOverlayPostAdvanced(GuiGraphics drawContext, float partialTicks, ProfilerFiller profiler, Minecraft mc) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && mc.player != null) {
            profiler.push("overlay_hud");
            InfoHud.getInstance().renderHud(drawContext);
            if (GuiUtils.getCurrentScreen() == null) {
                if (!mc.options.hideGui) {
                    ToolHud.getInstance().renderHud(drawContext);
                    profiler.popPush("overlay_hover_info");
                    OverlayRenderer.getInstance().renderHoverInfo(mc, drawContext, profiler);
                }
                if (GuiSchematicManager.hasPendingPreviewTask()) {
                    profiler.popPush("overlay_preview_frame");
                    OverlayRenderer.getInstance().renderPreviewFrame(mc, drawContext, profiler);
                }
            }
            profiler.pop();
        }
    }
}

