/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.mixin.block.IMixinFenceGateBlock;
import fi.dy.masa.litematica.mixin.block.IMixinRedstoneWireBlock;
import fi.dy.masa.litematica.mixin.block.IMixinStairsBlock;
import fi.dy.masa.litematica.mixin.block.IMixinVineBlock;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.malilib.util.PositionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;

public class SchematicConversionFixers {
    private static final BooleanProperty[] HORIZONTAL_CONNECTING_BLOCK_PROPS = new BooleanProperty[]{null, null, CrossCollisionBlock.NORTH, CrossCollisionBlock.SOUTH, CrossCollisionBlock.WEST, CrossCollisionBlock.EAST};
    private static final BlockState REDSTONE_WIRE_DOT_OLD = Blocks.REDSTONE_WIRE.defaultBlockState();
    private static final BlockState REDSTONE_WIRE_DOT = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.REDSTONE_WIRE.defaultBlockState().setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0))).setValue((Property)RedStoneWireBlock.NORTH, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.EAST, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.SOUTH, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.NONE);
    private static final BlockState REDSTONE_WIRE_CROSS = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.REDSTONE_WIRE.defaultBlockState().setValue((Property)RedStoneWireBlock.NORTH, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.EAST, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.SOUTH, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
    public static final IStateFixer FIXER_BANNER = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("Base", 3) && (colorOrig = ((AbstractBannerBlock)state.getBlock()).getColor()) != (colorFromData = DyeColor.byId((int)(15 - tag.getInt("Base"))))) {
            Integer rotation = (Integer)state.getValue((Property)BannerBlock.ROTATION);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.WHITE_BANNER.defaultBlockState();
                    break;
                }
                case ORANGE: {
                    state = Blocks.ORANGE_BANNER.defaultBlockState();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.MAGENTA_BANNER.defaultBlockState();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.LIGHT_BLUE_BANNER.defaultBlockState();
                    break;
                }
                case YELLOW: {
                    state = Blocks.YELLOW_BANNER.defaultBlockState();
                    break;
                }
                case LIME: {
                    state = Blocks.LIME_BANNER.defaultBlockState();
                    break;
                }
                case PINK: {
                    state = Blocks.PINK_BANNER.defaultBlockState();
                    break;
                }
                case GRAY: {
                    state = Blocks.GRAY_BANNER.defaultBlockState();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.LIGHT_GRAY_BANNER.defaultBlockState();
                    break;
                }
                case CYAN: {
                    state = Blocks.CYAN_BANNER.defaultBlockState();
                    break;
                }
                case PURPLE: {
                    state = Blocks.PURPLE_BANNER.defaultBlockState();
                    break;
                }
                case BLUE: {
                    state = Blocks.BLUE_BANNER.defaultBlockState();
                    break;
                }
                case BROWN: {
                    state = Blocks.BROWN_BANNER.defaultBlockState();
                    break;
                }
                case GREEN: {
                    state = Blocks.GREEN_BANNER.defaultBlockState();
                    break;
                }
                case RED: {
                    state = Blocks.RED_BANNER.defaultBlockState();
                    break;
                }
                case BLACK: {
                    state = Blocks.BLACK_BANNER.defaultBlockState();
                }
            }
            state = (BlockState)state.setValue((Property)BannerBlock.ROTATION, (Comparable)rotation);
        }
        return state;
    };
    public static final IStateFixer FIXER_BANNER_WALL = (reader, state, pos) -> {
        DyeColor colorFromData;
        DyeColor colorOrig;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("Base", 3) && (colorOrig = ((AbstractBannerBlock)state.getBlock()).getColor()) != (colorFromData = DyeColor.byId((int)(15 - tag.getInt("Base"))))) {
            Direction facing = (Direction)state.getValue((Property)WallBannerBlock.FACING);
            switch (colorFromData) {
                case WHITE: {
                    state = Blocks.WHITE_WALL_BANNER.defaultBlockState();
                    break;
                }
                case ORANGE: {
                    state = Blocks.ORANGE_WALL_BANNER.defaultBlockState();
                    break;
                }
                case MAGENTA: {
                    state = Blocks.MAGENTA_WALL_BANNER.defaultBlockState();
                    break;
                }
                case LIGHT_BLUE: {
                    state = Blocks.LIGHT_BLUE_WALL_BANNER.defaultBlockState();
                    break;
                }
                case YELLOW: {
                    state = Blocks.YELLOW_WALL_BANNER.defaultBlockState();
                    break;
                }
                case LIME: {
                    state = Blocks.LIME_WALL_BANNER.defaultBlockState();
                    break;
                }
                case PINK: {
                    state = Blocks.PINK_WALL_BANNER.defaultBlockState();
                    break;
                }
                case GRAY: {
                    state = Blocks.GRAY_WALL_BANNER.defaultBlockState();
                    break;
                }
                case LIGHT_GRAY: {
                    state = Blocks.LIGHT_GRAY_WALL_BANNER.defaultBlockState();
                    break;
                }
                case CYAN: {
                    state = Blocks.CYAN_WALL_BANNER.defaultBlockState();
                    break;
                }
                case PURPLE: {
                    state = Blocks.PURPLE_WALL_BANNER.defaultBlockState();
                    break;
                }
                case BLUE: {
                    state = Blocks.BLUE_WALL_BANNER.defaultBlockState();
                    break;
                }
                case BROWN: {
                    state = Blocks.BROWN_WALL_BANNER.defaultBlockState();
                    break;
                }
                case GREEN: {
                    state = Blocks.GREEN_WALL_BANNER.defaultBlockState();
                    break;
                }
                case RED: {
                    state = Blocks.RED_WALL_BANNER.defaultBlockState();
                    break;
                }
                case BLACK: {
                    state = Blocks.BLACK_WALL_BANNER.defaultBlockState();
                }
            }
            state = (BlockState)state.setValue((Property)WallBannerBlock.FACING, (Comparable)facing);
        }
        return state;
    };
    public static final IStateFixer FIXER_BED = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("color", 3)) {
            int colorId = tag.getInt("color");
            Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
            BedPart part = (BedPart)state.getValue((Property)BedBlock.PART);
            Boolean occupied = (Boolean)state.getValue((Property)BedBlock.OCCUPIED);
            switch (colorId) {
                case 0: {
                    state = Blocks.WHITE_BED.defaultBlockState();
                    break;
                }
                case 1: {
                    state = Blocks.ORANGE_BED.defaultBlockState();
                    break;
                }
                case 2: {
                    state = Blocks.MAGENTA_BED.defaultBlockState();
                    break;
                }
                case 3: {
                    state = Blocks.LIGHT_BLUE_BED.defaultBlockState();
                    break;
                }
                case 4: {
                    state = Blocks.YELLOW_BED.defaultBlockState();
                    break;
                }
                case 5: {
                    state = Blocks.LIME_BED.defaultBlockState();
                    break;
                }
                case 6: {
                    state = Blocks.PINK_BED.defaultBlockState();
                    break;
                }
                case 7: {
                    state = Blocks.GRAY_BED.defaultBlockState();
                    break;
                }
                case 8: {
                    state = Blocks.LIGHT_GRAY_BED.defaultBlockState();
                    break;
                }
                case 9: {
                    state = Blocks.CYAN_BED.defaultBlockState();
                    break;
                }
                case 10: {
                    state = Blocks.PURPLE_BED.defaultBlockState();
                    break;
                }
                case 11: {
                    state = Blocks.BLUE_BED.defaultBlockState();
                    break;
                }
                case 12: {
                    state = Blocks.BROWN_BED.defaultBlockState();
                    break;
                }
                case 13: {
                    state = Blocks.GREEN_BED.defaultBlockState();
                    break;
                }
                case 14: {
                    state = Blocks.RED_BED.defaultBlockState();
                    break;
                }
                case 15: {
                    state = Blocks.BLACK_BED.defaultBlockState();
                    break;
                }
                default: {
                    return state;
                }
            }
            state = (BlockState)((BlockState)((BlockState)state.setValue((Property)BedBlock.FACING, (Comparable)facing)).setValue((Property)BedBlock.PART, (Comparable)part)).setValue((Property)BedBlock.OCCUPIED, (Comparable)occupied);
        }
        return state;
    };
    public static final IStateFixer FIXER_CHRORUS_PLANT = (reader, state, pos) -> ChorusPlantBlock.getStateWithConnections((BlockGetter)reader, (BlockPos)pos, (BlockState)state);
    public static final IStateFixer FIXER_DIRT_SNOWY = (reader, state, pos) -> {
        Block block = reader.getBlockState(pos.above()).getBlock();
        return (BlockState)state.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(block == Blocks.SNOW_BLOCK || block == Blocks.SNOW));
    };
    public static final IStateFixer FIXER_DOOR = (reader, state, pos) -> {
        if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
            BlockState stateLower = reader.getBlockState(pos.below());
            if (stateLower.getBlock() == state.getBlock()) {
                state = (BlockState)state.setValue((Property)DoorBlock.FACING, (Comparable)((Direction)stateLower.getValue((Property)DoorBlock.FACING)));
                state = (BlockState)state.setValue((Property)DoorBlock.OPEN, (Comparable)((Boolean)stateLower.getValue((Property)DoorBlock.OPEN)));
            }
        } else {
            BlockState stateUpper = reader.getBlockState(pos.above());
            if (stateUpper.getBlock() == state.getBlock()) {
                state = (BlockState)state.setValue((Property)DoorBlock.HINGE, (Comparable)((DoorHingeSide)stateUpper.getValue((Property)DoorBlock.HINGE)));
                state = (BlockState)state.setValue((Property)DoorBlock.POWERED, (Comparable)((Boolean)stateUpper.getValue((Property)DoorBlock.POWERED)));
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_DOUBLE_PLANT = (reader, state, pos) -> {
        BlockState stateLower;
        if (state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER && (stateLower = reader.getBlockState(pos.below())).getBlock() instanceof DoublePlantBlock) {
            state = (BlockState)stateLower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE = (reader, state, pos) -> {
        FenceBlock fence = (FenceBlock)state.getBlock();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.relative(side);
            BlockState stateAdj = reader.getBlockState(posAdj);
            Direction sideOpposite = side.getOpposite();
            boolean flag = stateAdj.isFaceSturdy((BlockGetter)reader, posAdj, sideOpposite);
            state = (BlockState)state.setValue((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.get3DDataValue()], (Comparable)Boolean.valueOf(fence.connectsTo(stateAdj, flag, sideOpposite)));
        }
        return state;
    };
    public static final IStateFixer FIXER_FENCE_GATE = (reader, state, pos) -> {
        FenceGateBlock gate = (FenceGateBlock)state.getBlock();
        Direction facing = (Direction)state.getValue((Property)FenceGateBlock.FACING);
        boolean inWall = false;
        inWall = facing.getAxis() == Direction.Axis.X ? ((IMixinFenceGateBlock)gate).litematica_invokeIsWall(reader.getBlockState(pos.relative(Direction.NORTH))) || ((IMixinFenceGateBlock)gate).litematica_invokeIsWall(reader.getBlockState(pos.relative(Direction.SOUTH))) : ((IMixinFenceGateBlock)gate).litematica_invokeIsWall(reader.getBlockState(pos.relative(Direction.WEST))) || ((IMixinFenceGateBlock)gate).litematica_invokeIsWall(reader.getBlockState(pos.relative(Direction.EAST)));
        return (BlockState)state.setValue((Property)FenceGateBlock.IN_WALL, (Comparable)Boolean.valueOf(inWall));
    };
    public static final IStateFixer FIXER_FIRE = (reader, state, pos) -> BaseFireBlock.getState((BlockGetter)reader, (BlockPos)pos);
    public static final IStateFixer FIXER_FLOWER_POT = (reader, state, pos) -> {
        String itemName;
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("Item", 8) && (itemName = tag.getString("Item")).length() > 0 && tag.contains("Data")) {
            int meta = tag.getInt("Data");
            switch (itemName) {
                case "minecraft:sapling": {
                    if (meta == 0) {
                        return Blocks.POTTED_OAK_SAPLING.defaultBlockState();
                    }
                    if (meta == 1) {
                        return Blocks.POTTED_SPRUCE_SAPLING.defaultBlockState();
                    }
                    if (meta == 2) {
                        return Blocks.POTTED_BIRCH_SAPLING.defaultBlockState();
                    }
                    if (meta == 3) {
                        return Blocks.POTTED_JUNGLE_SAPLING.defaultBlockState();
                    }
                    if (meta == 4) {
                        return Blocks.POTTED_ACACIA_SAPLING.defaultBlockState();
                    }
                    if (meta != 5) break;
                    return Blocks.POTTED_DARK_OAK_SAPLING.defaultBlockState();
                }
                case "minecraft:tallgrass": {
                    if (meta == 0) {
                        return Blocks.POTTED_DEAD_BUSH.defaultBlockState();
                    }
                    if (meta != 2) break;
                    return Blocks.POTTED_FERN.defaultBlockState();
                }
                case "minecraft:red_flower": {
                    if (meta == 0) {
                        return Blocks.POTTED_POPPY.defaultBlockState();
                    }
                    if (meta == 1) {
                        return Blocks.POTTED_BLUE_ORCHID.defaultBlockState();
                    }
                    if (meta == 2) {
                        return Blocks.POTTED_ALLIUM.defaultBlockState();
                    }
                    if (meta == 3) {
                        return Blocks.POTTED_AZURE_BLUET.defaultBlockState();
                    }
                    if (meta == 4) {
                        return Blocks.POTTED_RED_TULIP.defaultBlockState();
                    }
                    if (meta == 5) {
                        return Blocks.POTTED_ORANGE_TULIP.defaultBlockState();
                    }
                    if (meta == 6) {
                        return Blocks.POTTED_WHITE_TULIP.defaultBlockState();
                    }
                    if (meta == 7) {
                        return Blocks.POTTED_PINK_TULIP.defaultBlockState();
                    }
                    if (meta != 8) break;
                    return Blocks.POTTED_OXEYE_DAISY.defaultBlockState();
                }
                case "minecraft:yellow_flower": {
                    return Blocks.POTTED_DANDELION.defaultBlockState();
                }
                case "minecraft:brown_mushroom": {
                    return Blocks.POTTED_BROWN_MUSHROOM.defaultBlockState();
                }
                case "minecraft:red_mushroom": {
                    return Blocks.POTTED_RED_MUSHROOM.defaultBlockState();
                }
                case "minecraft:deadbush": {
                    return Blocks.POTTED_DEAD_BUSH.defaultBlockState();
                }
                case "minecraft:cactus": {
                    return Blocks.POTTED_CACTUS.defaultBlockState();
                }
                default: {
                    return state;
                }
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_NOTE_BLOCK = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null) {
            state = (BlockState)((BlockState)((BlockState)state.setValue((Property)NoteBlock.POWERED, (Comparable)Boolean.valueOf(tag.getBoolean("powered")))).setValue((Property)NoteBlock.NOTE, (Comparable)Integer.valueOf(Mth.clamp((int)tag.getByte("note"), (int)0, (int)24)))).setValue((Property)NoteBlock.INSTRUMENT, (Comparable)reader.getBlockState(pos.below()).instrument());
        }
        return state;
    };
    public static final IStateFixer FIXER_PANE = (reader, state, pos) -> {
        IronBarsBlock pane = (IronBarsBlock)state.getBlock();
        for (Direction side : PositionUtils.HORIZONTAL_DIRECTIONS) {
            BlockPos posAdj = pos.relative(side);
            BlockState stateAdj = reader.getBlockState(posAdj);
            Direction sideOpposite = side.getOpposite();
            boolean flag = stateAdj.isFaceSturdy((BlockGetter)reader, posAdj, sideOpposite);
            state = (BlockState)state.setValue((Property)HORIZONTAL_CONNECTING_BLOCK_PROPS[side.get3DDataValue()], (Comparable)Boolean.valueOf(pane.attachsTo(stateAdj, flag)));
        }
        return state;
    };
    public static final IStateFixer FIXER_REDSTONE_REPEATER = (reader, state, pos) -> (BlockState)state.setValue((Property)RepeaterBlock.LOCKED, (Comparable)Boolean.valueOf(SchematicConversionFixers.getIsRepeaterPoweredOnSide(reader, pos, state)));
    public static final IStateFixer FIXER_REDSTONE_WIRE = (reader, state, pos) -> {
        RedStoneWireBlock wire = (RedStoneWireBlock)state.getBlock();
        BlockState stateAdj = ((IMixinRedstoneWireBlock)wire).litematica_GetPlacementState(reader, state, pos);
        if (!stateAdj.equals(state)) {
            stateAdj = state;
        }
        if (!stateAdj.equals(REDSTONE_WIRE_DOT) && stateAdj.setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0)) == REDSTONE_WIRE_DOT_OLD) {
            stateAdj = (BlockState)REDSTONE_WIRE_CROSS.setValue((Property)RedStoneWireBlock.POWER, (Comparable)((Integer)stateAdj.getValue((Property)RedStoneWireBlock.POWER)));
        }
        return stateAdj;
    };
    public static final IStateFixer FIXER_SIGN = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("Text1", 8)) {
            ListTag textList = new ListTag();
            textList.add((Object)tag.get("Text1"));
            textList.add((Object)tag.get("Text2"));
            textList.add((Object)tag.get("Text3"));
            textList.add((Object)tag.get("Text4"));
            CompoundTag frontTextTag = new CompoundTag();
            frontTextTag.put("messages", (Tag)textList);
            frontTextTag.putString("color", tag.getString("Color"));
            frontTextTag.putByte("has_glowing_text", tag.getByte("GlowingText"));
            tag.put("front_text", (Tag)frontTextTag);
            tag.remove("Color");
            tag.remove("GlowingText");
            tag.remove("Text1");
            tag.remove("Text2");
            tag.remove("Text3");
            tag.remove("Text4");
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("SkullType")) {
            int id = Mth.clamp((int)tag.getByte("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.Type typeOrig = ((AbstractSkullBlock)state.getBlock()).getType();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.SKELETON_SKULL.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.WITHER_SKELETON_SKULL.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.PLAYER_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.ZOMBIE_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.CREEPER_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.DRAGON_HEAD.defaultBlockState();
                }
            }
            state = (BlockState)state.setValue((Property)BannerBlock.ROTATION, (Comparable)Integer.valueOf(Mth.clamp((int)tag.getByte("Rot"), (int)0, (int)15)));
        }
        return state;
    };
    public static final IStateFixer FIXER_SKULL_WALL = (reader, state, pos) -> {
        CompoundTag tag = reader.getBlockEntityData(pos);
        if (tag != null && tag.contains("SkullType", 1)) {
            int id = Mth.clamp((int)tag.getByte("SkullType"), (int)0, (int)5);
            if (id == 2) {
                id = 3;
            } else if (id == 3) {
                id = 2;
            }
            SkullBlock.Type typeOrig = ((AbstractSkullBlock)state.getBlock()).getType();
            SkullBlock.Types typeFromData = SkullBlock.Types.values()[id];
            if (typeOrig != typeFromData) {
                Direction facing = (Direction)state.getValue((Property)WallSkullBlock.FACING);
                if (typeFromData == SkullBlock.Types.SKELETON) {
                    state = Blocks.SKELETON_WALL_SKULL.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.WITHER_SKELETON) {
                    state = Blocks.WITHER_SKELETON_WALL_SKULL.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.PLAYER) {
                    state = Blocks.PLAYER_WALL_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.ZOMBIE) {
                    state = Blocks.ZOMBIE_WALL_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.CREEPER) {
                    state = Blocks.CREEPER_WALL_HEAD.defaultBlockState();
                } else if (typeFromData == SkullBlock.Types.DRAGON) {
                    state = Blocks.DRAGON_WALL_HEAD.defaultBlockState();
                }
                state = (BlockState)state.setValue((Property)WallSkullBlock.FACING, (Comparable)facing);
            }
        }
        return state;
    };
    public static final IStateFixer FIXER_STAIRS = (reader, state, pos) -> (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)IMixinStairsBlock.litematica_invokeGetStairShape(state, reader, pos));
    public static final IStateFixer FIXER_STEM = (reader, state, pos) -> state;
    public static final IStateFixer FIXER_TRIPWIRE = (reader, state, pos) -> {
        TripWireBlock wire = (TripWireBlock)state.getBlock();
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)TripWireBlock.NORTH, (Comparable)Boolean.valueOf(wire.shouldConnectTo(reader.getBlockState(pos.north()), Direction.NORTH)))).setValue((Property)TripWireBlock.SOUTH, (Comparable)Boolean.valueOf(wire.shouldConnectTo(reader.getBlockState(pos.south()), Direction.SOUTH)))).setValue((Property)TripWireBlock.WEST, (Comparable)Boolean.valueOf(wire.shouldConnectTo(reader.getBlockState(pos.west()), Direction.WEST)))).setValue((Property)TripWireBlock.EAST, (Comparable)Boolean.valueOf(wire.shouldConnectTo(reader.getBlockState(pos.east()), Direction.EAST)));
    };
    public static final IStateFixer FIXER_VINE = (reader, state, pos) -> {
        VineBlock vine = (VineBlock)state.getBlock();
        return (BlockState)state.setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(((IMixinVineBlock)vine).litematica_invokeShouldConnectUp(reader, pos.above(), Direction.UP)));
    };

    private static boolean getIsRepeaterPoweredOnSide(BlockGetter reader, BlockPos pos, BlockState stateRepeater) {
        Direction facing = (Direction)stateRepeater.getValue((Property)RepeaterBlock.FACING);
        Direction sideLeft = facing.getCounterClockWise();
        Direction sideRight = facing.getClockWise();
        return SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.relative(sideLeft), sideLeft) > 0 || SchematicConversionFixers.getRepeaterPowerOnSide(reader, pos.relative(sideRight), sideRight) > 0;
    }

    private static int getRepeaterPowerOnSide(BlockGetter reader, BlockPos pos, Direction side) {
        BlockState state = reader.getBlockState(pos);
        Block block = state.getBlock();
        if (DiodeBlock.isDiode((BlockState)state)) {
            if (block == Blocks.REDSTONE_BLOCK) {
                return 15;
            }
            return block == Blocks.REDSTONE_WIRE ? ((Integer)state.getValue((Property)RedStoneWireBlock.POWER)).intValue() : state.getDirectSignal(reader, pos, side);
        }
        return 0;
    }

    public static interface IStateFixer {
        public BlockState fixState(IBlockReaderWithData var1, BlockState var2, BlockPos var3);
    }
}

