/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.network.ServuxLitematicaHandler;
import fi.dy.masa.litematica.network.ServuxLitematicaPacket;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.render.infohud.StatusInfoRenderer;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkCommand;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblockToMcfunction;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteLayerBehavior;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfirmAction;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IConfirmationListener;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SchematicPlacementManager {
    protected final List<SchematicPlacement> schematicPlacements = new ArrayList<SchematicPlacement>();
    protected final ArrayListMultimap<ChunkPos, SchematicPlacement> schematicsTouchingChunk = ArrayListMultimap.create();
    protected final Long2ObjectOpenHashMap<List<PlacementPart>> touchedVolumesInChunk = new Long2ObjectOpenHashMap();
    protected final Set<ChunkPos> chunksToRebuild = new HashSet<ChunkPos>();
    protected final Set<ChunkPos> chunkRebuildQueue = new HashSet<ChunkPos>();
    protected final LongOpenHashSet chunksToUnload = new LongOpenHashSet();
    protected final Set<ChunkPos> chunksPreChange = new HashSet<ChunkPos>();
    protected final List<ChunkPos> visibleChunks = new ArrayList<ChunkPos>();
    protected final Supplier<WorldSchematic> worldSupplier;
    protected ChunkPos lastVisibleChunksSortPos = new ChunkPos(0, 0);
    protected boolean visibleChunksNeedsUpdate;
    @Nullable
    private SchematicPlacement selectedPlacement;

    public SchematicPlacementManager() {
        this(SchematicWorldHandler::getSchematicWorld);
    }

    protected SchematicPlacementManager(Supplier<WorldSchematic> worldSupplier) {
        this.worldSupplier = worldSupplier;
    }

    public boolean hasPendingRebuilds() {
        return !this.chunksToRebuild.isEmpty();
    }

    public boolean hasPendingRebuildFor(ChunkPos pos) {
        return this.chunksToRebuild.contains(pos);
    }

    public void setVisibleSubChunksNeedsUpdate() {
        this.visibleChunksNeedsUpdate = true;
    }

    protected boolean hasTimeToExecuteMoreTasks() {
        return System.nanoTime() - DataManager.getClientTickStartTime() <= 50000000L;
    }

    protected boolean canHandleChunk(ClientLevel clientWorld, int chunkX, int chunkZ) {
        return Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue() || WorldUtils.isClientChunkLoaded(clientWorld, chunkX, chunkZ);
    }

    public boolean hasQueuedChunks() {
        return !this.chunkRebuildQueue.isEmpty();
    }

    public void processQueuedChunks() {
        if (!this.chunksToUnload.isEmpty()) {
            WorldSchematic worldSchematic = this.worldSupplier.get();
            if (worldSchematic != null) {
                LongIterator longIterator = this.chunksToUnload.iterator();
                while (longIterator.hasNext()) {
                    long posLong = (Long)longIterator.next();
                    this.unloadSchematicChunk(worldSchematic, ChunkPos.getX((long)posLong), ChunkPos.getZ((long)posLong));
                }
            }
            this.chunksToUnload.clear();
        }
        if (this.hasQueuedChunks()) {
            ClientLevel worldClient = Minecraft.getInstance().level;
            if (worldClient == null) {
                this.chunksToRebuild.clear();
                this.chunkRebuildQueue.clear();
                return;
            }
            WorldSchematic worldSchematic = this.worldSupplier.get();
            Iterator<ChunkPos> queueIterator = this.chunkRebuildQueue.iterator();
            while (queueIterator.hasNext() && this.hasTimeToExecuteMoreTasks()) {
                ChunkPos pos = queueIterator.next();
                if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                    queueIterator.remove();
                    this.chunksToRebuild.remove(pos);
                    continue;
                }
                if (this.canHandleChunk(worldClient, pos.x, pos.z)) {
                    this.unloadSchematicChunk(worldSchematic, pos.x, pos.z);
                    worldSchematic.getChunkProvider().loadChunk(pos.x, pos.z);
                    this.visibleChunksNeedsUpdate = true;
                }
                if (worldSchematic.getChunkProvider().hasChunk(pos.x, pos.z)) {
                    List placements = this.schematicsTouchingChunk.get((Object)pos);
                    if (!placements.isEmpty()) {
                        ReplaceBehavior behavior = (ReplaceBehavior)Configs.Generic.PLACEMENT_REPLACE_BEHAVIOR.getOptionListValue();
                        PasteLayerBehavior layers = (PasteLayerBehavior)Configs.Generic.PASTE_LAYER_BEHAVIOR.getOptionListValue();
                        for (SchematicPlacement placement : placements) {
                            if (!placement.isEnabled()) continue;
                            SchematicPlacingUtils.placeToWorldWithinChunk(worldSchematic, pos, placement, behavior, layers, false);
                        }
                        worldSchematic.scheduleChunkRenders(pos.x, pos.z);
                    }
                    this.chunksToRebuild.remove(pos);
                }
                queueIterator.remove();
            }
            LitematicaRenderer.getInstance().getWorldRenderer().markNeedsUpdate();
        }
    }

    public void onClientChunkLoad(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        this.chunkRebuildQueue.add(pos);
    }

    public void onClientChunkUnload(int chunkX, int chunkZ) {
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue()) {
            this.chunksToUnload.add(ChunkPos.asLong((int)chunkX, (int)chunkZ));
        }
    }

    protected void unloadSchematicChunk(WorldSchematic worldSchematic, int chunkX, int chunkZ) {
        if (worldSchematic.getChunkProvider().hasChunk(chunkX, chunkZ)) {
            worldSchematic.getChunkProvider().unloadChunk(chunkX, chunkZ);
            worldSchematic.scheduleChunkRenders(chunkX, chunkZ);
            this.visibleChunksNeedsUpdate = true;
        }
    }

    public int getLastVisibleChunksCount() {
        return this.visibleChunks.size();
    }

    public List<ChunkPos> getAndUpdateVisibleChunks(ChunkPos viewChunk) {
        if (this.visibleChunksNeedsUpdate) {
            this.visibleChunks.clear();
            WorldSchematic worldSchematic = this.worldSupplier.get();
            LayerRange range = DataManager.getRenderLayerRange();
            if (worldSchematic != null) {
                int minY = worldSchematic.getMinY();
                int maxY = worldSchematic.getMaxY() - 1;
                LongIterator longIterator = worldSchematic.getChunkManager().getLoadedChunks().keySet().iterator();
                while (longIterator.hasNext()) {
                    int maxZ;
                    int maxX;
                    int minZ;
                    long posLong = (Long)longIterator.next();
                    int minX = ChunkPos.getX((long)posLong) << 4;
                    if (!range.intersectsBox(minX, minY, minZ = ChunkPos.getZ((long)posLong) << 4, maxX = minX + 15, maxY, maxZ = minZ + 15)) continue;
                    this.visibleChunks.add(new ChunkPos(posLong));
                }
                this.visibleChunks.sort(new PositionUtils.ChunkPosDistanceComparator(viewChunk));
                this.lastVisibleChunksSortPos = viewChunk;
            }
            this.visibleChunksNeedsUpdate = false;
        } else if (!viewChunk.equals((Object)this.lastVisibleChunksSortPos)) {
            this.visibleChunks.sort(new PositionUtils.ChunkPosDistanceComparator(viewChunk));
            this.lastVisibleChunksSortPos = viewChunk;
        }
        return this.visibleChunks;
    }

    public List<SchematicPlacement> getAllSchematicsPlacements() {
        return this.schematicPlacements;
    }

    public List<PlacementPart> getPlacementPartsInChunk(int chunkX, int chunkZ) {
        return (List)this.touchedVolumesInChunk.getOrDefault(ChunkPos.asLong((int)chunkX, (int)chunkZ), Collections.emptyList());
    }

    public List<PlacementPart> getAllPlacementsTouchingChunk(BlockPos pos) {
        return (List)this.touchedVolumesInChunk.getOrDefault(ChunkPos.asLong((int)(pos.getX() >> 4), (int)(pos.getZ() >> 4)), Collections.emptyList());
    }

    public int getTouchedChunksCount() {
        return this.touchedVolumesInChunk.size();
    }

    protected void onPlacementAdded() {
        StatusInfoRenderer.getInstance().startOverrideDelay();
    }

    public void addSchematicPlacement(SchematicPlacement placement, boolean printMessages) {
        if (!this.schematicPlacements.contains(placement)) {
            this.schematicPlacements.add(placement);
            this.addTouchedChunksFor(placement);
            this.onPlacementAdded();
            if (printMessages) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)StringUtils.translate((String)"litematica.message.schematic_placement_created", (Object[])new Object[]{placement.getName()}), (Object[])new Object[0]);
                if (Configs.InfoOverlays.WARN_DISABLED_RENDERING.getBooleanValue()) {
                    String hotkeyVal;
                    String hotkeyName;
                    String configName;
                    ConfigHotkey hotkey;
                    LayerMode mode = DataManager.getRenderLayerRange().getLayerMode();
                    if (mode != LayerMode.ALL) {
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.warn.layer_mode_currently_at", (Object[])new Object[]{mode.getDisplayName()});
                    }
                    if (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_ALL_RENDERING;
                        configName = Configs.Visuals.ENABLE_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.main_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_BLOCK_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_blocks_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                }
            }
        } else if (printMessages) {
            InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.duplicate_schematic_placement", (Object[])new Object[0]);
        }
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement) {
        return this.removeSchematicPlacement(placement, true);
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement, boolean update) {
        if (this.selectedPlacement == placement) {
            this.selectedPlacement = null;
        }
        if (placement.hasVerifier()) {
            placement.getSchematicVerifier().reset();
        }
        boolean ret = this.schematicPlacements.remove(placement);
        this.removeTouchedChunksFor(placement);
        if (ret) {
            placement.onRemoved();
            if (update) {
                this.onPlacementModified(placement);
            }
        }
        return ret;
    }

    public List<SchematicPlacement> getAllPlacementsOfSchematic(LitematicaSchematic schematic) {
        ArrayList<SchematicPlacement> list = new ArrayList<SchematicPlacement>();
        for (SchematicPlacement placement : this.schematicPlacements) {
            if (placement.getSchematic() != schematic) continue;
            list.add(placement);
        }
        return list;
    }

    public void removeAllPlacementsOfSchematic(LitematicaSchematic schematic) {
        boolean removed = false;
        for (int i = 0; i < this.schematicPlacements.size(); ++i) {
            SchematicPlacement placement = this.schematicPlacements.get(i);
            if (placement.getSchematic() != schematic) continue;
            if (placement.hasVerifier()) {
                placement.getSchematicVerifier().reset();
            }
            removed |= this.removeSchematicPlacement(placement, false);
            --i;
        }
        if (removed) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    @Nullable
    public SchematicPlacement getSelectedSchematicPlacement() {
        return this.selectedPlacement;
    }

    public void setSelectedSchematicPlacement(@Nullable SchematicPlacement placement) {
        if (placement == null || this.schematicPlacements.contains(placement)) {
            this.selectedPlacement = placement;
            OverlayRenderer.getInstance().updatePlacementCache();
            DataManager.setMaterialList(null);
        }
    }

    protected void addTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<ChunkPos> chunks = placement.getTouchedChunks();
            for (ChunkPos pos : chunks) {
                if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                    this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
                    this.updateTouchedBoxesInChunk(pos);
                }
                this.chunksToUnload.remove(pos.toLong());
            }
            this.markChunksForRebuild(placement);
            this.onPlacementModified(placement);
        }
    }

    protected void removeTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<ChunkPos> chunks = placement.getTouchedChunks();
            Iterator<ChunkPos> it = chunks.iterator();
            while (it.hasNext()) {
                ChunkPos pos = it.next();
                this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
                this.updateTouchedBoxesInChunk(pos);
                if (this.schematicsTouchingChunk.containsKey((Object)pos)) continue;
                this.chunksToUnload.add(pos.toLong());
                it.remove();
            }
            this.markChunksForRebuild(chunks);
        }
    }

    void onPrePlacementChange(SchematicPlacement placement) {
        this.chunksPreChange.clear();
        this.chunksPreChange.addAll(placement.getTouchedChunks());
    }

    void onPostPlacementChange(SchematicPlacement placement) {
        Set<ChunkPos> chunksPost = placement.getTouchedChunks();
        HashSet<ChunkPos> toRebuild = new HashSet<ChunkPos>(chunksPost);
        this.chunksPreChange.removeAll(chunksPost);
        for (ChunkPos pos : this.chunksPreChange) {
            this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
            this.updateTouchedBoxesInChunk(pos);
            if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                this.chunksToUnload.add(pos.toLong());
                continue;
            }
            toRebuild.add(pos);
        }
        for (ChunkPos pos : chunksPost) {
            if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
            }
            this.updateTouchedBoxesInChunk(pos);
        }
        this.markChunksForRebuild(toRebuild);
        this.onPlacementModified(placement);
    }

    protected void updateTouchedBoxesInChunk(ChunkPos pos) {
        long chunkPosLong = pos.toLong();
        this.touchedVolumesInChunk.remove(chunkPosLong);
        List placements = this.schematicsTouchingChunk.get((Object)pos);
        if (!placements.isEmpty()) {
            for (SchematicPlacement placement : placements) {
                ImmutableMap<String, IntBoundingBox> boxMap;
                if (!placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.RENDERING_ENABLED) || (boxMap = placement.getBoxesWithinChunk(pos.x, pos.z)).isEmpty()) continue;
                List list = (List)this.touchedVolumesInChunk.computeIfAbsent(chunkPosLong, p -> new ArrayList());
                for (Map.Entry entry : boxMap.entrySet()) {
                    list.add(new PlacementPart(placement, (String)entry.getKey(), (IntBoundingBox)entry.getValue()));
                }
            }
        }
    }

    public void markAllPlacementsOfSchematicForRebuild(LitematicaSchematic schematic) {
        for (SchematicPlacement placement : this.schematicPlacements) {
            if (placement.getSchematic() != schematic) continue;
            this.markChunksForRebuild(placement);
        }
    }

    public void markChunksForRebuild(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            this.markChunksForRebuild(placement.getTouchedChunks());
        }
    }

    void markChunksForRebuild(Collection<ChunkPos> chunks) {
        this.chunksToRebuild.addAll(chunks);
        this.chunkRebuildQueue.addAll(chunks);
    }

    public void markChunkForRebuild(ChunkPos pos) {
        this.chunksToRebuild.add(pos);
        this.chunkRebuildQueue.add(pos);
    }

    protected void onPlacementModified(SchematicPlacement placement) {
        if (placement.isEnabled()) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    public boolean changeSelection(Level world, Entity entity, int maxDistance) {
        if (this.schematicPlacements.size() > 0) {
            RayTraceUtils.RayTraceWrapper trace = RayTraceUtils.getWrappedRayTraceFromEntity(world, entity, maxDistance);
            SchematicPlacement placement = this.getSelectedSchematicPlacement();
            if (placement != null) {
                placement.setSelectedSubRegionName(null);
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_SUBREGION || trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                this.setSelectedSchematicPlacement(trace.getHitSchematicPlacement());
                boolean selectSubRegion = Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld();
                String subRegionName = selectSubRegion ? trace.getHitSchematicPlacementRegionName() : null;
                this.getSelectedSchematicPlacement().setSelectedSubRegionName(subRegionName);
                return true;
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.MISS) {
                this.setSelectedSchematicPlacement(null);
                return true;
            }
        }
        return false;
    }

    public void setPositionOfCurrentSelectionToRayTrace(Minecraft mc, double maxDistance) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
            HitResult trace = RayTraceUtils.getRayTraceFromEntity((Level)mc.level, entity, false, maxDistance);
            if (trace.getType() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = ((BlockHitResult)trace).getBlockPos();
            if (!mc.player.isShiftKeyDown()) {
                pos = pos.relative(((BlockHitResult)trace).getDirection());
            }
            this.setPositionOfCurrentSelectionTo(pos, mc);
        }
    }

    public void setPositionOfCurrentSelectionTo(BlockPos pos, Minecraft mc) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            boolean movingBox;
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            boolean bl = movingBox = schematicPlacement.getSelectedSubRegionPlacement() != null;
            if (movingBox) {
                schematicPlacement.moveSubRegionTo(schematicPlacement.getSelectedSubRegionName(), pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                String posStr = String.format("x: %d, y: %d, z: %d", pos.getX(), pos.getY(), pos.getZ());
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_subregion_to", (Object[])new Object[]{posStr});
            } else {
                BlockPos old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                if (!old.equals((Object)schematicPlacement.getOrigin())) {
                    String posStrOld = String.format("x: %d, y: %d, z: %d", old.getX(), old.getY(), old.getZ());
                    String posStrNew = String.format("x: %d, y: %d, z: %d", pos.getX(), pos.getY(), pos.getZ());
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_placement_origin", (Object[])new Object[]{posStrOld, posStrNew});
                }
            }
        }
    }

    public void nudgePositionOfCurrentSelection(Direction direction, int amount) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            SubRegionPlacement placement = schematicPlacement.getSelectedSubRegionPlacement();
            if (placement != null) {
                BlockPos old = PositionUtils.getTransformedBlockPos(placement.getPos(), schematicPlacement.getMirror(), schematicPlacement.getRotation());
                old = old.offset((Vec3i)schematicPlacement.getOrigin());
                schematicPlacement.moveSubRegionTo(placement.getName(), old.relative(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            } else {
                BlockPos old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(old.relative(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            }
        }
    }

    public void pasteCurrentPlacementToWorld(Minecraft mc) {
        this.pastePlacementToWorld(this.getSelectedSchematicPlacement(), mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, Minecraft mc) {
        this.pastePlacementToWorld(schematicPlacement, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, Minecraft mc) {
        this.pastePlacementToWorld(schematicPlacement, changedBlocksOnly, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, boolean printMessage, Minecraft mc) {
        if (mc.player != null && EntityUtils.isCreativeMode((Player)mc.player)) {
            if (schematicPlacement != null) {
                LayerRange range = DataManager.getRenderLayerRange();
                if (Configs.Generic.PASTE_TO_MCFUNCTION.getBooleanValue()) {
                    PasteToCommandsListener cl = new PasteToCommandsListener(schematicPlacement, changedBlocksOnly);
                    GuiConfirmAction screen = new GuiConfirmAction(320, "Confirm paste to command files", (IConfirmationListener)cl, null, "Are you sure you want to paste the current placement as setblock commands into command/mcfunction files?", new Object[0]);
                    GuiBase.openGui((Screen)screen);
                } else if (!mc.hasSingleplayerServer() || Configs.Generic.PASTE_USING_COMMANDS_IN_SP.getBooleanValue()) {
                    if (EntitiesDataStorage.getInstance().hasServuxServer() && Configs.Generic.PASTE_USING_SERVUX.getBooleanValue()) {
                        Litematica.debugLog("Found a Servux server, I am sending the Schematic Placement to it.", new Object[0]);
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.paste_with_servux", (Object[])new Object[0]);
                        CompoundTag nbt = schematicPlacement.toNbt(true);
                        nbt.putString("Task", "LitematicaPaste");
                        ServuxLitematicaHandler.getInstance().encodeClientData(ServuxLitematicaPacket.ResponseC2SStart(nbt));
                    } else {
                        TaskPasteSchematicPerChunkCommand task = new TaskPasteSchematicPerChunkCommand(Collections.singletonList(schematicPlacement), range, changedBlocksOnly);
                        TaskScheduler.getInstanceClient().scheduleTask(task, Configs.Generic.COMMAND_TASK_INTERVAL.getIntegerValue());
                        if (printMessage) {
                            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                        }
                    }
                } else if (mc.hasSingleplayerServer()) {
                    TaskPasteSchematicPerChunkDirect task = new TaskPasteSchematicPerChunkDirect(Collections.singletonList(schematicPlacement), range, changedBlocksOnly);
                    TaskScheduler.getInstanceServer().scheduleTask(task, Configs.Generic.COMMAND_TASK_INTERVAL.getIntegerValue());
                    if (printMessage) {
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                    }
                }
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
        }
    }

    public void clear() {
        this.schematicPlacements.clear();
        this.selectedPlacement = null;
        this.schematicsTouchingChunk.clear();
        this.touchedVolumesInChunk.clear();
        this.chunksPreChange.clear();
        this.chunksToRebuild.clear();
        this.chunkRebuildQueue.clear();
        this.chunksToUnload.clear();
        this.visibleChunks.clear();
        SchematicHolder.getInstance().clearLoadedSchematics();
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.schematicPlacements.size() > 0) {
            JsonArray arr = new JsonArray();
            int selectedIndex = 0;
            boolean indexValid = false;
            for (SchematicPlacement placement : this.schematicPlacements) {
                JsonObject objPlacement;
                if (!placement.shouldBeSaved() || (objPlacement = placement.toJson()) == null) continue;
                arr.add((JsonElement)objPlacement);
                if (this.selectedPlacement == placement) {
                    indexValid = true;
                    continue;
                }
                if (indexValid) continue;
                ++selectedIndex;
            }
            obj.add("placements", (JsonElement)arr);
            if (indexValid) {
                obj.add("selected", (JsonElement)new JsonPrimitive((Number)selectedIndex));
                obj.add("origin_selected", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
        }
        return obj;
    }

    public void loadFromJson(JsonObject obj) {
        this.clear();
        if (JsonUtils.hasArray((JsonObject)obj, (String)"placements")) {
            JsonArray arr = obj.get("placements").getAsJsonArray();
            int index = JsonUtils.hasInteger((JsonObject)obj, (String)"selected") ? obj.get("selected").getAsInt() : -1;
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                JsonElement el = arr.get(i);
                if (el.isJsonObject()) {
                    SchematicPlacement placement = SchematicPlacement.fromJson(el.getAsJsonObject());
                    if (placement == null) continue;
                    this.addSchematicPlacement(placement, false);
                    continue;
                }
                index = -1;
            }
            if (index >= 0 && index < this.schematicPlacements.size()) {
                this.selectedPlacement = this.schematicPlacements.get(index);
            }
        }
        OverlayRenderer.getInstance().updatePlacementCache();
    }

    public static class PlacementPart {
        public final SchematicPlacement placement;
        public final String subRegionName;
        public final IntBoundingBox bb;

        public PlacementPart(SchematicPlacement placement, String subRegionName, IntBoundingBox bb) {
            this.placement = placement;
            this.subRegionName = subRegionName;
            this.bb = bb;
        }

        public SchematicPlacement getPlacement() {
            return this.placement;
        }

        public String getSubRegionName() {
            return this.subRegionName;
        }

        public IntBoundingBox getBox() {
            return this.bb;
        }
    }

    private static class PasteToCommandsListener
    implements IConfirmationListener {
        private final SchematicPlacement schematicPlacement;
        private final boolean changedBlocksOnly;

        public PasteToCommandsListener(SchematicPlacement schematicPlacement, boolean changedBlocksOnly) {
            this.schematicPlacement = schematicPlacement;
            this.changedBlocksOnly = changedBlocksOnly;
        }

        public boolean onActionConfirmed() {
            LayerRange range = DataManager.getRenderLayerRange();
            TaskPasteSchematicSetblockToMcfunction task = new TaskPasteSchematicSetblockToMcfunction(Collections.singletonList(this.schematicPlacement), range, this.changedBlocksOnly);
            TaskScheduler.getInstanceClient().scheduleTask(task, 1);
            return true;
        }

        public boolean onActionCancelled() {
            return true;
        }
    }
}

