/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.config.Configs;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class FakeLightingProvider
extends LevelLightEngine {
    private final FakeLightingView lightingView = new FakeLightingView();
    private static final DataLayer chunkNibbleArray = new DataLayer(15);

    public FakeLightingProvider(LightChunkGetter chunkProvider) {
        super(chunkProvider, false, false);
    }

    public LayerLightEventListener getLayerListener(LightLayer type) {
        return this.lightingView;
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        return Configs.Visuals.RENDER_FAKE_LIGHTING_LEVEL.getIntegerValue();
    }

    public static DataLayer getChunkNibbleArray() {
        return chunkNibbleArray;
    }

    public boolean lightOnInColumn(long sectionPos) {
        return true;
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer lightType, SectionPos pos) {
        return LayerLightSectionStorage.SectionType.LIGHT_ONLY;
    }

    public String getDebugData(LightLayer lightType, SectionPos pos) {
        return Integer.toString(1);
    }

    public static class FakeLightingView
    implements LayerLightEventListener {
        @Nullable
        public DataLayer getDataLayerData(SectionPos pos) {
            return chunkNibbleArray;
        }

        public int getLightValue(BlockPos pos) {
            return Configs.Visuals.RENDER_FAKE_LIGHTING_LEVEL.getIntegerValue();
        }

        public void checkBlock(BlockPos pos) {
        }

        public void propagateLightSources(ChunkPos chunkPos) {
        }

        public boolean hasLightWork() {
            return false;
        }

        public int runLightUpdates() {
            return 0;
        }

        public void updateSectionStatus(SectionPos pos, boolean notReady) {
        }

        public void setLightEnabled(ChunkPos chunkPos, boolean bl) {
        }
    }
}

