/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class WorldSchematic
extends Level {
    protected static final ResourceKey<Level> REGISTRY_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"litematica", (String)"schematic_world"));
    protected final Minecraft mc;
    protected final ChunkManagerSchematic chunkManagerSchematic;
    protected Holder<Biome> biome;
    @Nullable
    protected final WorldRendererSchematic worldRenderer;
    protected int nextEntityId;
    protected int entityCount;
    private final TickRateManager tickManager;
    private final Holder<DimensionType> dimensionType;
    private DimensionSpecialEffects dimensionEffects = new DimensionSpecialEffects.OverworldEffects();

    public WorldSchematic(WritableLevelData properties, @Nonnull RegistryAccess registryManager, Holder<DimensionType> dimension, @Nullable WorldRendererSchematic worldRenderer) {
        super(properties, REGISTRY_KEY, !registryManager.equals((Object)RegistryAccess.EMPTY) ? registryManager : SchematicWorldHandler.INSTANCE.getRegistryManager(), dimension, true, false, 0L, 0);
        this.mc = Minecraft.getInstance();
        if (this.mc == null || this.mc.level == null) {
            throw new RuntimeException("WorldSchematic invoked when MinecraftClient.getInstance() or mc.world is null");
        }
        this.worldRenderer = worldRenderer;
        this.chunkManagerSchematic = new ChunkManagerSchematic(this);
        this.dimensionType = dimension;
        if (!registryManager.equals((Object)RegistryAccess.EMPTY)) {
            this.setDimension(registryManager);
        } else {
            this.setDimension(this.mc.level.registryAccess());
        }
        this.tickManager = new TickRateManager();
    }

    public String toString() {
        return "SchematicWorld[" + REGISTRY_KEY.location().toString() + "]";
    }

    private void setDimension(RegistryAccess registryManager) {
        registryManager.lookup(Registries.DIMENSION_TYPE).ifPresent(entryLookup -> {
            Holder nether = entryLookup.get(BuiltinDimensionTypes.NETHER).orElse(null);
            Holder end = entryLookup.get(BuiltinDimensionTypes.END).orElse(null);
            this.biome = nether != null && this.dimensionType.equals((Object)nether) ? WorldUtils.getWastes((RegistryAccess)registryManager) : (end != null && this.dimensionType.equals((Object)end) ? WorldUtils.getTheEnd((RegistryAccess)registryManager) : WorldUtils.getPlains((RegistryAccess)registryManager));
        });
        this.dimensionEffects = DimensionSpecialEffects.forType((DimensionType)((DimensionType)this.dimensionType.value()));
    }

    public ChunkManagerSchematic getChunkProvider() {
        return this.getChunkManager();
    }

    public ChunkManagerSchematic getChunkManager() {
        return this.chunkManagerSchematic;
    }

    public TickRateManager tickRateManager() {
        return this.tickManager;
    }

    @Nullable
    public MapItemSavedData getMapData(MapId id) {
        return null;
    }

    public void setMapData(MapId id, MapItemSavedData state) {
    }

    public MapId getFreeMapId() {
        return null;
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public int getRegularEntityCount() {
        return this.entityCount;
    }

    public LevelChunk getChunkAt(BlockPos pos) {
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
    }

    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus status, boolean required) {
        return this.getChunk(chunkX, chunkZ);
    }

    public Holder<Biome> getUncachedNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.biome;
    }

    public int getSeaLevel() {
        return 0;
    }

    public boolean setBlock(BlockPos pos, BlockState newState, int flags) {
        if (pos.getY() < this.getMinY() || pos.getY() >= this.getMaxY()) {
            return false;
        }
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4).setBlockState(pos, newState, false) != null;
    }

    public boolean addFreshEntity(Entity entity) {
        int chunkZ;
        int chunkX = Mth.floor((double)(entity.getX() / 16.0));
        if (!this.chunkManagerSchematic.hasChunk(chunkX, chunkZ = Mth.floor((double)(entity.getZ() / 16.0)))) {
            return false;
        }
        entity.setId(this.nextEntityId++);
        ChunkSchematic chunk = this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return false;
        }
        chunk.addEntity(entity);
        ++this.entityCount;
        return true;
    }

    public void unloadedEntities(int count) {
        this.entityCount -= count;
    }

    @Nullable
    public Entity getEntity(int id) {
        return null;
    }

    public Collection<PartEntity<?>> dragonParts() {
        return List.of();
    }

    public List<? extends Player> players() {
        return ImmutableList.of();
    }

    public long getGameTime() {
        return this.mc.level != null ? this.mc.level.getGameTime() : 0L;
    }

    public Scoreboard getScoreboard() {
        return this.mc.level != null ? this.mc.level.getScoreboard() : null;
    }

    public RecipeAccess recipeAccess() {
        return this.mc.level != null ? this.mc.level.recipeAccess() : null;
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return null;
    }

    public List<Entity> getEntities(@Nullable Entity except, AABB box, Predicate<? super Entity> predicate) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        List<ChunkSchematic> chunks = this.getChunksWithinBox(box);
        for (ChunkSchematic chunk : chunks) {
            chunk.getEntityList().forEach(e -> {
                if (e != except && box.intersects(e.getBoundingBox()) && predicate.test((Entity)e)) {
                    entities.add((Entity)e);
                }
            });
        }
        return entities;
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> arg, AABB box, Predicate<? super T> predicate) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity e2 : this.getEntities((Entity)null, box, (Predicate<? super Entity>)((Predicate<Entity>)e -> true))) {
            Entity t = (Entity)arg.tryCast((Object)e2);
            if (t == null || !predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public List<ChunkSchematic> getChunksWithinBox(AABB box) {
        int minX = Mth.floor((double)(box.minX / 16.0));
        int minZ = Mth.floor((double)(box.minZ / 16.0));
        int maxX = Mth.floor((double)(box.maxX / 16.0));
        int maxZ = Mth.floor((double)(box.maxZ / 16.0));
        ArrayList<ChunkSchematic> chunks = new ArrayList<ChunkSchematic>();
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                ChunkSchematic chunk = this.chunkManagerSchematic.getChunkIfExists(cx, cz);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public void setBlocksDirty(BlockPos pos, BlockState stateOld, BlockState stateNew) {
        if (stateNew != stateOld) {
            this.scheduleChunkRenders(pos.getX() >> 4, pos.getZ() >> 4);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        if (this.worldRenderer != null) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkZ);
        }
    }

    public int getMinY() {
        return this.mc.level != null ? this.mc.level.getMinY() : -64;
    }

    public int getHeight() {
        return this.mc.level != null ? this.mc.level.getHeight() : 384;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getMinSectionY() {
        return this.getMinY() >> 4;
    }

    public int getMaxSectionY() {
        return this.getMaxY() >> 4;
    }

    public int getSectionsCount() {
        return this.getMaxSectionY() - this.getMinSectionY();
    }

    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.getY());
    }

    public boolean isOutsideBuildHeight(int y) {
        return y < this.getMinY() || y >= this.getMaxY();
    }

    public int getSectionIndex(int y) {
        return (y >> 4) - (this.getMinY() >> 4);
    }

    public int getSectionIndexFromSectionY(int coord) {
        return coord - (this.getMinY() >> 4);
    }

    public int getSectionYFromSectionIndex(int index) {
        return index + (this.getMinY() >> 4);
    }

    public Holder<DimensionType> getDimensionType() {
        return this.dimensionType;
    }

    public DimensionSpecialEffects getDimensionEffects() {
        return this.dimensionEffects;
    }

    public float getShade(Direction direction, boolean shaded) {
        boolean darkened = this.getDimensionEffects().constantAmbientLight();
        if (!shaded) {
            return darkened ? 0.9f : 1.0f;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (darkened) {
                    yield 0.9f;
                }
                yield 0.5f;
            }
            case Direction.UP -> {
                if (darkened) {
                    yield 0.9f;
                }
                yield 1.0f;
            }
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
        };
    }

    public LevelLightEngine getLightEngine() {
        return this.getChunkManager().getLightEngine();
    }

    public void sendBlockUpdated(BlockPos blockPos_1, BlockState blockState_1, BlockState blockState_2, int flags) {
    }

    public void destroyBlockProgress(int entityId, BlockPos pos, int progress) {
    }

    public void globalLevelEvent(int eventId, BlockPos pos, int data) {
    }

    public void levelEvent(@Nullable Player entity, int id, BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> event, Vec3 emitterPos, GameEvent.Context emitter) {
    }

    public void playSeededSound(@Nullable Player except, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@javax.annotation.Nullable Player except, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void addParticle(ParticleOptions particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void explode(@Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, Level.ExplosionInteraction explosionSourceType, ParticleOptions smallParticle, ParticleOptions largeParticle, Holder<SoundEvent> soundEvent) {
    }

    public void playLocalSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
    }

    public void playSound(Player player, BlockPos pos, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void playSeededSound(@javax.annotation.Nullable Player except, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void playSound(Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void playSound(@Nullable Player player, Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch) {
    }

    public RegistryAccess registryAccess() {
        if (this.mc != null && this.mc.level != null) {
            return this.mc.level.registryAccess();
        }
        if (!SchematicWorldHandler.INSTANCE.getRegistryManager().equals((Object)RegistryAccess.EMPTY)) {
            return SchematicWorldHandler.INSTANCE.getRegistryManager();
        }
        return RegistryAccess.EMPTY;
    }

    public PotionBrewing potionBrewing() {
        if (this.mc != null && this.mc.level != null) {
            return this.mc.level.potionBrewing();
        }
        return PotionBrewing.EMPTY;
    }

    public FuelValues fuelValues() {
        return null;
    }

    public void setDayTimeFraction(float f) {
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public void setDayTimePerTick(float f) {
    }

    public FeatureFlagSet enabledFeatures() {
        if (this.mc != null && this.mc.level != null) {
            return this.mc.level.enabledFeatures();
        }
        return FeatureFlagSet.of();
    }

    public String gatherChunkSourceStats() {
        return "Chunks[SCH] W: " + this.getChunkManager().gatherStats() + " E: " + this.getRegularEntityCount();
    }

    public void gameEvent(@Nullable Entity entity, Holder<GameEvent> event, Vec3 pos) {
    }

    public void gameEvent(@Nullable Entity entity, Holder<GameEvent> event, BlockPos pos) {
    }

    public void gameEvent(ResourceKey<GameEvent> event, BlockPos pos, @Nullable GameEvent.Context emitter) {
    }
}

