package fi.dy.masa.litematica.render;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.hud.debug.DebugHudEntry;
import net.minecraft.client.gui.hud.debug.DebugHudLines;
import net.minecraft.util.Identifier;
import net.minecraft.world.World;
import net.minecraft.world.chunk.WorldChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.DebugHudUtils;
import fi.dy.masa.litematica.Reference;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.DebugHudMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;

public class LitematicaDebugHud implements DebugHudEntry
{
	public static final Identifier LITEMATICA_DEBUG = Identifier.of(Reference.MOD_ID, "litematica_renderer");
	public static final Identifier SECTION_ID = Identifier.ofVanilla(Reference.MOD_ID);
	public static final LitematicaDebugHud INSTANCE = new LitematicaDebugHud();
	private boolean left;

	private LitematicaDebugHud()
	{
		this.left = true;
	}

	public DebugHudMode getMode()
	{
		return (DebugHudMode) Configs.Generic.DEBUG_HUD_MODE.getOptionListValue();
	}

	public void checkConfig()
	{
		MinecraftClient mc = MinecraftClient.getInstance();
		if (mc.debugHudEntryList == null) return;

		if (this.getMode() == DebugHudMode.VANILLA)
		{
			DebugHudUtils.register(LITEMATICA_DEBUG, LitematicaDebugHud.INSTANCE);
		}
		else if (this.getMode() != DebugHudMode.VANILLA)
		{
			DebugHudUtils.unregister(LITEMATICA_DEBUG);
		}
	}

	public boolean isLeft()
	{
		return this.left;
	}

	public void toggleRight()
	{
		this.left = false;
	}

	public void toggleLeft()
	{
		this.left = true;
	}

//	public boolean isDefaultProfile()
//	{
//		MinecraftClient mc = MinecraftClient.getInstance();
//		if (mc.debugHudEntryList == null) return false;
//
//		List<Identifier> vis = new ArrayList<>(mc.debugHudEntryList.visibleEntries);
//		Set<Identifier> def = DebugHudEntries.PROFILES.get(DebugProfileType.DEFAULT).keySet();
//
//		for (Identifier entry : def)
//		{
//			vis.remove(entry);
//		}
//
//		return (vis.size() == 1 && vis.getFirst() == LITEMATICA_DEBUG);
//	}

	@Override
	public void render(@Nonnull DebugHudLines lines, @Nullable World world, @Nullable WorldChunk clientChunk, @Nullable WorldChunk chunk)
	{
		if (this.getMode() == DebugHudMode.NONE)
		{
			return;
		}

		List<String> list = LitematicaDebugHud.INSTANCE.getDebugLines();

		if (!list.isEmpty())
		{
			lines.addLinesToSection(SECTION_ID, list);
		}
	}

	@Override
	public boolean canShow(boolean reducedDebugInfo)
	{
		return true;
	}

	public List<String> getDebugLines()
	{
		WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
		List<String> list = new ArrayList<>();
		String pre = GuiBase.TXT_GOLD;
		String red = GuiBase.TXT_RED;
		String rst = GuiBase.TXT_RST;

		if (worldSchematic != null)
		{
			// Loaded
			Pair<String, String> pair = EntityUtils.getEntityDebug();

			WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();

			String str = String.format("E: %02d TE: %02d C: %02d, CT: %02d, CV: %02d",
			                           worldSchematic.getRegularEntityCount(),
			                           worldSchematic.getChunkProvider().getTileEntityCount(),
			                           worldSchematic.getChunkProvider().getLoadedChunkCount(),
			                           DataManager.getSchematicPlacementManager().getTouchedChunksCount(),
			                           DataManager.getSchematicPlacementManager().getLastVisibleChunksCount()
			);

			if (this.isLeft())
			{
				list.add(String.format("%s[Litematica]%s %s",
				                       pre, rst,
				                       renderer.getDebugInfoRenders()
				));

				list.add(String.format("%s[Litematica]%s %s %s",
				                       pre, rst,
				                       renderer.getDebugInfoEntities(),
				                       str
				));

				if (!pair.getLeft().isEmpty())
				{
					list.add(String.format("%s[%s]%s %s",
					                       pre, pair.getLeft(),
					                       rst, pair.getRight()
					));
				}
			}
			else
			{
				list.add(String.format("%s %s[Litematica]%s",
				                       renderer.getDebugInfoRenders(),
				                       rst+pre, rst
				));

				list.add(String.format("%s %s %s[Litematica]%s",
				                       str,
				                       renderer.getDebugInfoEntities(),
				                       rst+pre, rst
				));

				if (!pair.getLeft().isEmpty())
				{
					list.add(String.format("%s %s[%s]%s",
					                       pair.getRight(),
					                       rst+pre, pair.getLeft(),
					                       rst
					));
				}
			}
		}
		else
		{
			// Not loaded
			if (this.isLeft())
			{
				list.add(String.format("%s[Litematica]%s %s",
				                       pre, rst+red,
				                       StringUtils.translate("litematica.gui.message.debug_hud.not_loaded")
				));
			}
			else
			{
				list.add(String.format("%s%s %s[Litematica]%s",
				                       red,
				                       StringUtils.translate("litematica.gui.message.debug_hud.not_loaded"),
				                       rst+pre, rst
				));

			}
		}

		return list;
	}
}
