/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.event;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.compat.jade.JadeCompat;
import fi.dy.masa.litematica.data.CachedTagManager;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.render.LitematicaDebugHud;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.datafix.fixes.BlockStateData;

public class WorldLoadListener
implements IWorldLoadListener {
    public void onWorldLoadImmutable(RegistryAccess.Frozen immutable) {
        SchematicWorldHandler.INSTANCE.setDynamicRegistryManager(immutable);
    }

    public void onWorldLoadPre(@Nullable ClientLevel worldBefore, @Nullable ClientLevel worldAfter, Minecraft mc) {
        if (worldBefore != null) {
            DataManager.save();
        }
        if (worldAfter != null) {
            JadeCompat.checkForJade();
            EntitiesDataStorage.getInstance().onWorldPre();
            DataManager.getInstance().onWorldPre(worldAfter.registryAccess());
        }
    }

    public void onWorldLoadPost(@Nullable ClientLevel worldBefore, @Nullable ClientLevel worldAfter, Minecraft mc) {
        SchematicWorldHandler.INSTANCE.recreateSchematicWorld(worldAfter == null);
        DataManager.getInstance().reset(worldAfter == null);
        EntitiesDataStorage.getInstance().reset(worldAfter == null);
        if (worldAfter != null) {
            DataManager.load();
            Litematica.debugLog("onWorldLoadPost(): Init BlockStateFlattening DataFixer [Test: {}]", BlockStateData.upgradeBlock((String)"minecraft:air"));
            SchematicConversionMaps.computeMaps();
            EntitiesDataStorage.getInstance().onWorldJoin();
            CachedTagManager.startCache();
            LitematicaDebugHud.INSTANCE.checkConfig();
        } else {
            DataManager.clear();
        }
    }
}

