/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.DebugHudMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.game.DebugHudUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LitematicaDebugHud
implements DebugScreenEntry {
    public static final ResourceLocation LITEMATICA_DEBUG = ResourceLocation.fromNamespaceAndPath((String)"litematica", (String)"litematica_renderer");
    public static final ResourceLocation SECTION_ID = ResourceLocation.withDefaultNamespace((String)"litematica");
    public static final LitematicaDebugHud INSTANCE = new LitematicaDebugHud();
    private boolean left = true;

    private LitematicaDebugHud() {
    }

    public DebugHudMode getMode() {
        return (DebugHudMode)Configs.Generic.DEBUG_HUD_MODE.getOptionListValue();
    }

    public void checkConfig() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.debugEntries == null) {
            return;
        }
        if (this.getMode() == DebugHudMode.VANILLA) {
            DebugHudUtils.register((ResourceLocation)LITEMATICA_DEBUG, (DebugScreenEntry)INSTANCE);
        } else if (this.getMode() != DebugHudMode.VANILLA) {
            DebugHudUtils.unregister((ResourceLocation)LITEMATICA_DEBUG);
        }
    }

    public boolean isLeft() {
        return this.left;
    }

    public void toggleRight() {
        this.left = false;
    }

    public void toggleLeft() {
        this.left = true;
    }

    public void display(@Nonnull DebugScreenDisplayer lines, @Nullable Level world, @Nullable LevelChunk clientChunk, @Nullable LevelChunk chunk) {
        if (this.getMode() == DebugHudMode.NONE) {
            return;
        }
        List<String> list = INSTANCE.getDebugLines();
        if (!list.isEmpty()) {
            lines.addToGroup(SECTION_ID, list);
        }
    }

    public boolean isAllowed(boolean reducedDebugInfo) {
        return true;
    }

    public List<String> getDebugLines() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        ArrayList<String> list = new ArrayList<String>();
        String pre = GuiBase.TXT_GOLD;
        String red = GuiBase.TXT_RED;
        String rst = GuiBase.TXT_RST;
        if (worldSchematic != null) {
            Pair<String, String> pair = EntityUtils.getEntityDebug();
            WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            String str = String.format("E: %02d TE: %02d C: %02d, CT: %02d, CV: %02d", worldSchematic.getRegularEntityCount(), worldSchematic.getChunkProvider().getTileEntityCount(), worldSchematic.getChunkProvider().getLoadedChunksCount(), DataManager.getSchematicPlacementManager().getTouchedChunksCount(), DataManager.getSchematicPlacementManager().getLastVisibleChunksCount());
            if (this.isLeft()) {
                list.add(String.format("%s[Litematica]%s %s", pre, rst, renderer.getDebugInfoRenders()));
                list.add(String.format("%s[Litematica]%s %s %s", pre, rst, renderer.getDebugInfoEntities(), str));
                if (!((String)pair.getLeft()).isEmpty()) {
                    list.add(String.format("%s[%s]%s %s", pre, pair.getLeft(), rst, pair.getRight()));
                }
            } else {
                list.add(String.format("%s %s[Litematica]%s", renderer.getDebugInfoRenders(), rst + pre, rst));
                list.add(String.format("%s %s %s[Litematica]%s", str, renderer.getDebugInfoEntities(), rst + pre, rst));
                if (!((String)pair.getLeft()).isEmpty()) {
                    list.add(String.format("%s %s[%s]%s", pair.getRight(), rst + pre, pair.getLeft(), rst));
                }
            }
        } else if (this.isLeft()) {
            list.add(String.format("%s[Litematica]%s %s", pre, rst + red, StringUtils.translate((String)"litematica.gui.message.debug_hud.not_loaded", (Object[])new Object[0])));
        } else {
            list.add(String.format("%s%s %s[Litematica]%s", red, StringUtils.translate((String)"litematica.gui.message.debug_hud.not_loaded", (Object[])new Object[0]), rst + pre, rst));
        }
        return list;
    }
}

