/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

public class BufferAllocatorCache
implements AutoCloseable {
    protected static final List<ChunkSectionLayer> BLOCK_LAYERS = ChunkRenderLayers.BLOCK_RENDER_LAYERS;
    protected static final List<RenderType> RENDER_LAYERS = ChunkRenderLayers.RENDER_LAYERS;
    protected static final List<OverlayRenderType> TYPES = ChunkRenderLayers.TYPES;
    protected static final int EXPECTED_TOTAL_SIZE = BLOCK_LAYERS.stream().mapToInt(ChunkSectionLayer::bufferSize).sum() + RENDER_LAYERS.stream().mapToInt(RenderType::bufferSize).sum() + TYPES.stream().mapToInt(OverlayRenderType::getExpectedBufferSize).sum();
    private final ConcurrentHashMap<ChunkSectionLayer, ByteBufferBuilder> blockCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<RenderType, ByteBufferBuilder> layerCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> overlayCache = new ConcurrentHashMap();
    private boolean clear = true;

    protected BufferAllocatorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocateCache() {
        ConcurrentHashMap<Object, ByteBufferBuilder> concurrentHashMap;
        for (ChunkSectionLayer chunkSectionLayer : BLOCK_LAYERS) {
            if (this.blockCache.containsKey(chunkSectionLayer)) {
                this.blockCache.get(chunkSectionLayer).close();
            }
            concurrentHashMap = this.blockCache;
            synchronized (concurrentHashMap) {
                this.blockCache.put(chunkSectionLayer, new ByteBufferBuilder(chunkSectionLayer.bufferSize()));
            }
        }
        for (RenderType renderType : RENDER_LAYERS) {
            if (this.layerCache.containsKey(renderType)) {
                this.layerCache.get(renderType).close();
            }
            concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.put(renderType, new ByteBufferBuilder(renderType.bufferSize()));
            }
        }
        for (OverlayRenderType overlayRenderType : TYPES) {
            if (this.overlayCache.containsKey((Object)overlayRenderType)) {
                this.overlayCache.get((Object)overlayRenderType).close();
            }
            concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.put(overlayRenderType, new ByteBufferBuilder(overlayRenderType.getExpectedBufferSize()));
            }
        }
        this.clear = true;
    }

    protected boolean hasBufferByBlockLayer(ChunkSectionLayer layer) {
        return this.blockCache.containsKey(layer);
    }

    protected boolean hasBufferByLayer(RenderType layer) {
        return this.layerCache.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(OverlayRenderType type) {
        return this.overlayCache.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferBuilder getBufferByBlockLayer(ChunkSectionLayer layer) {
        this.clear = false;
        ConcurrentHashMap<ChunkSectionLayer, ByteBufferBuilder> concurrentHashMap = this.blockCache;
        synchronized (concurrentHashMap) {
            return this.blockCache.computeIfAbsent(layer, l -> new ByteBufferBuilder(l.bufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferBuilder getBufferByLayer(RenderType layer) {
        this.clear = false;
        ConcurrentHashMap<RenderType, ByteBufferBuilder> concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            return this.layerCache.computeIfAbsent(layer, l -> new ByteBufferBuilder(l.bufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferBuilder getBufferByOverlay(OverlayRenderType type) {
        this.clear = false;
        ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            return this.overlayCache.computeIfAbsent(type, t -> new ByteBufferBuilder(t.getExpectedBufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByBlockLayer(ChunkSectionLayer layer) {
        try {
            ConcurrentHashMap<ChunkSectionLayer, ByteBufferBuilder> concurrentHashMap = this.blockCache;
            synchronized (concurrentHashMap) {
                this.blockCache.remove(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByLayer(RenderType layer) {
        try {
            ConcurrentHashMap<RenderType, ByteBufferBuilder> concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.remove(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByType(OverlayRenderType type) {
        try {
            ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.remove((Object)type).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isClear() {
        return this.clear;
    }

    protected void resetAll() {
        try {
            this.blockCache.values().forEach(ByteBufferBuilder::discard);
            this.layerCache.values().forEach(ByteBufferBuilder::discard);
            this.overlayCache.values().forEach(ByteBufferBuilder::discard);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear = true;
    }

    protected void clearAll() {
        try {
            this.blockCache.values().forEach(ByteBufferBuilder::clear);
            this.layerCache.values().forEach(ByteBufferBuilder::clear);
            this.overlayCache.values().forEach(ByteBufferBuilder::clear);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAll() {
        ArrayList<ByteBufferBuilder> allocators;
        ConcurrentHashMap<Object, ByteBufferBuilder> concurrentHashMap = this.blockCache;
        synchronized (concurrentHashMap) {
            allocators = new ArrayList<ByteBufferBuilder>(this.blockCache.values());
            this.blockCache.clear();
        }
        concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            allocators.addAll(this.layerCache.values());
            this.layerCache.clear();
        }
        concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            allocators.addAll(this.overlayCache.values());
            this.overlayCache.clear();
        }
        allocators.forEach(ByteBufferBuilder::close);
        this.clear = true;
    }

    @Override
    public void close() {
        this.closeAll();
    }
}

