/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.litematica.render.schematic.BufferAllocatorCache;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.malilib.mixin.render.IMixinBufferBuilder;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

public class BufferBuilderCache
implements AutoCloseable {
    private final ConcurrentHashMap<ChunkSectionLayer, BufferBuilder> blockBufferBuilders = new ConcurrentHashMap();
    private final ConcurrentHashMap<RenderType, BufferBuilder> layerBufferBuilders = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, BufferBuilder> overlayBufferBuilders = new ConcurrentHashMap();

    protected BufferBuilderCache() {
    }

    protected boolean hasBufferByBlockLayer(ChunkSectionLayer layer) {
        return this.blockBufferBuilders.containsKey(layer);
    }

    protected boolean hasBufferByLayer(RenderType layer) {
        return this.layerBufferBuilders.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(OverlayRenderType type) {
        return this.overlayBufferBuilders.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferBuilder getBufferByBlockLayer(ChunkSectionLayer layer, @Nonnull BufferAllocatorCache allocators) {
        ConcurrentHashMap<ChunkSectionLayer, BufferBuilder> concurrentHashMap = this.blockBufferBuilders;
        synchronized (concurrentHashMap) {
            return this.blockBufferBuilders.computeIfAbsent(layer, key -> new BufferBuilder(allocators.getBufferByBlockLayer((ChunkSectionLayer)key), key.pipeline().getVertexFormatMode(), key.pipeline().getVertexFormat()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferBuilder getBufferByLayer(RenderType layer, @Nonnull BufferAllocatorCache allocators) {
        ConcurrentHashMap<RenderType, BufferBuilder> concurrentHashMap = this.layerBufferBuilders;
        synchronized (concurrentHashMap) {
            return this.layerBufferBuilders.computeIfAbsent(layer, key -> new BufferBuilder(allocators.getBufferByLayer((RenderType)key), key.mode(), key.format()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferBuilder getBufferByOverlay(OverlayRenderType type, @Nonnull BufferAllocatorCache allocators) {
        ConcurrentHashMap<OverlayRenderType, BufferBuilder> concurrentHashMap = this.overlayBufferBuilders;
        synchronized (concurrentHashMap) {
            return this.overlayBufferBuilders.computeIfAbsent(type, key -> new BufferBuilder(allocators.getBufferByOverlay((OverlayRenderType)((Object)key)), key.getDrawMode(), key.getVertexFormat()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        ArrayList<BufferBuilder> buffers;
        Object object = this.blockBufferBuilders;
        synchronized (object) {
            buffers = new ArrayList<BufferBuilder>(this.blockBufferBuilders.values());
            this.blockBufferBuilders.clear();
        }
        object = this.layerBufferBuilders;
        synchronized (object) {
            buffers.addAll(this.layerBufferBuilders.values());
            this.layerBufferBuilders.clear();
        }
        object = this.overlayBufferBuilders;
        synchronized (object) {
            buffers.addAll(this.overlayBufferBuilders.values());
            this.overlayBufferBuilders.clear();
        }
        for (BufferBuilder buffer : buffers) {
            MeshData built;
            if (!((IMixinBufferBuilder)buffer).malilib_isBuilding() || (built = buffer.build()) == null) continue;
            built.close();
        }
    }

    @Override
    public void close() throws Exception {
        this.clearAll();
    }
}

